    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <div class="col-sm-6 border-block mb-4">
                <h2 class="mb-2"><?= _('Plugin and Agent Setup') ?></h2>
                <p><?= _('You will need to set up WLSAgent on your WebLogic server in order to monitor it.You may or may not also need NCPA installed on the server, depending on your monitoring preferences') ?></p>
                <ul class="list-group list-group-numbered">
                    <li class="list-group-item"><a href="<?= $wlsagent_package ?>" target="_blank"><?= _("Download the WLS Agent") ?></a></li>
                    <li class="list-group-item ncpa-only visually-hidden"><a href="<?= $NCPA_download_url ?>" target="_blank"><?= _('Download and install the latest version of NCPA') ?></a></li>
                    <li class="list-group-item ncpa-only visually-hidden"><a href="<?= $java_weblogic_plugin_url ?>" target="_blank"><?= _('Install the Java Application Server Plugin') ?></a></li>
                    <li class="list-group-item">
                        <?= _('Additional documentation for ') ?><a href="<?= $NCPA_docs_url ?>" target="_blank"><?= _('NCPA') ?></a>
                        <?= _(' and for ') ?><a href="<?= $java_weblogic_docs_url ?>" target="_blank"><?= _('monitoring application servers') ?></a>
                    </li>
                </ul>
            </div>

            <h2 class="mb-2"><?= _('WebLogic Server Information') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="os" class="form-label form-item-required"><?= _('Access Method') ?> <?= xi6_info_tooltip(_('Choose -Direct HTTP Connection- (WLS Agent) or the -Remote Agent- (NCPA)')) ?></label>
                    <div class="input-group position-relative">
                        <select name="remote" id="remote" class="form-select monitor rounded" placeholder="<?= _("Select System") ?> " required>
                            <option value="wget" <?= is_selected($remote, "wget") ?>><?= _('Direct HTTP connection') ?></option>
                            <option value="NCPA" <?= is_selected($remote, "NCPA") ?>><?= _('Remote Agent (NCPA)') ?></option>
                        </select>
                        <div class="invalid-feedback">
                            Please select System
                        </div>
                        <i id="os_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _("Address") ?> <?= xi6_info_tooltip(_("The hostname/IP address of your WebLogic instance.")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($ip_address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter DNS Hostname/IP Address") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the Address") ?>
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="hostname" class="form-label form-item-required"><?= _('Host Name') ?> <?= xi6_info_tooltip(_("The name you want associated with this check. Defaults to Address.")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Access WebLogic via:") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the Host Name") ?>
                        </div>
                        <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="WLSAgent_port" class="form-label form-item-required"><?= _("WLSAgent Port") ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="WLSAgent_port" id="WLSAgent_port" value="<?= encode_form_val($WLSAgent_port) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter WLSAgent Port") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the WLSAgent Port") ?>
                        </div>
                        <i id="WLSAgent_port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="JMX_T3_port" class="form-label form-item-required"><?= _("JMX T3 Port") ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="JMX_T3_port" id="JMX_T3_port" value="<?= encode_form_val($JMX_T3_port) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter JMX T3 Port") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the JMX T3 Port") ?>
                        </div>
                        <i id="JMX_T3_port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="username" class="form-label form-item-required"><?= _('WebLogic Username') ?> <?= xi6_info_tooltip(_('The username for the WebLogic domain to monitor')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter WebLogic Username") ?>" required>
                        <div class="invalid-feedback">
                            <?= _("Please enter the Weblogic Username") ?>
                        </div>
                        <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
                <div class="col-sm">
                    <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                    <label for="changePassword" class="form-check-label bold"><?= _("Change WebLogic Password") ?> <?= xi6_info_tooltip(_("Use to change the WebLogic Password, otherwise, the existing WebLogic Password will be preserved.")) ?></label>
                </div>
            </div>

            <div id="setPassword" class="row mb-2">
                <div class="col-sm-6">
                    <label for="password" class="form-label form-item-required"><?= _('WebLogic Password') ?> <?= xi6_info_tooltip(_('The password for the WebLogic user above')) ?></label>
                    <div class="input-group">
                        <input type="password" name="password" id="password" value="<?= encode_form_val($password) ?>" class="usermacro-detection form-control rounded-start" autocomplete="off" placeholder="<?= _("Enter WebLogic Password") ?>"  required>
                        <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Show") ?>">
                            <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                            <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </button>
                        <div class="invalid-feedback">
                            <?= _("Please enter the Weblogic Password") ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="ncpa-only visually-hidden">
                <h2 class="mt-4 mb-2"> <?= _("NCPA Information") ?></h2>

                <div class="row mb-2">
                    <div class="col-sm-6">
                        <label for="port" class="form-label form-item-required"><?= _("NCPA Listener Port") ?> </label>
                        <div class="input-group position-relative">
                            <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter NCPA Listener Port") ?>" required>
                            <div class="invalid-feedback">
                                <?= _("Please enter the NCPA Listener Port") ?>
                            </div>
                            <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-sm-6">
                        <label for="token" class="form-label form-item-required"><?= _("NCPA Token") ?> </label>
                        <div class="input-group position-relative">
                            <input type="text" name="token" id="token" value="<?= encode_form_val($token) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter NCPA Token") ?>" required>
                            <div class="invalid-feedback">
                                <?= _("Please enter the NCPA Token") ?>
                            </div>
                            <i id="token_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

<?php /* For some reason, $('#xxx').attr('required') is only working with ('required', true), in this script. */ ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#remote").change(function () {
                if ($(this).val() === "wget") {
                    $(".ncpa-only").addClass('visually-hidden');
                    $(".ncpa-only").prop('hidden', true);
                    $('#port').removeAttr('required');
                    $('#token').removeAttr('required');
                } else {
                    // using NCPA
                    $(".ncpa-only").removeClass('visually-hidden');
                    $(".ncpa-only").prop('hidden', false);
                    $('#port').attr('required', true);
                    $('#token').attr('required', true);
                }
            });

            // Initialize
            if ($("#remote").val() === "wget") {
                $(".ncpa-only").addClass('visually-hidden');
                $(".ncpa-only").prop('hidden', true);
                $('#port').removeAttr('required');
                $('#token').removeAttr('required');
            } else {
                $(".ncpa-only").removeClass('visually-hidden');
                $(".ncpa-only").prop('hidden', false);
                $('#port').attr('required', true);
                $('#token').attr('required', true);
            }
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
