    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <h2 class="mb-2"><?= _('Remote Host Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="address" class="form-label"><?= _('IP Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="address" id="address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address") ?>" readonly="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _("Host Name") ?> <?= xi6_info_tooltip(_("The host name you want associated with this check.")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="service_description" class="form-label"><?= _('Service Description') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="service_description" id="service_description" value="<?= encode_form_val($service_description)  ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Service Description") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="service_description_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

<?php
    if ($remote === "JMX") {
?>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="classpath" class="form-label"><?= _('Classpath') ?> <?= xi6_info_tooltip(_('If you need to manually set the classpath, do so here')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="classpath" id="classpath" value="<?= encode_form_val($classpath) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Classpath") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="classpath_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>
<?php
    }
?>
        <div class="row mb-3 mt-4">
            <div class="col-sm">
                <input type="checkbox" id="combine" class="form-check-input" name="combine" <?= is_checked($combine, 'on') ?> >
                <label for="combine" class="form-check-label bold"><?= _('Combine into one service') ?></label>
            </div>
        </div>

<?php
    $MemorySimpleHeap = array('enabled' => 'on', 'warning' => '16', 'critical' => '30', 'unit' => '1073741824');

    if (array_key_exists('MemorySimpleHeap',$serviceargs)) {
        $MemorySimpleHeap = $serviceargs['MemorySimpleHeap'];
    }

    $MemoryEden = array('enabled' => '', 'warning' => '', 'critical' => '');

    if (array_key_exists('MemoryEden',$serviceargs)) {
        $MemoryEden = $serviceargs['MemoryEden'];
    }

    $MemorySurvivor = array('enabled' => '', 'warning' => '', 'critical' => '');

    if (array_key_exists('MemorySurvivor',$serviceargs)) {
        $MemorySurvivor = $serviceargs['MemorySurvivor'];
    }

    $MemoryOld = array('enabled' => '', 'warning' => '', 'critical' => '');

    if (array_key_exists('MemoryOld',$serviceargs)) {
        $MemoryOld = $serviceargs['MemoryOld'];
    }
?>
        <h2 class="mt-4 mb-2"><?= _("Heap-Allocated Memory") ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="heap-unit" class="form-check-label bold select-cf-option"><?= _('Measure these statistics in: ') ?></label>
                <div class="input-group position-relative">
                    <select class="form-select form-select-sm form-control-sm monitor rounded" id="heap-unit" name="serviceargs[MemorySimpleHeap][unit]">
                        <option value="1073741824" <?= is_selected($MemorySimpleHeap['unit'], '1073741824') ?>> <?= _("GiB") ?></option>
                        <option value="1048576" <?= is_selected($MemorySimpleHeap['unit'], '1048576') ?>> <?= _("MiB") ?></option>
                        <option value="1024" <?= is_selected($MemorySimpleHeap['unit'], '1024') ?>> <?= _("KiB") ?></option>
                        <option value="1" <?= is_selected($MemorySimpleHeap['unit'], '1') ?>> <?= _("Bytes") ?></option>
                    </select>
                    <div class="invalid-feedback">
                        Please select the unit of measure.
                    </div>
                    <i id="version_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="simple-heap-enable" class="form-check-input" name="serviceargs[MemorySimpleHeap][enabled]"  <?= is_checked($MemorySimpleHeap['enabled'], 'on') ?> >
                        <label for="simple-heap-enable" class="form-check-label bold"><?= _('Heap-Allocated Memory') ?> <?= xi6_info_tooltip(_('Measures the memory usage of the entire heap')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[MemorySimpleHeap][warning]" name="serviceargs[MemorySimpleHeap][warning]" value="<?= encode_form_val($MemorySimpleHeap['warning']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemorySimpleHeap_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[MemorySimpleHeap][critical]" name="serviceargs[MemorySimpleHeap][critical]" value="<?= encode_form_val($MemorySimpleHeap['critical']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemorySimpleHeap_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="eden-heap-enable" class="form-check-input" name="serviceargs[MemoryEden][enabled]"  <?= is_checked($MemoryEden['enabled'], 'on') ?> >
                        <label for="eden-heap-enable" class="form-check-label bold"><?= _('Eden Space') ?> <?= xi6_info_tooltip(_('Measures the memory usage of objects which have not yet seen garbage collection')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[MemoryEden][warning]" name="serviceargs[MemoryEden][warning]" value="<?= encode_form_val($MemoryEden['warning']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemoryEden_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[MemoryEden][critical]" name="serviceargs[MemoryEden][critical]" value="<?= encode_form_val($MemoryEden['critical']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemoryEden_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="survivor-heap-enable" class="form-check-input" name="serviceargs[MemorySurvivor][enabled]"  <?= is_checked($MemorySurvivor['enabled'], 'on') ?> >
                        <label for="survivor-heap-enable" class="form-check-label bold"><?= _('Survivor/Tenured Space') ?> <?= xi6_info_tooltip(_('Measures the memory usage of the objects which have survived at least one garbage collection cycle')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[MemorySurvivor][warning]" name="serviceargs[MemorySurvivor][warning]" value="<?= encode_form_val($MemorySurvivor['warning']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemorySurvivor_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[MemorySurvivor][critical]" name="serviceargs[MemorySurvivor][critical]" value="<?= encode_form_val($MemorySurvivor['critical']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemorySurvivor_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="oldgen-heap-enable" class="form-check-input" name="serviceargs[MemoryOld][enabled]"  <?= is_checked($MemoryOld['enabled'], 'on') ?> >
                        <label for="oldgen-heap-enable" class="form-check-label bold"><?= _('Old Gen') ?> <?= xi6_info_tooltip(_('Measures the memory usage of the objects which have been moved out of Survivor Space but are still in use')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[MemoryOld][warning]" name="serviceargs[MemoryOld][warning]" value="<?= encode_form_val($MemoryOld['warning']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemoryOld_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[MemoryOld][critical]" name="serviceargs[MemoryOld][critical]" value="<?= encode_form_val($MemoryOld['critical']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemoryOld_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php

    $MemorySimpleNonHeap = array('enabled' => '', 'warning' => '', 'critical' => '', 'unit' => '1073741824');

    if (array_key_exists('MemorySimpleNonHeap',$serviceargs)) {
        $MemorySimpleNonHeap = $serviceargs['MemorySimpleNonHeap'];
    }

    $MemoryCodeCache = array('enabled' => '', 'warning' => '', 'critical' => '');

    if (array_key_exists('MemoryCodeCache',$serviceargs)) {
        $MemoryCodeCache = $serviceargs['MemoryCodeCache'];
    }

    $MemoryCompressedClass = array('enabled' => '', 'warning' => '', 'critical' => '');

    if (array_key_exists('MemoryCompressedClass',$serviceargs)) {
        $MemoryCompressedClass = $serviceargs['MemoryCompressedClass'];
    }

    $MemoryMetaspace = array('enabled' => 'on', 'warning' => '32', 'critical' => '64');

    if (array_key_exists('MemoryMetaspace',$serviceargs)) {
        $MemoryMetaspace = $serviceargs['MemoryMetaspace'];
    }
?>
        <h2 class="mt-4 mb-2"><?= _("Non-Heap-Allocated Memory") ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="nonheap-unit" class="form-check-label bold select-cf-option"><?= _('Measure these statistics in: ') ?></label>
                <div class="input-group position-relative">
                    <select class="form-select form-select-sm form-control-sm monitor rounded" id="nonheap-unit" name="serviceargs[MemorySimpleNonHeap][unit]">
                        <option value="1073741824" <?= is_selected($MemorySimpleNonHeap['unit'], '1073741824') ?>> <?= _("GiB") ?></option>
                        <option value="1048576" <?= is_selected($MemorySimpleNonHeap['unit'], '1048576') ?>> <?= _("MiB") ?></option>
                        <option value="1024" <?= is_selected($MemorySimpleNonHeap['unit'], '1024') ?>> <?= _("KiB") ?></option>
                        <option value="1" <?= is_selected($MemorySimpleNonHeap['unit'], '1') ?>> <?= _("Bytes") ?></option>
                    </select>
                    <div class="invalid-feedback">
                        Please select the unit of measure.
                    </div>
                    <i id="version_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="simple-nonheap-enable" class="form-check-input" name="serviceargs[MemorySimpleNonHeap][enabled]"  <?= is_checked($MemorySimpleNonHeap['enabled'], 'on') ?> >
                        <label for="simple-nonheap-enable" class="form-check-label bold"><?= _('Simple Non-Heap-Allocated Memory') ?> <?= xi6_info_tooltip(_('Measures the memory usage of everything not on the heap')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[MemorySimpleNonHeap][warning]" name="serviceargs[MemorySimpleNonHeap][warning]" value="<?= encode_form_val($MemorySimpleNonHeap['warning']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemorySimpleNonHeap_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[MemorySimpleNonHeap][critical]" name="serviceargs[MemorySimpleNonHeap][critical]" value="<?= encode_form_val($MemorySimpleNonHeap['critical']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemorySimpleNonHeap_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="codecache-nonheap-enable" class="form-check-input" name="serviceargs[MemoryCodeCache][enabled]"  <?= is_checked($MemoryCodeCache['enabled'], 'on') ?> >
                        <label for="codecache-nonheap-enable" class="form-check-label bold"><?= _('Code Cache') ?> <?= xi6_info_tooltip(_('Measures the memory usage of the JIT-compiled code')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[MemoryCodeCache][warning]" name="serviceargs[MemoryCodeCache][warning]" value="<?= encode_form_val($MemoryCodeCache['warning']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemoryCodeCache_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[MemoryCodeCache][critical]" name="serviceargs[MemoryCodeCache][critical]" value="<?= encode_form_val($MemoryCodeCache['critical']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemoryCodeCache_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="compressedclass-nonheap-enable" class="form-check-input" name="serviceargs[MemoryCompressedClass][enabled]"  <?= is_checked($MemoryCompressedClass['enabled'], 'on') ?> >
                        <label for="compressedclass-nonheap-enable" class="form-check-label bold"><?= _('Compressed Class Space') ?> <?= xi6_info_tooltip(sprintf(_('Measures the memory usage of the compressed classes in your %s instance'), $noun_short)) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[MemoryCompressedClass][warning]" name="serviceargs[MemoryCompressedClass][warning]" value="<?= encode_form_val($MemoryCompressedClass['warning']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemoryCompressedClass_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[MemoryCompressedClass][critical]" name="serviceargs[MemoryCompressedClass][critical]" value="<?= encode_form_val($MemoryCompressedClass['critical']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemoryCompressedClass_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="metaspace-nonheap-enable" class="form-check-input" name="serviceargs[MemoryMetaspace][enabled]"  <?= is_checked($MemoryMetaspace['enabled'], 'on') ?> >
                        <label for="metaspace-nonheap-enable" class="form-check-label bold"><?= _('Metaspace') ?> <?= xi6_info_tooltip(sprintf(_('Measures the memory usage of the class metadata in your %s instance'), $noun_short)) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[MemoryMetaspace][warning]" name="serviceargs[MemoryMetaspace][warning]" value="<?= encode_form_val($MemoryMetaspace['warning']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemoryMetaspace_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[MemoryMetaspace][critical]" name="serviceargs[MemoryMetaspace][critical]" value="<?= encode_form_val($MemoryMetaspace['critical']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_MemoryMetaspace_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

<?php
    if ($wizard_name === 'java_tomcat') {

        $requestproc = 0;

        if (array_key_exists("requestproc", $serviceargs)) {
            $requestproc = $serviceargs['requestproc'];
        }
?>
        <h2 class="mt-4 mb-2"><?= _("Global Request Processors") ?></h2>
        <p><?= sprintf(_("To find your global request processors' MBean Names, access the %s instance with jconsole."), $noun_short) ?>

        <div class="row">
            <div class="col-sm">
                <label class="form-label"><?= _('Request Processor MBean Name') ?> </label>
            </div>
            <div class="col-sm">
                <label class="form-label"><?= _('Check Type')  ?></label>
            </div>
            <div class="col-sm">
                <label class="form-label"><?= _('Warning Threshold')  ?></label>
            </div>
            <div class="col-sm">
                <label class="form-label"><?= _('Critical Threshold')  ?></label>
            </div>
        </div>

        <div class="adddeleterow">
<?php
        if (is_array($requestproc)) {
            foreach($requestproc as $index => $value_array) {
?>
        <div class="row mb-2">
            <div class="col-sm">
                <div class="input-group position-relative">
                    <input type="text" name="serviceargs[requestproc][<?= $index ?>][on]" id="serviceargs[requestproc][<?= $index ?>][on]" value="<?= encode_form_val($serviceargs['requestproc'][$index]['on']) ?>" class="form-control">
                </div>
            </div>
            <div class="col-sm">
                <div class="input-group position-relative">
                    <select class="form-select form-select-sm form-control-sm monitor rounded" name="serviceargs[requestproc][<?= $index ?>][type]" id="serviceargs[requestproc][<?= $index ?>][type]">
                        <option value="RequestsPerMinute" <?= is_selected($value_array['type'], 'RequestsPerMinute') ?>><?= _('Requests Per Minute') ?></option>
                        <option value="BytesPerMinute" <?= is_selected($value_array['type'], 'BytesPerMinute') ?>><?= _('Bytes Per Minute') ?></option>
                        <option value="BytesPerRequest" <?= is_selected($value_array['type'], 'BytesPerRequest') ?>><?= _('Bytes Per Request') ?></option>
                        <option value="ErrorsPerMinute" <?= is_selected($value_array['type'], 'ErrorsPerMinute') ?>><?= _('Errors Per Minute') ?></option>
                        <option value="ProcessingTimePerRequest" <?= is_selected($value_array['type'], 'ProcessingTimePerRequest') ?>><?= _('Processing Time Per Request') ?></option>
                    </select>
                </div>
            </div>
            <div class="col-sm">
                <div class="input-group position-relative">
                    <input type="text" name="serviceargs[requestproc][<?= $index ?>][warning]" id="serviceargs[requestproc][<?= $index ?>][warning]" value="<?= encode_form_val($value_array['warning']) ?>" class="form-control form-control-sm">
                </div>
            </div>
            <div class="col-sm">
                <div class="input-group position-relative">
                    <input type="text" name="serviceargs[requestproc][<?= $index ?>][critical]" id="serviceargs[requestproc][<?= $index ?>][critical]" value="<?= encode_form_val($value_array['critical']) ?>" class="form-control form-control-sm">
                </div>
            </div>
        </div>
<?php
            }
        } else {
?>
            <div class="row mb-2">
                <div class="col-sm">
                    <div class="input-group position-relative">
                        <input type="text" name="serviceargs[requestproc][0][on]" id="serviceargs[requestproc][0][on]" value="" class="form-control form-control-sm">
                    </div>
                </div>
                <div class="col-sm">
                    <div class="input-group position-relative">
                        <select class="form-select form-select-sm form-control-sm monitor rounded" name="serviceargs[requestproc][0][type]" id="serviceargs[requestproc][0][type]">
                            <option value="RequestsPerMinute"><?= _('Requests Per Minute') ?></option>
                            <option value="BytesPerMinute"><?= _('Bytes Per Minute') ?></option>
                            <option value="BytesPerRequest"><?= _('Bytes Per Request') ?></option>
                            <option value="ErrorsPerMinute"><?= _('Errors Per Minute') ?></option>
                            <option value="ProcessingTimePerRequest"><?= _('Processing Time Per Request') ?></option>
                        </select>
                    </div>
                </div>
                <div class="col-sm">
                    <div class="input-group position-relative">
                        <input type="text" name="serviceargs[requestproc][0][warning]" id="serviceargs[requestproc][0][warning]" value="" class="form-control form-control-sm">
                    </div>
                </div>
                <div class="col-sm">
                    <div class="input-group position-relative">
                        <input type="text" name="serviceargs[requestproc][0][critical]" id="serviceargs[requestproc][0][critical]" value="" class="form-control form-control-sm">
                    </div>
                </div>
            </div>
<?php
        }
    }
?>
        </div> <!-- adddeleterow -->
<?php
    $ProcessCPUUsage = array('enabled' => 'on', 'warning' => '50', 'critical' => '70');

    if (array_key_exists('ProcessCPUUsage',$serviceargs)) {
        $ProcessCPUUsage = $serviceargs['ProcessCPUUsage'];
    }

    $SystemCPUUsage = array('enabled' => 'on', 'warning' => '70', 'critical' => '90');

    if (array_key_exists('SystemCPUUsage',$serviceargs)) {
        $SystemCPUUsage = $serviceargs['SystemCPUUsage'];
    }

    $Uptime = array('enabled' => 'on', 'warning' => '1500:', 'critical' => '300:');

    if (array_key_exists('Uptime',$serviceargs)) {
        $Uptime = $serviceargs['Uptime'];
    }

    $ClassCount = array('enabled' => '', 'warning' => '10000', 'critical' => '50000');

    if (array_key_exists('ClassCount',$serviceargs)) {
        $ClassCount = $serviceargs['ClassCount'];
    }

    $ThreadCount = array('enabled' => '', 'warning' => '150', 'critical' => '190');

    if (array_key_exists('ThreadCount',$serviceargs)) {
        $ThreadCount = $serviceargs['ThreadCount'];
    }
?>
        <h2 class="mt-4 mb-2"><?= _("Other System Statistics") ?></h2>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ProcessCPUUsage-enable" class="form-check-input" name="serviceargs[ProcessCPUUsage][enabled]"  <?= is_checked($ProcessCPUUsage['enabled'], 'on') ?> >
                        <label for="ProcessCPUUsage-enable" class="form-check-label bold"><?= _('JVM CPU Usage') ?> <?= xi6_info_tooltip(_('Measures the CPU Usage incurred by the JVM alone (values are between 0 and 100)')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[ProcessCPUUsage][warning]" name="serviceargs[ProcessCPUUsage][warning]" value="<?= encode_form_val($ProcessCPUUsage['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">&percnt;</span>
                            <i id="serviceargs_ProcessCPUUsage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[ProcessCPUUsage][critical]" name="serviceargs[ProcessCPUUsage][critical]" value="<?= encode_form_val($ProcessCPUUsage['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">&percnt;</span>
                            <i id="serviceargs_ProcessCPUUsage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="SystemCPUUsage-enable" class="form-check-input" name="serviceargs[SystemCPUUsage][enabled]"  <?= is_checked($SystemCPUUsage['enabled'], 'on') ?> >
                        <label for="SystemCPUUsage-enable" class="form-check-label bold"><?= _('System CPU Usage') ?> <?= xi6_info_tooltip(_('Measures the CPU Usage of the system as a whole (values are between 0 and 100)')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[SystemCPUUsage][warning]" name="serviceargs[SystemCPUUsage][warning]" value="<?= encode_form_val($SystemCPUUsage['warning']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">&percnt;</span>
                            <i id="serviceargs_SystemCPUUsage_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[SystemCPUUsage][critical]" name="serviceargs[SystemCPUUsage][critical]" value="<?= encode_form_val($SystemCPUUsage['critical']) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">&percnt;</span>
                            <i id="serviceargs_SystemCPUUsage_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="Uptime-enable" class="form-check-input" name="serviceargs[Uptime][enabled]"  <?= is_checked($Uptime['enabled'], 'on') ?> >
                        <label for="Uptime-enable" class="form-check-label bold"><?= _('Uptime') ?> <?= xi6_info_tooltip(_('Measures the uptime of the JVM in seconds')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[Uptime][warning]" name="serviceargs[Uptime][warning]" value="<?= encode_form_val($Uptime['warning']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_Uptime_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[Uptime][critical]" name="serviceargs[Uptime][critical]" value="<?= encode_form_val($Uptime['critical']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_Uptime_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ClassCount-enable" class="form-check-input" name="serviceargs[ClassCount][enabled]"  <?= is_checked($ClassCount['enabled'], 'on') ?> >
                        <label for="ClassCount-enable" class="form-check-label bold"><?= _('Class Count') ?> <?= xi6_info_tooltip(_('Measures the number of currently-loaded classes in the JVM')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[ClassCount][warning]" name="serviceargs[ClassCount][warning]" value="<?= encode_form_val($ClassCount['warning']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_ClassCount_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[ClassCount][critical]" name="serviceargs[ClassCount][critical]" value="<?= encode_form_val($ClassCount['critical']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_ClassCount_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ThreadCount-enable" class="form-check-input" name="serviceargs[ThreadCount][enabled]"  <?= is_checked($ThreadCount['enabled'], 'on') ?> >
                        <label for="ThreadCount-enable" class="form-check-label bold"><?= _('Thread Count') ?> <?= xi6_info_tooltip(_('Measures the number of active threads in the JVM')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i>
                            </span>
                            <input type="text" id="serviceargs[ThreadCount][warning]" name="serviceargs[ThreadCount][warning]" value="<?= encode_form_val($ThreadCount['warning']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_ThreadCount_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i>
                            </span>
                            <input type="text" id="serviceargs[ThreadCount][critical]" name="serviceargs[ThreadCount][critical]" value="<?= encode_form_val($ThreadCount['critical']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_ThreadCount_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
