    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <h2 class="mb-2"><?= _("Service Information")  ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="service_description" class="form-label"><?= _("Service Description (Prefix)") ?> <?= xi6_info_tooltip(_("The prefix associated with each service produced.")) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="service_description" id="service_description" value="<?= encode_form_val($service_description) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Service Description (Prefix)") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="service_description_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-3 mt-4">
            <div class="col-sm">
                <input type="checkbox" id="combine" class="form-check-input" name="combine" <?= is_checked($combine, 'on') ?> >
                <label for="combine" class="form-check-label bold"><?= _('Combine checks into one service') ?></label>
            </div>
        </div>

<?php
    $jvm = array('enabled' => 'on', 'warning' => '90', 'critical' => '95');

    if (array_key_exists('jvm',$serviceargs)) {
        $jvm = $serviceargs['jvm'];
    }

    $jta = array('enabled' => 'on', 'warning' => '20', 'critical' => '40');

    if (array_key_exists('jta', $serviceargs)) {
        $jta = $serviceargs['jta'];
    }

    $jms_runtime = array('enabled' => 'on', 'warning' => '500', 'critical' => '1000');

    if (array_key_exists('jms_runtime', $serviceargs)) {
        $jms_runtime = $serviceargs['jms_runtime'];
    }

    $thread_pool = array('enabled' => 'on', 'warning' => '5', 'critical' => '10');

    if (array_key_exists('thread_pool', $serviceargs)) {
        $thread_pool = $serviceargs['thread_pool'];
    }
?>
        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4 mb-2"><?= _("Metrics") ?></h2>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="jvm-enable" class="form-check-input" name="serviceargs[jvm][enabled]"  <?= is_checked($jvm['enabled'], 'on') ?> >
                        <label for="jvm-enable" class="form-check-label bold"><?= _('Heap Memory Usage') ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[jvm][warning]" name="serviceargs[jvm][warning]" value="<?= encode_form_val($jvm['warning']) ?>" class="form-control form-control-sm monitor">
		                    <span class="input-group-text">%</span>
                            <i id="serviceargs_jvm_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[jvm][critical]" name="serviceargs[jvm][critical]" value="<?= encode_form_val($jvm['critical']) ?>" class="form-control form-control-sm monitor">
		                    <span class="input-group-text">%</span>
                            <i id="serviceargs_jvm_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="jta-enable" class="form-check-input" name="serviceargs[jta][enabled]"  <?= is_checked($jta['enabled'], 'on') ?> >
                        <label for="jta-enable" class="form-check-label bold"><?= _('JTA Active Connections') ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[jta][warning]" name="serviceargs[jta][warning]" value="<?= encode_form_val($jta['warning']) ?>" class="form-control form-control-sm monitor">
		                    
                            <i id="serviceargs_jta_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[jta][critical]" name="serviceargs[jta][critical]" value="<?= encode_form_val($jta['critical']) ?>" class="form-control form-control-sm monitor">
		                    
                            <i id="serviceargs_jta_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="jms-enable" class="form-check-input" name="serviceargs[jms_runtime][enabled]"  <?= is_checked($jms_runtime['enabled'], 'on') ?> >
                        <label for="jms-enable" class="form-check-label bold"><?= _('JMS Runtime Connections') ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[jms_runtime][warning]" name="serviceargs[jms_runtime][warning]" value="<?= encode_form_val($jms_runtime['warning']) ?>" class="form-control form-control-sm monitor">
		                    
                            <i id="serviceargs_jms_runtime_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[jms_runtime][critical]" name="serviceargs[jms_runtime][critical]" value="<?= encode_form_val($jms_runtime['critical']) ?>" class="form-control form-control-sm monitor">
		                    
                            <i id="serviceargs_jms_runtime_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="thread-pool-enable" class="form-check-input" name="serviceargs[thread_pool][enabled]"  <?= is_checked($thread_pool['enabled'], 'on') ?> >
                        <label for="thread-pool-enable" class="form-check-label bold"><?= _('Stuck Threads') ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" id="serviceargs[thread_pool][warning]" name="serviceargs[thread_pool][warning]" value="<?= encode_form_val($thread_pool['warning']) ?>" class="form-control form-control-sm monitor">
		                    
                            <i id="serviceargs_thread_pool_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" id="serviceargs[thread_pool][critical]" name="serviceargs[thread_pool][critical]" value="<?= encode_form_val($thread_pool['critical']) ?>" class="form-control form-control-sm monitor">
		                    
                            <i id="serviceargs_thread_pool_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

<?php
    $jdbc = 0;

    if (array_key_exists("jdbc", $serviceargs)) {
        $jdbc = $serviceargs['jdbc'];
    }
?>
        <h2 class="mt-4"><?= _("JDBC Waiting Connections") ?></h2>
        <p><?= _("Each name is the datasource's JNDI name. Enter the wildcard (*) to apply the same warning/critical thresholds to all datasources.") ?>

         <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2">
                    <div class="col-sm-4">
                        <label class="form-label bold"><?= _('Datasource Name') ?> </label>
                    </div>
                    <div class="col-sm-3">
                        <label class="form-label"><?= _('Warning')  ?></label>
                    </div>
                    <div class="col-sm-3">
                        <label class="form-label"><?= _('Critical')  ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="adddeleterow">
<?php
    if (is_array($jdbc['on'])) {
        foreach($jdbc["on"] as $index => $not_used) {
?>
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-4 mt-0">
                            <input type="text" name="serviceargs[jdbc][<?= $index ?>][on]" id="serviceargs[jdbc][<?= $index ?>][on]" value="<?= $jdbc['on'][$index] ?>" class="form-control form-control-sm">
                            <i id="serviceargs_jdbc_<?= $index ?>_on_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[jdbc][<?= $index ?>][warning]" name="serviceargs[jdbc][<?= $index ?>][warning]" value="<?= $jdbc['warning'][$index] ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_jdbc_<?= $index ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[jdbc][<?= $index ?>][critical]" name="serviceargs[jdbc][<?= $index ?>][critical]" value="<?= $jdbc['critical'][$index] ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_jdbc_<?= $index ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
        }
    } else {
?>
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-4 mt-0">
                            <input type="text" name="serviceargs[jdbc][0][on]" id="serviceargs[jdbc][0][on]" value="" class="form-control form-control-sm">
                            <i id="serviceargs_jdbc_0_on_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[jdbc][0][warning]" name="serviceargs[jdbc][0][warning]" value="" class="form-control form-control-sm monitor">

                                <i id="serviceargs_jdbc_0_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[jdbc][0][critical]" name="serviceargs[jdbc][0][critical]" value="" class="form-control form-control-sm monitor">

                                <i id="serviceargs_jdbc_0_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div>

<?php
    $component = 0;

    if (array_key_exists("component", $serviceargs)) {
        $component = $serviceargs['component'];
    }
?>
        <h2 class="mt-4"><?= _("Component HTTP Sessions") ?></h2>
        <p><?= _("Each application name is its exact context root. Enter the wildcard (*) to set the same warning/critical thresholds for all applications.") ?>

         <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2">
                    <div class="col-sm-4">
                        <label class="form-label bold"><?= _('Application Name') ?> </label>
                    </div>
                    <div class="col-sm-3">
                        <label class="form-label"><?= _('Warning')  ?></label>
                    </div>
                    <div class="col-sm-3">
                        <label class="form-label"><?= _('Critical')  ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="adddeleterow">
<?php
    if (is_array($component['on'])) {
        foreach($component["on"] as $index => $not_used) {
?>
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-4 mt-0">
                            <input type="text" name="serviceargs[component][<?= $index ?>][on]" id="serviceargs[component][<?= $index ?>][on]" value="<?= $component['on'][$index] ?>" class="form-control form-control-sm">
                            <i id="serviceargs_component_<?= $index ?>_on_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[component][<?= $index ?>][warning]" name="serviceargs[component][<?= $index ?>][warning]" value="<?= $component['warning'][$index] ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_component_<?= $index ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[component][<?= $index ?>][critical]" name="serviceargs[component][<?= $index ?>][critical]" value="<?= $component['critical'][$index] ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_component_<?= $index ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
        }
    } else {
?>
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-4 mt-0">
                            <input type="text" name="serviceargs[component][0][on]" id="serviceargs[component][0][on]" value="" class="form-control form-control-sm">
                            <i id="serviceargs_component_0_on_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[component][0][warning]" name="serviceargs[component][0][warning]" value="" class="form-control form-control-sm monitor">

                                <i id="serviceargs_component_0_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[component][0][critical]" name="serviceargs[component][0][critical]" value="" class="form-control form-control-sm monitor">

                                <i id="serviceargs_component_0_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div>

<?php
    $jms_queue = 0;

    if (array_key_exists("jms_queue", $serviceargs)) {
        $jms_queue = $serviceargs['jms_queue'];
    }
?>
        <h2 class="mt-4"><?= _("JMS Queue Message Count") ?></h2>
        <p><?= _("Each queue name is a JMS resource's WebLogic Name. Enter the wildcard (*) to apply the same warning/critical thresholds to all datasources.") ?>

         <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2">
                    <div class="col-sm-4">
                        <label class="form-label"><?= _('Queue Name') ?> </label>
                    </div>
                    <div class="col-sm-3">
                        <label class="form-label"><?= _('Warning')  ?></label>
                    </div>
                    <div class="col-sm-3">
                        <label class="form-label"><?= _('Critical')  ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="adddeleterow">
<?php
    if (is_array($jms_queue['on'])) {
        foreach($jms_queue["on"] as $index => $not_used) {
?>
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-4 mt-0">
                            <input type="text" name="serviceargs[jms_queue][<?= $index ?>][on]" id="serviceargs[jms_queue][<?= $index ?>][on]" value="<?= $jms_queue['on'][$index] ?>" class="form-control form-control-sm">
                            <i id="serviceargs_jms_queue_<?= $index ?>_on_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[jms_queue][<?= $index ?>][warning]" name="serviceargs[jms_queue][<?= $index ?>][warning]" value="<?= $jms_queue['warning'][$index] ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_jms_queue_<?= $index ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[jms_queue][<?= $index ?>][critical]" name="serviceargs[jms_queue][<?= $index ?>][critical]" value="<?= $jms_queue['critical'][$index] ?>" class="form-control form-control-sm monitor">

                                <i id="serviceargs_jms_queue_<?= $index ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
        }
    } else {
?>
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="col-sm-4 mt-0">
                            <input type="text" name="serviceargs[jms_queue][0][on]" id="serviceargs[jms_queue][0][on]" value="" class="form-control form-control-sm">
                            <i id="serviceargs_jms_queue_0_on_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[jms_queue][0][warning]" name="serviceargs[jms_queue][0][warning]" value="" class="form-control form-control-sm monitor">

                                <i id="serviceargs_jms_queue_0_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[jms_queue][0][critical]" name="serviceargs[jms_queue][0][critical]" value="" class="form-control form-control-sm monitor">

                                <i id="serviceargs_jms_queue_0_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
