<?php
// Get variables that were passed to us
$address = grab_array_var($inargs, "ip_address");
$hostname = grab_array_var($inargs, "hostname");
$password = grab_array_var($inargs, "password");
$password_t = "";

$services = "";
$services_serial = grab_array_var($inargs, "services_serial");
if ($services_serial != "")
    $services = json_decode(base64_decode($services_serial), true);
else
    $services = grab_array_var($inargs, "services");

$serviceargs = "";
$serviceargs_serial = grab_array_var($inargs, "serviceargs_serial");
if ($serviceargs_serial != "")
    $serviceargs = json_decode(base64_decode($serviceargs_serial), true);
else
    $serviceargs = grab_array_var($inargs, "serviceargs");

// Handle name and display name spaces
foreach ($services as $servicename => $value) {
    if (in_array($servicename, array("servicestate", "processstate", "counter"))) {
        foreach ($value as $k => $val) {
            if ($val == "on") {
                // trim spaces front and back
                $serviceargs[$servicename][$k]["name"] = trim($serviceargs[$servicename][$k]["name"]);

                // convert multiple internal spaces to one
                preg_replace('/\s\s+/', ' ', $serviceargs[$servicename][$k]["name"]);
            }
        }
    }
}

// Check for errors
$errors = 0;
$errmsg = array();

if (is_valid_host_name($hostname) == false)
    $errmsg[$errors++] = _("Invalid host name.");

// Require a service discription - allowing no description breaks config
foreach ($services as $servicename => $value) {
    if (in_array($servicename, array("servicestate", "processstate", "counter"))) {
        foreach ($value as $k => $val) {
            if ($val == "on") {
                if ($serviceargs[$servicename][$k]["name"] == "") {
                    if (array_key_exists("service", $serviceargs[$servicename][$k])) {
                        $errmsg[$errors++] = _("You must select a service display name for each service. Create display name for service: " . $serviceargs[$servicename][$k]["service"]);
                    }

                    if (array_key_exists("process", $serviceargs[$servicename][$k])) {
                        $errmsg[$errors++] = _("You must select a service display name for each service. Create display name for process: " . $serviceargs[$servicename][$k]["process"]);
                    }

                    if (array_key_exists("counter", $serviceargs[$servicename][$k])) {
                        $errmsg[$errors++] = _("You must select a service display name for each service. Create display name for performance counter: " . $serviceargs[$servicename][$k]["counter"]);
                    }
                }
            }
        }
    }
}

if (preg_match("/[^a-zA-Z0-9 \.\\\\:_-@]/", $password)) {
    if (!preg_match('/\$USER[0-9]+\$/', $password) && !preg_match('/\$[a-zA-Z]+\$/', $password)) { // Check for user macros
        $errmsg[$errors++] = _("Password contains invalid characters.");
    }
}

if ($errors > 0) {
    $outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
    $result = 1;
}
?>