<?php
//
// Mass Acknowledge Component
// Copyright (c) 2011-2019 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../componenthelper.inc.php');

$massnotification_component_name = "massnotifications";
massnotification_component_init();

////////////////////////////////////////////////////////////////////////
// COMPONENT INIT FUNCTIONS
////////////////////////////////////////////////////////////////////////

function massnotification_component_init()
{
    global $massnotification_component_name;
    $versionok = massnotification_component_checkversion();
    $desc = _("This component allows administrators to submit mass acknowledgements or downtime for
			a list of problem hosts and services. ");

    if (!$versionok) {
        $desc = "<b>" . _("Error: This component requires Nagios XI 2009R1.2B or later.") . "</b>";
    }

    $args = array(
        COMPONENT_NAME => $massnotification_component_name,
        COMPONENT_VERSION => '1.0.0',
        COMPONENT_DATE => '09/25/2023',
        COMPONENT_AUTHOR => "Nagios Enterprises, LLC",
        COMPONENT_DESCRIPTION => $desc,
        COMPONENT_TITLE => _("Mass Toggle Notifications"),
        COMPONENT_REQUIRES_VERSION => 500
    );

    // Register this component with XI
    register_component($massnotification_component_name, $args);

    // Register the addmenu function
    if ($versionok) {
        register_callback(CALLBACK_MENUS_INITIALIZED, 'massnotification_component_addmenu');
    }
}

///////////////////////////////////////////////////////////////////////////////////////////
// MISC FUNCTIONS
///////////////////////////////////////////////////////////////////////////////////////////

function massnotification_component_checkversion()
{
    if (!function_exists('get_product_release'))
        return false;
    if (get_product_release() < 114)
        return false;
    return true;
}

function massnotification_component_addmenu($arg = null)
{
    if (is_readonly_user(0)) {
        return;
    }

    global $massnotification_component_name;
    $urlbase = get_component_url_base($massnotification_component_name);

    $mi = find_menu_item(MENU_HOME, "menu-home-acknowledgements", "id");
    if ($mi == null) {
        return;
    }

    $order = grab_array_var($mi, "order", "");
    if ($order == "") {
        return;
    }

    $neworder = $order + 0.1;

    add_menu_item(MENU_HOME, array(
        "type" => "link",
        "title" => _("Mass Toggle Notifications"),
        "id" => "menu-home-mass-toggle-notification",
        "order" => $neworder,
        "opts" => array(
            "href" => $urlbase . "/index.php"
        )
    ));
}