<?php
//
// Generic Plugin Wizard
// Copyright (c) 2014-2024 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../configwizardhelper.inc.php');
require_once(dirname(__FILE__) . '/../../../config/deployment/includes/utils-deployment.inc.php');

generic_plugin_configwizard_init();

function generic_plugin_configwizard_init() {

    $name = "generic-plugin";
    $args = array(
        CONFIGWIZARD_NAME => $name,
        CONFIGWIZARD_VERSION => "1.0.0",
        CONFIGWIZARD_TYPE => CONFIGWIZARD_TYPE_MONITORING,
        CONFIGWIZARD_DESCRIPTION => _("Generic wizard for every plugin."),
        CONFIGWIZARD_DISPLAYTITLE => _("Generic Wizard"),
        CONFIGWIZARD_FUNCTION => "generic_plugin_configwizard_func",
        CONFIGWIZARD_PREVIEWIMAGE => "generic-plugin.png",
        CONFIGWIZARD_FILTER_GROUPS => array('linux', 'server'),
        CONFIGWIZARD_REQUIRES_VERSION => 70000
    );
    register_configwizard($name, $args);
}

/**
 * @param string $mode
 * @param null   $inargs
 * @param        $outargs
 * @param        $result
 *
 * @return string
 */
function generic_plugin_configwizard_func($mode = "", $inargs = null, &$outargs = null, &$result = null, $extra = array())
{
    global $cfg;

    // Grab core wizard info
    $wizard_name = grab_array_var($inargs, "wizard");
    $wiz_args = get_configwizard_by_name($wizard_name);
    $wizard_title = isset($wiz_args[CONFIGWIZARD_DISPLAYTITLE]) ? $wiz_args[CONFIGWIZARD_DISPLAYTITLE] : '';

    // Initialize return code and output
    $result = 0;
    $output = "";

    // Initialize output args - pass back the same data we got
    $outargs[CONFIGWIZARD_PASSBACK_DATA] = $inargs;

    switch ($mode) {

        case CONFIGWIZARD_MODE_GETSTAGE1HTML:
            $command_name = grab_array_var($inargs, "command_name", "check_example");
            $command_line = grab_array_var($inargs, "command_line", '$USER1$/check_dummy $ARG1$ $ARG2$');
            $plugin = grab_array_var($inargs, "plugin", "check_dummy");
            $host_or_service = grab_array_var($inargs, "host_or_service", 'host');
            $host_name = grab_array_var($inargs, "host_name", "");
            $host_address = grab_array_var($inargs, "host_address", "");
            $service_description = grab_array_var($inargs, "service_description", '');
            $service_host = grab_array_var($inargs, "service_host", '');
            $check_command = grab_array_var($inargs, "check_command", $command_name);
            $check_command = empty($check_command) || (strpos($check_command, $command_name) === false) ? $command_name : $check_command;

            ob_start();
            include __DIR__.'/steps/step1.php';
            $output = ob_get_clean();
            break;

        case CONFIGWIZARD_MODE_VALIDATESTAGE1DATA:
            $command_name = grab_array_var($inargs, "command_name", "");
            $command_line = grab_array_var($inargs, "command_line", "");

            $errors = 0;
            $errmsg = array();

            if (empty($command_name)) {
                $errmsg[$errors++] = _("No command name provided.");
            }

            if (empty($command_line)) {
                $errmsg[$errors++] = _("No command line provided.");
            }

            if ($errors > 0) {
                $outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
                $result = 1;
            }

            break;

        case CONFIGWIZARD_MODE_GETSTAGE2HTML:
            $command_name = grab_array_var($inargs, "command_name", "check_example");
            $command_line = grab_array_var($inargs, "command_line", '$USER1$/check_dummy $ARG1$ $ARG2$');
            $plugin = grab_array_var($inargs, "plugin", "check_dummy");
            $host_or_service = grab_array_var($inargs, "host_or_service", 'host');
            $host_name = grab_array_var($inargs, "host_name", "");
            $host_address = grab_array_var($inargs, "host_address", "");
            $service_description = grab_array_var($inargs, "service_description", '');
            $service_host = grab_array_var($inargs, "service_host", '');
            $check_command = grab_array_var($inargs, "check_command", $command_name);
            $check_command = empty($check_command) || (strpos($check_command, $command_name) === false) ? $command_name : $check_command;

            ob_start();
            include __DIR__.'/steps/step2.php';
            $output = ob_get_clean();
            break;

        case CONFIGWIZARD_MODE_VALIDATESTAGE2DATA:
            $command_name = grab_array_var($inargs, "command_name", "");
            $host_or_service = grab_array_var($inargs, "host_or_service", 'host');
            $host_name = grab_array_var($inargs, "host_name", "");
            $host_address = grab_array_var($inargs, "host_address", "");
            $service_description = grab_array_var($inargs, "service_description", '');
            $service_host = grab_array_var($inargs, "service_host", '');
            $check_command = grab_array_var($inargs, "check_command", $command_name);
            $check_command = empty($check_command) || (strpos($check_command, $command_name) === false) ? $command_name : $check_command;

            $errors = 0;
            $errmsg = array();

            if($host_or_service == "host") {
                if (empty($host_name)) {
                    $errmsg[$errors++] = _("No host name provided.");
                }
                if (empty($host_address)) {
                    $errmsg[$errors++] = _("No host address provided.");
                }
            } else {
                if (empty($service_description)) {
                    $errmsg[$errors++] = _("No service description provided.");
                }
                if (empty($service_host) || $service_host == 'null') {
                    $errmsg[$errors++] = _("No service host name provided.");
                }
            }

            if (empty($check_command)) {
                $errmsg[$errors++] = _("No check command provided.");
            }

            if(strpos($check_command, $command_name) === false) {
                $errmsg[$errors++] = _("Provided check command does not include the command name.");
            }

            if ($errors > 0) {
                $outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
                $result = 1;
            }

            break;

        case CONFIGWIZARD_MODE_GETSTAGE3HTML:
            $command_name = grab_array_var($inargs, "command_name", "check_example");
            $command_line = grab_array_var($inargs, "command_line", '$USER1$/check_dummy $ARG1$ $ARG2$');
            $plugin = grab_array_var($inargs, "plugin", "check_dummy");
            $host_or_service = grab_array_var($inargs, "host_or_service", 'host');
            $host_name = grab_array_var($inargs, "host_name", "");
            $host_address = grab_array_var($inargs, "host_address", "");
            $service_description = grab_array_var($inargs, "service_description", '');
            $service_host = grab_array_var($inargs, "service_host", '');
            $check_command = grab_array_var($inargs, "check_command", $command_name);
            $check_command = empty($check_command) || (strpos($check_command, $command_name) === false) ? $command_name : $check_command;

            ob_start();
?>
            <input type="hidden" id="command_name" name="command_name" value="<?= encode_form_val($command_name) ?>" />
            <input type="hidden" id="command_line" name="command_line" value="<?= encode_form_val($command_line) ?>" />
            <input type="hidden" id="plugin" name="plugin" value="<?= encode_form_val($plugin) ?>" />
            <input type="hidden" id="host_or_service" name="host_or_service" value="<?= encode_form_val($host_or_service) ?>" />
            <input type="hidden" id="host_name" name="host_name" value="<?= encode_form_val($host_name) ?>" />
            <input type="hidden" id="host_address" name="host_address" value="<?= encode_form_val($host_address) ?>" />
            <input type="hidden" id="service_description" name="service_description" value="<?= encode_form_val($service_description) ?>" />
            <input type="hidden" id="service_host" name="service_host" value="<?= encode_form_val($service_host) ?>" />
            <input type="hidden" id="check_command" name="check_command" value="<?= encode_form_val($check_command) ?>" />
<?php
            $output = ob_get_clean();
            break;

        case CONFIGWIZARD_MODE_VALIDATESTAGE3DATA:
            break;

        case CONFIGWIZARD_MODE_GETFINALSTAGEHTML:
            break;

        case CONFIGWIZARD_MODE_GETOBJECTS:
            $command_name = grab_array_var($inargs, "command_name", "");
            $command_line = grab_array_var($inargs, "command_line", "");
            $plugin = grab_array_var($inargs, "plugin", "");
            $host_or_service = grab_array_var($inargs, "host_or_service", 'host');
            $host_name = grab_array_var($inargs, "host_name", "");
            $host_address = grab_array_var($inargs, "host_address", "");
            $service_description = grab_array_var($inargs, "service_description", '');
            $service_host = grab_array_var($inargs, "service_host", '');
            $check_command = grab_array_var($inargs, "check_command", $command_name);
            $check_command = empty($check_command) || (strpos($check_command, $command_name) === false) ? $command_name : $check_command;

            $objs = [];

            $objs[] = [
                'type' => OBJECTTYPE_COMMAND,
                'command_name' => $command_name,
                'command_line' => $command_line
            ];

            if ($host_or_service == 'host') {
                $objs[] = [
                    "type" => OBJECTTYPE_HOST,
                    "host_name" => $host_name,
                    "address" => $host_address,
                    "check_command" => $check_command,
                    "_xiwizard" => $wizard_name,
                ];
            } else {
                $objs[] = [
                    "type" => OBJECTTYPE_SERVICE,
                    "host_name" => $service_host,
                    "address" => $host_address,
                    "service_description" => $service_description,
                    "check_command" => $check_command,
                    "_xiwizard" => $wizard_name,
                ];
            }

            $outargs[CONFIGWIZARD_NAGIOS_OBJECTS] = $objs;
            break;

        default:
            break;
    }

    return $output;
}
