<input type="hidden" id="command_name" name="command_name" value="<?= encode_form_val($command_name) ?>" />
<input type="hidden" id="command_line" name="command_line" value="<?= encode_form_val($command_line) ?>" />
<input type="hidden" id="plugin" name="plugin" value="<?= encode_form_val($plugin) ?>" />

<div class="container m-0 g-0">
    <h2 class="mb-2"><?= _("Configure Your Host or Service") ?></h2>
    <div id="configForm">
        <div class="row mb-2">
            <div style="display: flex; flex-direction: column; gap: 8px; margin-left: 25px;">
                <div>
                    <input type="radio" class="form-check-input" id="host_value" name="host_or_service" value="host" <?= is_checked($host_or_service, 'host') ?>>
                    <label for="host_value" class="form-check-label"><?= _('Host') ?></label>
                </div>
                <div>
                    <input type="radio" class="form-check-input" id="service_value" name="host_or_service" value="service" <?= is_checked($host_or_service, 'service') ?>>
                    <label for="service_value" class="form-check-label"><?= _('Service') ?></label>
                </div>
            </div>
        </div>
        <!-- Hosts -->
        <div id="host_elements">
            <?= wizard_input_text('host_name', _('Host Name'), $host_name) ?>
            <?= wizard_input_text('host_address', _('Host Address'), $host_address) ?>
        </div>
        <!-- Hosts -->
        <!-- Services -->
        <div id="service_elements">
<?php
            $args = array("is_active" => 1);
            $xmlhosts = get_xml_host_objects($args);
            $hosts = [];

            foreach ($xmlhosts->host as $host) {
                $hostname = strval($host->host_name);
                $hostdesc = $hostname;
                $hostalias = strval($host->alias);

                if ($hostalias != $hostname && $hostalias != "") {
                    $hostdesc .= " (".$hostalias.")";
                }
                $hosts[$hostname] = $hostdesc;
            }
            $hosts = array_reverse($hosts);
            echo wizard_select('service_host', _('Host Name'), $hosts, $service_host, _('Select an existing host for the new service.'))
?>
            <?= wizard_input_text('service_description', _('Service Description'), $service_description) ?>
        </div>
        <!-- Services -->
        <?= wizard_input_text('command_line', _('Command Line'), $command_line, "", "", true) ?>
        <div class="mb-3 position-relative">
            <?= wizard_input_text('check_command_input', _('Check Command'), $check_command, 'i.e. ' . $check_command . '!10!20', '', false) ?>
            <div id="check_command_error" class="invalid-feedback" style="display:none;">
            <?= _('Check Command must execute your command: ') ?> <code style="font-size: 1.25em;"><?= htmlspecialchars($check_command) ?></code>
            </div>
        </div>
        <script>
            $(document).ready(function() {
                $('#check_command_input').on('input', function() {
                    var val = $(this).val();
                    var requiredPart = <?= json_encode($check_command) ?>;
                    console.log('Check Command Input:', val, 'Required Part:', requiredPart);
                    if (val.length > 0 && !val.includes(requiredPart)) {
                        $('#check_command_input').addClass('is-invalid');
                        $('#check_command_error').show();
                    } else {
                        $('#check_command_input').removeClass('is-invalid');
                        $('#check_command_error').hide();
                    }
                });
            });
        </script>
    </div>
</div>

<script>
    $(document).ready(function() {
        toggle_host_service()
    })

    $('input[type=radio][name=host_or_service]').on('click', toggle_host_service)

    function toggle_host_service() {
        if ($('#host_value').prop('checked')) {
            $('#host_elements').show()
            $('#service_elements').hide()
        } else {
            $('#host_elements').hide()
            $('#service_elements').show()
        }
    }
</script>


<script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
