    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />
    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" id="snmpcommunity" name="snmpcommunity" value="<?= encode_form_val($snmpcommunity) ?>">

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';

    $services = array();
    if (array_key_exists('printer_wizard_services', $_SESSION)) {
        $services = $_SESSION['printer_wizard_services'];
    }

?>
    <div class="container m-0 g-0">
        <h2 class="mb-2"><?= _('Printer Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Printer Address:') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Printer Address:") ?>" disabled="on">
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label form-item-required"><?= _('Host Name:') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this printer')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name:") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Printer Services') ?></h2>
        <p><?= _('Specify which services you would like to monitor for the device') ?></p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ping" class="form-check-input" name="services[]" value="ping" <?php echo in_array('ping', $services) ? 'checked' : ''; ?> >
                        <label for="ping" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_("Monitors the printer with an ICMP ping. Useful for watching network latency and general uptime of your printer")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="printerstatus" class="form-check-input" name="services[]" value="printerstatus" <?php echo in_array('printerstatus', $services) ? 'checked' : ''; ?>>
                        <label for="printerstatus" class="form-check-label bold"><?= _('Printer Status') ?> <?= xi6_info_tooltip(_("Monitors the status of the printer through it&apos;s JetDirect card. Useful for watching for offline and paper jam issues, etc.")) ?></label>
                    </div>
                    <div class="col-sm-9 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <?= _('SNMP Community') ?>
                            </span>
                            <input style="font-size: 14px" type="password" id="snmpcommunity" name="snmpcommunity" value="<?= encode_form_val($snmpcommunity) ?>" class="w-14 form-control condensed">
		                        <button data-original-title="Hide" type="button"  class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Show") ?>">
                                <span class="material-symbols-outlined md-22 md-pointer" >Visibility</span>
                                    <i id="snmpcommunity_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </button>
                            
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
