    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />
    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Mail Server Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('IP Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter IP Address") ?>" disabled="on">
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label form-item-required"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this mail server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Host Name") ?>" required >
                    <div class="invalid-feedback">
                        <?php echo _("Please enter the IP Address"); ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Services') ?></h2>
        <p><?= _('Specify which services you would like to monitor for the mail server') ?>.</p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[ping]" class="form-check-input" name="services[ping]"  <?= is_checked(checkbox_binary($services['ping']), "1") ?>>
                        <label for="services[ping]" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_('Monitors the server with an ICMP ping. Useful for watching network latency and general uptime.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[smtp]" class="form-check-input" name="services[smtp]"  <?= is_checked(checkbox_binary($services['smtp']), "1") ?>>
                        <label for="services[smtp]" class="form-check-label bold"><?= _('SMTP') ?> <?= xi6_info_tooltip(_('Monitors SMTP service availability.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[imap]" class="form-check-input" name="services[imap]"  <?= is_checked(checkbox_binary($services['imap']), "1") ?>>
                        <label for="services[imap]" class="form-check-label bold"><?= _('IMAP') ?> <?= xi6_info_tooltip(_('Monitors IMAP service availability.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[pop]" class="form-check-input" name="services[pop]"  <?= is_checked(checkbox_binary($services['pop']), "1") ?>>
                        <label for="services[pop]" class="form-check-label bold"><?= _('POP') ?> <?= xi6_info_tooltip(_('Monitors POP service availability.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>


        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[rbl]" class="form-check-input" name="services[rbl]"  <?= is_checked(checkbox_binary($services['rbl']), "1") ?>>
                        <label for="services[rbl]" class="form-check-label bold"><?= _('RBL Blacklist') ?> <?= xi6_info_tooltip(_('Checks to see if your mail server is listed on any public RBLs (real time blackhole lists).')) ?></label>
                    </div>
                    <div class="col-sm-8 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <span class="form-label m-0 ms-1 align-middle"><?= _('Blacklist Servers') ?></span>
                            </span>
                            <input type="text" id="serviceargs[rbl_servers]" name="serviceargs[rbl_servers]" value="<?= encode_form_val($serviceargs['rbl_servers']) ?>" class="form-control form-control-sm monitor">
		                    
                            <i id="serviceargs_rbl_servers_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>