    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="domain_name" value="<?= encode_form_val($address) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
    $services = array();
    if (array_key_exists('dns_query_wizard_services', $_SESSION)) {
        $services = $_SESSION['dns_query_wizard_services'];
    }
?>
    <div class="container m-0 g-0">
        <h2 class="mb-2"><?= _('Query Information') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="domain_name" class="form-label"><?= _('FQDN') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="domain_name" id="domain_name" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter FQDN") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="domain_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip" class="form-label"><?= _('IP Address') ?> <?= xi6_info_tooltip(_('The IP address associated with the FQDN')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="ip" id="ip" value="<?= encode_form_val($ip) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter IP Address") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="ip_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this FQDN')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('DNS Query Options') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="dnsserver" class="form-label"><?= _('DNS Server') ?> <?= xi6_info_tooltip(_('The IP address of the DNS server you would like to use for the query (optional)')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="dnsserver" id="dnsserver" value="<?= encode_form_val($dnsserver) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter DNS Server") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="dnsserver_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="dnsauthority" class="form-check-input" name="dnsauthority"  <?= is_checked($dnsauthority, "on") ?> >
                        <label for="dnsauthority" class="form-check-label bold"><?= _('Authoritative Response') ?> <?= xi6_info_tooltip(_('Require the DNS server specified above to be authoritative for the query.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('DNS Query Services') ?></h2>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="dns" class="form-check-input" name="services[]" value='dns' <?php echo in_array('dns', $services) ? 'checked' : ''; ?>>
                        <label for="dns" class="form-check-label bold"><?= _('DNS Resolution') ?> <?= xi6_info_tooltip(_('Monitors the FQDN to ensure it resolves to a valid IP address')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="dnsip" class="form-check-input" name="services[]" value='dnsip' <?php echo in_array('dnsip', $services) ? 'checked' : ''; ?>>
                        <label for="dnsip" class="form-check-label bold"><?= _('DNS IP Match') ?> <?= xi6_info_tooltip(_('Monitors the FQDN to ensure it resolves to the current known IP address. Helps ensure your DNS does not change unexpectedly, which may mean a security breach has occurred')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
