    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
<?php
    // show an upgrade pymongo message
    if ($check_prereqs == 2) {
?>
            <div class="alert alert-danger w-50">
                <div class="align-items-center d-flex pb-3">
                    <i class="fa fa-exclamation-triangle fa-2x pe-2"></i>
                    <span class="fw-bold pe-2"><?= _('Warning') ?>:</span> <?= _('Update available for pymongo.') ?>
                </div>
                <div class="card card-p">
                    <p class="text-start"><?= _('If your version of MongoDB is newer, you may want to update pymongo using pip:') ?></p>
                    <pre><code>pip install --upgrade pymongo</code></pre>
                </div>
            </div>
<?php
    }
?>
            <h2><?= _('MongoDB Server') ?></h2>
            <p><?= _('Specify the details for connecting to the MongoDB server you want to monitor') ?>.</p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDNS name of the MongoDB server')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label"><?= _('Port') ?> <?= xi6_info_tooltip(_('The port to use to connect to the MongoDB server. Defaults to port 27017')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Port - default 27017") ?>">
                        <div class="invalid-feedback">
                            Please enter the Port
                        </div>
                        <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('Username') ?> <?= xi6_info_tooltip(_('The username used to connect to the database')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Username") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Username
                        </div>
                        <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
                <div class="col-sm">
                    <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                    <label for="changePassword" class="form-check-label bold"><?= _('Change Password') ?> <?= xi6_info_tooltip(_("Use to change the password, otherwise, the existing password will be preserved.")) ?></label>
                </div>
            </div>
            <div id="setPassword" class="row mb-2">
                <div class="col-sm-6">
                    <label for="password" class="form-label form-item-required"><?= _('Password') ?> <?= xi6_info_tooltip(_('The password for the above user')) ?></label>
                    <div class="input-group">
                        <input type="password" name="password" id="password" value="<?= encode_form_val($password) ?>" class="form-control monitor rounded-start" placeholder="<?= _("Enter Password") ?>" required>
                        <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Show") ?>">
                            <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                            <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </button>
                        <div class="invalid-feedback">
                            Please enter the Password
                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
