<?php
//
// Hypermap Dashlet
// Copyright (c) 2008-2020 Nagios Enterprises, LLC. All rights reserved.
//


function hypermap_dashlet($mode = DASHLET_MODE_PREVIEW, $id = "", $args = null)
{

    $output = "";

    if ($args == null)
        $args = array();

    switch ($mode) {
        case DASHLET_MODE_GETCONFIGHTML:
            $output = '';
            break;
        case DASHLET_MODE_OUTBOARD:
        case DASHLET_MODE_INBOARD:
            $random_string = random_string(6);
            $id = "hypermap_" . $random_string;
            $ajaxargs = $args;

            // Build args for javascript
            $n = 0;
            $jargs = "{";
            foreach ($ajaxargs as $var => $val) {
                if ($n > 0)
                    $jargs .= ", ";
                $jargs .= "\"$var\" : \"$val\"";
                $n++;
            }
            $jargs .= "}";

            $output .= '
            <div class="hypermap_dashlet" id="' . $id . '">
            ';

            $output .= hypermap_get_output($args, $random_string);

            $output .= '
            </div>
            ';

            break;
        case DASHLET_MODE_PREVIEW:

            if(!is_neptune()) {
                $imgurl = get_component_url_base() . "hypermap/hypermap_preview.png";
            } else if (get_theme() == 'neptunelight') {
                $imgurl = get_component_url_base() . "hypermap/hypermap_neptune_light_preview.png";
            } else {
                $imgurl = get_component_url_base() . "hypermap/hypermap_neptune_preview.png";
            }

            $output = '
            <img src="' . $imgurl . '">
            ';

            break;
        default:
            break;
    }
    return $output;
}


function hypermap_get_output($args, $id)
{

    $p = get_base_url() . "/includes/components/hypermap/";

    $output = "";

    $type = grab_array_var($args, "type");
    $refresh = grab_array_var($args, "refresh", 60);


    switch ($type) {

        default:

            $font_color = '#494949';
            $theme = get_theme();
            if ($theme == "xi5dark") {
                $font_color = '#BBB';
            }
            else if (is_neptune()) {
                $font_color = 'var(--foreground)';
            }
            

            $output .= '
<!-- CSS Files -->
<link type="text/css" href="' . $p . 'css/base.css" rel="stylesheet" />
<link type="text/css" href="' . $p . 'css/hypermap.css" rel="stylesheet" />

<!--[if IE]><script language="javascript" type="text/javascript" src="' . $p . 'js/Extras/excanvas.js"></script><![endif]-->

<script language="javascript" type="text/javascript" src="' . $p . 'js/jit.js"></script>
<script language="javascript" type="text/javascript" src="' . $p . 'js/hypermap.js"></script>

<script language="javascript" type="text/javascript">
var font_color = "'.$font_color.'";
$(document).ready(function() {

    // Draw initial hypermap
    hypermap_init("' . $id . '");
    
    // Refresh hypermap occassionally
    $("hypermap-container-'. $id .'").everyTime(' . $refresh . '*1000, "timer-hypermap", function(i) {
        hypermap_refresh(i, "' . $id . '");
    });

});
</script>

<div id="hypermap-container-' . $id . '" class="hypermap-container">

<div class="hypermap-center-container" id="hypermap-center-container-' . $id . '">
    <div class="hypermap-infovis" id="hypermap-infovis-' . $id . '"></div>   
</div>

<div id="hypermap-right-container-' . $id .'" class="hypermap-right-container">

<div class="hyper-inner-details" id="hypermap-inner-details-' . $id . '"></div>
';
            if (!get_user_meta(0, 'hypermap_hide_help', 0)) {
                $output .= '
                            <div id="hypermap-help-' . $id . '" class="hypermap-help">
                                <h3>' . _('About This Map') . '</h3>
                                <p>
                                    ' . _('The hypermap displays the current status of network devices (hosts).') . '
                                </p>
                                <p>
                                    ' . _('Click on a node to center it and obtain detailed status information.') . '
                                </p>
                                <p>
                                    <a class="hide-hypermap-help">' . _('Do not show "About This Map"') . '</a>
                                </p>
                            </div>';
            }

            $output .= '
</div>

<div class="hypermap-log" id="hypermap-log-'. $id .'"></div>

</div>          
            ';
            break;
    }

    return $output;
}