var labelType, useGradients, nativeTextSupport, animate;

var hypermap_graphs = {};

(function () {
    var ua = navigator.userAgent,
        iStuff = ua.match(/iPhone/i) || ua.match(/iPad/i),
        typeOfCanvas = typeof HTMLCanvasElement,
        nativeCanvasSupport = (typeOfCanvas == 'object' || typeOfCanvas == 'function'),
        textSupport = nativeCanvasSupport
            && (typeof document.createElement('canvas').getContext('2d').fillText == 'function');
    //I'm setting this based on the fact that ExCanvas provides text support for IE
    //and that as of today iPhone/iPad current text support is lame
    labelType = (!nativeCanvasSupport || (textSupport && !iStuff)) ? 'Native' : 'HTML';
    nativeTextSupport = labelType == 'Native';
    useGradients = nativeCanvasSupport;
    animate = !(iStuff || !nativeCanvasSupport);
})();

var Log = {
    elements: {},
    write: function (text, ID) {
        if (!this.elements[ID]) {
            this.elements[ID] = document.getElementById('hypermap-log-' + ID);
        }
        const elem = this.elements[ID];
        if (elem) {
            elem.innerHTML = text;
            elem.style.display = text === "" ? "none" : "block";
            elem.style.left = (500 - elem.offsetWidth / 2) + 'px';
        }
    }
};


function hypermap_init(ID="") {
    // Get container dimensions
    const container = document.getElementById('hypermap-infovis-' + ID);
    const dashletParent = $(container).closest('div.dashboarddashlet');
    if (dashletParent.length) {
        container.style.height = dashletParent.height() + 'px';
    }
    
    // Function to handle graph resizing
    function resizeGraph() {
        if (!hypermap_graphs[ID]) return;
        
        const width = container.offsetWidth;
        const height = container.offsetHeight;
        
        // Update canvas dimensions
        const canvases = container.getElementsByTagName('canvas');
        for (let i = 0; i < canvases.length; i++) {
            canvases[i].width = width;
            canvases[i].height = height;
        }
        
        // Refresh the graph with new dimensions
        hypermap_graphs[ID].canvas.resize(width, height);
        hypermap_graphs[ID].refresh();
    }

    //init RGraph
    hypermap_graphs[ID] = new $jit.RGraph({
        //Where to append the visualization
        injectInto: 'hypermap-infovis-' + ID,
        
        // Set dimensions dynamically based on container
        width: container.offsetWidth,
        height: container.offsetHeight,
        
        //Optional: create a background canvas that plots
        //concentric circles.
        background: {
            CanvasStyles: {
                strokeStyle: '#ddd'
            }
        },
        //Add navigation capabilities:
        //zooming by scrolling and panning.
        Navigation: {
            enable: true,
            panning: true,
            zooming: 10
        },
        //Set Node and Edge styles.
        Node: {
            overridable: true,
            color: '#B9BCBF',
        },

        Edge: {
            overridable: true,
            color: '#6C6C6C',
            lineWidth: 1.0
        },

        //Enable tips
        Tips: {
            enable: true,
            //add positioning offsets
            offsetX: 20,
            offsetY: 20,
            //implement the onShow method to
            //add content to the tooltip when a node
            //is hovered
            onShow: function (tip, node, isLeaf, domElement) {         
                var html = node.data.info;
                tip.innerHTML = html;
            }
        },

        onBeforeCompute: function (node) {
            Log.write("Centering " + node.name + "...", ID);
            $jit.id('hypermap-inner-details-' + ID).innerHTML = node.data.info + "<BR>" + node.data.statusurl;
        },

        onAfterCompute: function () {
            Log.write("", ID);
        },
        //Add the name of the node in the correponding label
        //and a click handler to move the graph.
        //This method is called once, on label creation.
        onCreateLabel: function (domElement, node) {
            domElement.innerHTML = node.name;
            domElement.onclick = function () {
                hypermap_graphs[ID].onClick(node.id);
            };
        },
        //This method is called right before plotting
        //an edge. This method is useful to change edge styles
        //individually.
        onBeforePlotLine: function (adj) {
            if (adj.nodeTo.data.linecolor) {
                adj.data.$color = adj.nodeTo.data.linecolor;
            }
            if (adj.nodeTo.data.linewidth) {
                adj.data.$lineWidth = adj.nodeTo.data.linewidth;
            }
        },
        //The data properties prefixed with a dollar
        //sign will override the global node style properties.
        onBeforePlotNode: function (node) {
            /*
             if (node.selected) {
             node.data.$color = "#ff0000";
             }
             else
             node.data.$color="#00ff00";
             */
        },

        //Change some label dom properties.
        //This method is called each time a label is plotted.
        onPlaceLabel: function (domElement, node) {
            var style = domElement.style;
            style.display = '';
            style.cursor = 'pointer';

            if (node._depth <= 1) {
                style.fontSize = "1.0em";
                style.color = font_color;

            } else if (node._depth == 2) {
                style.fontSize = "0.9em";
                style.color = "#646464";

            } else {
                style.color = "#9F9F9F";
                style.fontSize = "0.8em";
            }

            var left = parseInt(style.left);
            var w = domElement.offsetWidth;
            style.left = (left - w / 2) + 'px';
        }
    });


    //init data
    var jdata = "{ }";
    var hypermapajaxurl = base_url + '/includes/components/hypermap/index.php';
    $.ajax({
        type: "POST",
        async: false,
        url: hypermapajaxurl,
        data: {mode: 'getdata', nsp: nsp_str},
        success: function (data) {
            jdata = data;
        }
    });
    var json = eval("(" + jdata + ")");
    // Function to check if suffix already exists
    function hasSuffix(str, suffix) {
        return str.endsWith(suffix);
    }

    // Function to add suffix only if it's not already present
    function addIdSuffix(node, suffix) {
        if (node.id && !hasSuffix(node.id, suffix)) {
            node.id = node.id + suffix;
        }
        if (node.children && node.children.length > 0) {
            for (var i = 0; i < node.children.length; i++) {
                addIdSuffix(node.children[i], suffix);
            }
        }
    }

    // Add suffix only if not already present
    const suffix = "-" + ID;
    if (!hasSuffix(json.id, suffix)) {
        json.id = json.id + suffix;
    }
    addIdSuffix(json, suffix);
    //load JSON data
    hypermap_graphs[ID].loadJSON(json);
    //trigger small animation
    hypermap_graphs[ID].graph.eachNode(function (n) {
        var pos = n.getPos();
        pos.setc(-200, -200);
    });
    hypermap_graphs[ID].compute('end');
    hypermap_graphs[ID].fx.animate({
        modes: ['polar'],
        duration: 2000
    });
    
    //append information about the root relations in the right column
    $jit.id('hypermap-inner-details-' + ID).innerHTML = hypermap_graphs[ID].graph.getNode(hypermap_graphs[ID].root).data.info;
    
    // Add resize event listener with debounce
    window.addEventListener('resize', function() {
        clearTimeout(window.resizeTimer);
        window.resizeTimer = setTimeout(resizeGraph, 200);
    });
    
    // Ensure container has proper styling for responsive behavior
    if (container) {
        container.style.position = container.style.position || 'relative';
        container.style.overflow = 'hidden';
    }
}

// refresh graph
// from http://groups.google.com/group/javascript-information-visualization-toolkit/msg/4877c6f24e442fa7
function hypermap_refresh(i, ID="") {
    var graph = hypermap_graphs[ID];
    if (!graph) return;

    var oldrootid = graph.root;
    Log.write("Refreshing map...", ID);

    // get new JSON data via ajax
    var jdata = "{ }";
    var hypermapajaxurl = base_url + '/includes/components/hypermap/index.php'; 
    $.ajax({
        type: "POST",
        async: false,
        url: hypermapajaxurl,
        data: {mode: 'getdata', nsp: nsp_str},
        success: function (data) {
            jdata = data;
        }
    });
    var json = eval("(" + jdata + ")");

    // load new JSON data
    graph.loadJSON(json);

    // restore old root id
    // jit.js line 15709...
    graph.root = oldrootid;

    // call with argument of true to reposition map...
    graph.refresh(true);

    //Log.write("Map refreshed (" + i + ")");
    Log.write("", ID);
}

// Do ajax call to set value to hide the about this map section
$(document).ready(function() {
    $('.hide-hypermap-help').click(function() {
        const helpElement = $(this).closest('.hypermap-help');
        $.get('index.php', { mode: 'hidehelp' }, function() {
            helpElement.hide();
        });
    });  
});
