    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <h2 class="mb-2"><?= _('FTP Server') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this FTP server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('FTP Server Metrics') ?></h2>
        <p><?= _('Check the options you would like to monitor on the FTP server') ?></p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="services[server]" class="form-check-input" name="services[server]"  <?= is_checked(encode_form_val($services['server']), "on") ?> >
                        <label for="services[server]" class="form-check-label bold"><?= _('FTP Server') ?> <?= xi6_info_tooltip(_('Check the FTP server to ensure it can be contacted by clients')) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <span class="form-label m-0 ms-1 align-middle"><?= _('Port') ?></span>
                            </span>
                            <input type="text" id="serviceargs[server_port]" name="serviceargs[server_port]" value="<?= encode_form_val($serviceargs['server_port']) ?>" class="form-control form-control-sm monitor">

                            <i id="serviceargs_server_port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm mt-0">
                        <div class="form-check col-sm-3 mt-0 pt-1">
                            <input type="checkbox" id="serviceargs[server_ssl]" name="serviceargs[server_ssl]" value="" class="form-check-input monitor" <?= is_checked($services['server_ssl'], "on") ?> >
                            <label for="serviceargs[server_ssl]" class="form-check-label bold"><?= _('Use SSL') ?></label>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="row">
                        <div class="form-check col-sm mt-0 mb-1 pt-1">
                            <input type="checkbox" id="services[transfer]" class="form-check-input" name="services[transfer]"  <?= is_checked($services['transfer'], "on") ?> >
                            <label for="services[transfer]" class="form-check-label bold"><?= _('File Transfer') ?> <?= xi6_info_tooltip(_('Check the FTP server to ensure a test file can be uploaded to and deleted from the root directory. Does not support SSL')) ?></label>
                        </div>
                    </div>
                    <div class="row g-0 p-0">
                        <div class="col-sm-4 mt-0 pe-1">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <span class="form-label m-0 ms-1 align-middle"><?= _('Username') ?></span>
                                </span>
                                <input type="text" id="serviceargs[transfer_username]" name="serviceargs[transfer_username]" value="<?= encode_form_val($serviceargs['transfer_username']) ?>" class="form-control form-control-sm monitor rounded-end">

                                <i id="serviceargs_transfer_username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-4 mt-0 pe-1">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <span class="form-label m-0 ms-1 align-middle"><?= _('Password') ?></span>
                                </span>
                                <input type="text" id="serviceargs[transfer_password]" name="serviceargs[transfer_password]" value="<?= encode_form_val($serviceargs['transfer_password']) ?>" class="form-control form-control-sm monitor rounded-end">

                                <i id="serviceargs_transfer_password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm mt-0 pe-1">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <span class="form-label m-0 ms-1 align-middle"><?= _('Port') ?></span>
                                </span>
                                <input type="text" id="serviceargs[transfer_port]" name="serviceargs[transfer_port]" value="<?= encode_form_val($serviceargs['transfer_port']) ?>" class="form-control form-control-sm monitor rounded-end">

                                <i id="serviceargs_transfer_port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
