    <div class="container m-0 g-0">
        <div id="configForm">
            <div class="col-sm-6 border-block mb-4">
                <h2 class="mb-2">SNMP Walk Jobs</h2>
                <p><a href="<?= str_replace(get_base_url(false), '', get_base_url()) ?>/nagiosxi/config/snmpwalk.php" target="maincontentframe">Configure a new SNMP Walk Job here</a></p>
            </div>

            <h2 class="mt-4 mb-2"><?= _('Select a completed SNMP Walk Job') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="job" class="form-label form-item-required">
                        <?= _('Job') ?>
                        <?= xi6_info_tooltip(_('Select the SNMP Walk job you want to use, to add a new host and services for the scanned device. Only completed scans will show here.')) ?>
                    </label>
                    <div class="input-group position-relative">
                        <select name="job" id="job" class="form-select monitor rounded" placeholder="<?= _("Select Job") ?> " required>
<?php
    // Get jobs
    $visible_jobs = 0;
    $job_data = get_all_snmpwalk_jobs();
    $options = '';
    if (!empty($job_data)) {
        $snmpwalk_jobs = json_decode($job_data, true);
        foreach ($snmpwalk_jobs as $job) {
            if ($job['status'] == 'Finished') {
            $visible_jobs++;
            $jobdesc = 'SNMP Walk results: ' . $job['hostname'] . ' @ ' . get_datetime_string($job['date']) . ' - ' . $job['oid_count'] . ' OIDs';
?>
                            <option value="<?= encode_form_val($job['hostname'] . '_' . $job['date']) ?>"><?= $jobdesc ?></option>
<?php
            }
        }
    }
    if ($visible_jobs == 0) {
?>
                            <option value=""><?= _('No completed SNMP Walk jobs found') ?>.</option>
<?php
    }
?>
                        </select>
                        <div class="invalid-feedback">
                            Please select Job
                        </div>
                        <i id="job_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
