        <h2 class="mb-2"><?= _('Device Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Device Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($_SESSION['snmpwalk_address']) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Device Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this server or device')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($_SESSION['snmpwalk_hostname']) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('SNMP Services') ?></h2>
        <div class="snmpwalk-services-header">
            <p><?= _('Select the OIDs you would like to monitor via SNMP')?></p>
            <button class="btn btn-primary btn-sm show-hide-oids" type="button">Show all OIDs</button>
        </div>

<?php
        foreach ($_SESSION['snmpwalk_oid_data'] as $interface_index => $oids) {
            // display groups with checked OIDs
            $display = 'no-disp';
            $show_group = 'false';
            $arrow_icon = 'arrow_right';
            foreach ($oids as $oid_name => $data) {
                if (!empty($data['checked']) && $data['checked'] == "on") {
                    $display = "";
                    $show_group = 'true';
                    $arrow_icon = 'arrow_drop_down';
                    break;
                }
            }
?>
        <hr>
        <div data-group="<?= $interface_index ?>">
            <div class="group-header">
                <input type="checkbox" class="checkbox-toggle form-check-input" aria-checked="false"  />
                <div class="collapse-toggle" aria-expanded="<?= $show_group ?>">
                    MIB Index: <?= $interface_index ?>
                    <p class="oid-counter"><?= '(' . count($oids) . ' OIDs)' ?></p>
                    <i class="collapse-indicator material-symbols-outlined"><?= $arrow_icon ?></i>
                </div>
            </div>
            <div class="row oid-group <?= $display ?>">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1">
                        <div class="d-flex align-items-end col-sm-1">
                            <div class="input-group input-group-sm">
                                <label class="oid-label"><?= _('Select') ?></label>
                            </div>
                        </div>
                        <div class="d-flex align-items-end col-sm-2">
                            <label class="oid-label"><?= _('OID') ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1">
                            <label class="oid-label"><?= _('Type') ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-2">
                            <label class="oid-label"><?= _('Current Value') ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-2">
                            <label class="oid-label"><?= _('Display Name') ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1">
                            <label class="oid-label"><?= _('Data Label') ?> <?= xi6_info_tooltip(_('The text that will be displayed before the data (string or number) in the check output.')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1">
                            <label class="oid-label"><?= _('Data Units') ?> <?= xi6_info_tooltip(_('Optional data unit (examples: C, users, load)')) ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1">
                            <label class="oid-label"><?= _('Match Type') ?></label>
                        </div>
                        <div class="d-flex align-items-end col-sm-1">
                            <label class="oid-label text-center"><?= _('Thresholds') ?> <?= xi6_info_tooltip(_('If a match type is numeric, you must set a warning and critical value. Otherwise match type is a string -- if the value returned by the check does not match the string entered here, the check will return critical.')) ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
            <div class="scrollable-container oid-group <?= $display ?>">
<?php
                foreach ($oids as $oid_name => $data) {
                    // set defaults
                    $string_hide = '';
                    $numeric_hide = ' hide';
                    $data["matchtype"] = 'string';
                    
                    if ($data["type"] == 'INTEGER') {
                        $data["matchtype"] = 'numeric';
                        $numeric_hide = '';
                        $string_hide = ' hide';
                    } else if ($data["type"] == 'STRING') {
                        $data["matchtype"] = 'string';
                        $string_hide = '';
                    }

                    // don't render rows with non-checkable values
                    if ($data["type"] == 'OID' || !isset($data["type"]) || is_null($data['val'])) {
                        continue;
                    }
    ?>
                <div class="row oid-row col-sm-12">
                    <div class="col-sm-12">
                        <fieldset class="row g-2 mb-1 wz-fieldset">
                            <div class="form-check col-sm-1 mt-0 d-flex align-items-center flex-column">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" class="form-check-input mt-2 me-2 rounded" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][checked]" id="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][checked]" <?= isset($data['checked']) ? is_checked($data['checked']) : '' ?>>
                                    <div class="col-sm d-flex align-items-center flex-column">
                                        <label for="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][checked]" class="text-center"><?= encode_form_val($data['mib']) ?></label>
                                    </div>
                                    <input type="hidden" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][mib]" value="<?= encode_form_val($data["mib"]) ?>">
                                </div>
                            </div>
                            <div class="col-sm-2 mt-0">
                                <input type="text" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][oid]" id="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][oid]" value="<?= encode_form_val($data['oid']) ?>" class="form-control form-control-sm rounded monitor">
                            </div>
                            <div class="col-sm-1 mt-0">
                                <label class="form-label"><?= encode_form_val($data["type"]) ?></label>
                                <input type="hidden" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][type]" value="<?= encode_form_val($data["type"]) ?>" />
                            </div>
                            <div class="col-sm-2 mt-0">
                                <label class="form-label wrap-anywhere"><?= encode_form_val($data["val"]) ?></label>
                                <input type="hidden" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][val]" value="<?= encode_form_val($data["val"]) ?>" />
                            </div>
                            <div class="col-sm-2 mt-0">
                                <input type="text" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][name]" id="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][name]" value="<?= encode_form_val($data['name']) ?>" class="form-control form-control-sm rounded monitor">
                            </div>
                            <div class="col-sm-1 mt-0">
                                <input type="text" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][label]" id="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][label]" value="<?= encode_form_val($data['label']) ?>" class="form-control form-control-sm rounded monitor">
                            </div>
                            <div class="col-sm-1 mt-0">
                                <input type="text" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][units]" id="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][units]" value="<?= encode_form_val($data['units']) ?>" class="form-control form-control-sm rounded monitor">
                            </div>
                            <div class="col-sm-1 mt-0">
                                <select name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][matchtype]" id="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][matchtype]" class="form-control form-control-sm form-select form-select-sm match-type">
                                    <option value="none" <?= is_selected($data["matchtype"], "none") ?>><?= _('None') ?></option>
                                    <option value="numeric" <?= is_selected($data["matchtype"], "numeric") ?>><?= _('Numeric') ?></option>
                                    <option value="string" <?= is_selected($data["matchtype"], "string") ?>><?= _('String') ?></option>
                                </select>
                            </div>
                            <div class="col-sm-1 mt-0 numeric<?= $numeric_hide ?>">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <img src="<?= theme_image('error.png') ?>" <?= xi6_title_tooltip(_('Warning Threshold')) ?>>
                                    </span>
                                    <input type="text" id="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][warning]" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][warning]" value="<?= encode_form_val($data["warning"]) ?>" class="form-control form-control-sm monitor">
                                </div>
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <img src="<?= theme_image('critical_small.png') ?>" <?= xi6_title_tooltip(_('Critical Threshold')) ?>>
                                    </span>
                                    <input type="text" id="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][critical]" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][critical]" value="<?= encode_form_val($data['critical']) ?>" class="form-control form-control-sm monitor">
                                </div>
                            </div>
                            <div class="col-sm-1 mt-0 string<?= $string_hide ?>">
                                <input type="text" name="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][string]" id="oid_data[<?= $interface_index ?>][<?= $oid_name ?>][string]" value="<?= encode_form_val($data["string"]) ?>" class="form-control form-control-sm">
                            </div>
                        </fieldset>
                    </div>
                </div>
<?php
                }
?>
            </div>
        </div>
<?php
        }
?>
    <hr>

    <script type="text/javascript">
        $(document).ready(function() {
            $("#configWizardForm").submit(function(e) {
                whiteout();
                $("#snmpwalk-throbber").center().show();
            });

            $(".show-error").click(function() {
                $(".error-out").show();
            });

            $(".match-type").change(function() {
                var match = $(this).val();
                if (match == "none") {
                    $(this).parents(".row").find(".numeric").hide();
                    $(this).parents(".row").find(".string").hide();
                } else if (match == "numeric") {
                    $(this).parents(".row").find(".numeric").show();
                    $(this).parents(".row").find(".string").hide();
                } else if (match == "string") {
                    $(this).parents(".row").find(".numeric").hide();
                    $(this).parents(".row").find(".string").show();
                }
            });

            $('.checkbox-toggle').on('click', function () {
                const isChecked = $(this).prop('checked');
                const groupContainer = $(this).closest('div[data-group]');
                groupContainer.find('input[type="checkbox"]').prop('checked', isChecked);
            });

            $('.collapse-toggle').on('click', function (event) {
                event.preventDefault();
                const button = $(this).find('.collapse-indicator');
                const header = $(this).closest('.group-header');
                const isExpanded = $(this).attr('aria-expanded') != 'false';

                // Toggle visibility of all siblings after the header
                header.nextAll().toggle(!isExpanded);

                // Update button label and aria attribute
                $(this).attr('aria-expanded', !isExpanded);
                button.text(isExpanded ? 'arrow_right' : 'arrow_drop_down');
            });

            $('.show-hide-oids').on('click', function (event) {
                event.preventDefault();

                const showAll = !$(this).data('showing');

                // Apply new state to all groups
                $('.collapse-toggle').each(function () {
                    const $button = $(this).find('.collapse-indicator');
                    const $header = $(this).closest('.group-header');

                    // Toggle siblings
                    $header.nextAll().toggle(showAll);

                    // Update aria + arrow
                    $(this).attr('aria-expanded', showAll);
                    $button.text(showAll ? 'arrow_drop_down' : 'arrow_right');
                });

                // Update button state + label
                $(this).data('showing', showAll);
                $(this).text(showAll ? 'Hide all OIDs' : 'Show all OIDs');
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
