    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <div class="container m-0 g-0">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <p><?= _('For more information on ESensor&apos;s environmental monitoring products, or to place an order for a Websensor, visit') ?> <a href="https://eesensors.com/" target="_blank">eesensors.com</a>.</p>

            <h2 class="mb-2"><?= _('Websensor Information') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _('Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDNS name of the Websensor device you would like to monitor')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="model" class="form-label form-item-required"><?= _('Websensor Model') ?> <?= xi6_info_tooltip(_('The model number of the Websensor device you would like to monitor')) ?></label>
                    <div class="input-group position-relative">
                        <select name="model" id="model" class="form-select monitor rounded" placeholder="<?= _("Select Websensor Model") ?> " required>
                            <option value="EM01B">EM01B</option>
                            <option value="EM01B-STN">EM01B-STN</option>
                            <option value="EM01B-VLT">EM01B-VLT</option>
                            <option value="EM01B-THM">EM01B-THM</option>
                            <option value="EM08-T">EM08-T</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Websensor Model
                        </div>
                        <i id="model_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
