<?php
//
// NagVis Integration Component
// Copyright (c) 2010-2023 - Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../componenthelper.inc.php');

// Initialization stuff
pre_init();
init_session();

// Grab GET or POST variables and check authentication
grab_request_vars();
check_prereqs();
check_authentication(false);


route_redirect();


// We will redirect whatever the page details are into NagVis,
// this is used to create PDF page reports of NagVis dashboards/pages
function route_redirect()
{
	$uri = $_SERVER['REQUEST_URI'];
	$uri_parts = explode('?', $uri);
	$url = str_replace('nagiosxi', 'nagvis', get_base_url()) . 'frontend/nagvis-js/index.php?' . $uri_parts[1];
	header("Location: " . $url);
}
