    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="self_cert" value="<?= encode_form_val($self_cert) ?>">
    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="url" value="<?= encode_form_val($url) ?>">
    <input type="hidden" name="key" value="<?= encode_form_val($key) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';

    $errors = 0;
    $errmsg = array();

    // Query the Log Server for saved queries.
    $api_url = build_api_url($url, 'check/get_queries', $key);
    $data = array();
    $self_signed_cert_context = array(
        "ssl" => array(
            "verify_peer"       => false,
            "verify_peer_name"  => false,
            ),
        );

    $context = stream_context_create($self_signed_cert_context);
    $json = @file_get_contents($api_url, 0, $context);

    if (empty($json)) {
        $errmsg[$errors++] = _('Unable to contact server at ').$url.'.';
    } else {
        $data = json_decode($json, true);

        if (!$data || !is_array($data)) {
            $errmsg[$errors++] = _('Server returned invalid output.(Is this a Nagios Log Server?)');
            $data = null;
        } else if (grab_array_var($data, 'error') && grab_array_var($data, 'type') == 'authentication') {
            $errmsg[$errors++] = _('Bad API key.Message from server is').': "'.grab_array_var($data, 'message').'"';
        }
    }

    $services = '';
    $serviceargs = '';

    // Use encoded data if user came back from future screen.
    $services_serial = grab_array_var($inargs, 'services_serial');

    if ($services_serial) {
        $services = json_decode(base64_decode($services_serial), true);
    }

    $serviceargs_serial = grab_array_var($inargs, 'serviceargs_serial');

    if ($serviceargs_serial) {
        $serviceargs = json_decode(base64_decode($serviceargs_serial), true);
    }

    // If no serialized data, use current request data if available.
    if (!$services) {
        $services = grab_array_var($inargs, 'services', array());
    }

    if (!$serviceargs) {
        $serviceargs = grab_array_var($inargs, 'serviceargs', array());
    }

    // Initialize array variables if missing.
    if (!array_key_exists('id', $services)) $services['id'] = array();
    if (!array_key_exists('id', $serviceargs)) $serviceargs['id'] = array();

    for ($x = 0; $x < 3; $x++) {
        if (!array_key_exists($x, $services['id']))
            $services['id'][$x] = '';

        if (!array_key_exists($x, $serviceargs['id'])) {
            $serviceargs['id'][$x] = array(
                'name' => '',
                'id' => '',
                'minutes' => '',
                'warning' => '',
                'critical' => '',
            );
        }
    }

    if (!array_key_exists('query', $services)) $services['query'] = array();
    if (!array_key_exists('query', $serviceargs)) $serviceargs['query'] = array();

    for ($x = 0; $x < 3; $x++) {
        if (!array_key_exists($x, $services['query']))
            $services['query'][$x] = '';

        if (!array_key_exists($x, $serviceargs['query'])) {
            $serviceargs['query'][$x] = array(
                'name' => '',
                'type' => '',
                'query' => '',
                'minutes' => '',
                'warning' => '',
                'critical' => '',
            );
        }
    }
?>
    <div class="container m-0 g-0">
        <h2 class="mb-2"><?= _('Host Information') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Host Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this host')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('Log Server Settings') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="url" class="form-label"><?= _('URL') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="url" id="url" value="<?= encode_form_val($url) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter URL") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="url_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="key" class="form-label"><?= _('API Key') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="key" id="key" value="<?= encode_form_val($key) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter API Key") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="key_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Saved Queries') ?></h2>
        <p><?= _('Monitor results of queries saved in Log Server') ?></p>
<?php
    if ($errors) {
        $errmsg = implode('</li><li>', $errmsg);
?>
        <div class='message'><ul class='errorMessage'><li>$errmsg</li></ul></div>
<?php
    } else if (!$data) {
        $errmsg = _('No saved queries were found on this Log Server');
?>
        <div class='message'><ul class='actionMessage'><li>$errmsg</li></ul></div>
<?php
    } else {
?>
        <div class="alert alert-info w-50">
            <?= _('Queries will be copied from Log Server and saved in your XI configuration. Later changes to the queries in Log Server will not affect the queries in XI.') ?>
        </div>

        <div class="row">
            <div class="col-sm-10">
                <fieldset class="row g-3">
                    <div class="form-check col-sm-3">
                        <label class="form-check-label bold"><?= _('Display Name') ?></label>
                    </div>
                    <div class="col-sm-3">
                        <label class="form-check-label bold"><?= _('Saved Query') ?></label>
                    </div>
                    <div class="col-sm-2">
                        <label class="form-check-label bold"><?= _('Duration') ?> <?= xi6_info_tooltip('Duration is the previous specified minutes, or how long the check should look back in time. Standard checks are 5 minute, so 5 would be a reasonable initial value.') ?></label>
                    </div>
                    <div class="col-sm-2">
                        <label class="form-check-label bold"><?= _('Warning') ?></label>
                    </div>
                    <div class="col-sm-2">
                        <label class="form-check-label bold"><?= _('Critical') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="adddeleterow savedQueriesList">
<?php
        for ($x = 0; $x < count($serviceargs['id']); $x++) {
            $minutes = encode_form_val($serviceargs['id'][$x]['minutes']);
            $warning = encode_form_val($serviceargs['id'][$x]['warning']);
            $critical = encode_form_val($serviceargs['id'][$x]['critical']);
?>
             <div class="row">
                <div class="col-sm-10">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[id][<?= $x ?>]" id="services[id][<?= $x ?>]" <?= (isset($services['id'][$x]) ? is_checked($services['id'][$x], 'on') : '') ?>>
                                <input type="text" name="serviceargs[id][<?= $x ?>][name]" id="serviceargs[id][<?= $x ?>][name]" value="<?= encode_form_val($serviceargs['id'][$x]['name']) ?>" class="form-control form-control-sm rounded monitor">
                                <i id="serviceargs_id_<?= $x ?>_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <select name="serviceargs[id][<?= $x ?>][id]" id="serviceargs[id][<?= $x ?>][id]" class="form-control form-control-sm form-select form-select-sm">
<?php
            foreach ($data as $d) {
                $id = encode_form_val($d['id']);
                $sel = is_selected($serviceargs['id'][$x]['id'], $id);
                $name = encode_form_val($d['name']);
?>
                                <option value='<?= $id ?>' <?= $sel ?>><?= $name ?></option>
<?php
            }
?>
                            </select>
                            <i id="serviceargs_id_<?= $x ?>_id_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <input type="text" name="serviceargs[id][<?= $x ?>][minutes]" id="serviceargs[id][<?= $x ?>][minutes]" value="<?= $minutes ?>" class="form-control form-control-sm rounded monitor">
                            <i id="serviceargs_id_<?= $x ?>_minutes_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[id][<?= $x ?>][warning]" name="serviceargs[id][<?= $x ?>][warning]" value="<?= $warnlevel ?>" class="form-control form-control-sm monitor">
                                <i id="serviceargs_id_<?= $x ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[id][<?= $x ?>][critical]" name="serviceargs[id][<?= $x ?>][critical]" value="<?= $critlevel ?>" class="form-control form-control-sm monitor">
                                <i id="serviceargs_id_<?= $x ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
        }
?>
        </div> <!-- adddeleterow savedQueriesList -->
<?php
    }
?>
        <h2 class="mt-4"><?= _('Text Queries') ?></h2>
        <p><?= _('Monitor results of a Lucene or JSON query entered as text') ?><br><a href="http://www.elasticsearch.org/guide/en/elasticsearch/reference/current/query-dsl-query-string-query.html#query-string-syntax" target="_blank"><?= _('About the Lucene query syntax') ?></a>.</p>

        <div class="row">
            <div class="col-sm-12">
                <fieldset class="row g-3">
                    <div class="form-check col-sm-3">
                        <label class="form-check-label bold"><?= _('Display Name') ?></label>
                    </div>
                    <div class="col-sm-2">
                        <label class="form-check-label bold"><?= _('Type') ?></label>
                    </div>
                    <div class="col-sm-4">
                        <label class="form-check-label bold"><?= _('Query') ?></label>
                    </div>
                    <div class="col-sm-1">
                        <label class="form-check-label bold"><?= _('Duration') ?> <?= xi6_info_tooltip('Duration is the previous specified minutes, or how long the check should look back in time. Standard checks are 5 minute, so 5 would be a reasonable initial value.') ?></label>
                    </div>
                    <div class="col-sm-1">
                        <label class="form-check-label bold"><?= _('Warning') ?></label>
                    </div>
                    <div class="col-sm-1">
                        <label class="form-check-label bold"><?= _('Critical') ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="adddeleterow textQueriesList">
<?php
    for ($x = 0; $x < count($serviceargs['query']); $x++) {
?>
             <div class="row">
                <div class="col-sm-12">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[query][<?= $x ?>]" id="services[query][<?= $x ?>]" <?= (isset($services['query'][$x]) ? is_checked($services['query'][$x], 'on') : '') ?>>
                                <input type="text" name="serviceargs[query][<?= $x ?>][name]" id="serviceargs[query][<?= $x ?>][name]" value="<?= encode_form_val($serviceargs['query'][$x]['name']) ?>" class="form-control form-control-sm rounded monitor">
                                <i id="serviceargs_query_<?= $x ?>_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <select name="serviceargs[query][<?= $x ?>][type]" id="serviceargs[query][<?= $x ?>][type]" class="form-control form-control-sm form-select form-select-sm">
                                <option value="text" <?= is_selected($serviceargs['query'][$x]['type'], 'text') ?>><?= _('Lucene') ?></option>
                                <option value="json" <?= is_selected($serviceargs['query'][$x]['type'], 'json') ?>><?= _('JSON') ?></option>
                            </select>
                            <i id="serviceargs_query_<?= $x ?>_type_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-4 mt-0">
                            <input type="text" name="serviceargs[query][<?= $x ?>][query]" id="serviceargs[query][<?= $x ?>][query]" value="<?= encode_form_val($serviceargs['query'][$x]['query']) ?>" class="form-control form-control-sm rounded monitor">
                            <i id="serviceargs_query_<?= $x ?>_query_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-1 mt-0">
                            <input type="text" name="serviceargs[query][<?= $x ?>][minutes]" id="serviceargs[id][<?= $x ?>][minutes]" value="<?= encode_form_val($serviceargs['query'][$x]['minutes']) ?>" class="form-control form-control-sm rounded monitor">
                            <i id="serviceargs_query_<?= $x ?>_minutes_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="col-sm-1 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                    <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                </span>
                                <input type="text" id="serviceargs[query][<?= $x ?>][warning]" name="serviceargs[query][<?= $x ?>][warning]" value="<?= $warnlevel ?>" class="form-control form-control-sm monitor">
                                <i id="serviceargs_query_<?= $x ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-1 mt-0">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                </span>
                                <input type="text" id="serviceargs[query][<?= $x ?>][critical]" name="serviceargs[query][<?= $x ?>][critical]" value="<?= $critlevel ?>" class="form-control form-control-sm monitor">
                                <i id="serviceargs_query_<?= $x ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div> <!-- adddeleterow textQueriesList -->

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
