<?php
//
// Copyright (c) 2008-2020 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../../common.inc.php');


// Start session
init_session(false, false);

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_prereqs(false);
check_authentication(false);


route_request();


function route_request()
{
    check_nagios_session_protector();

    $cmd = grab_request_var("cmd", "");

    switch ($cmd) {
        case "get_query_data":
            get_query_data();
            break;
        case "get_graph_data":
            get_graph_data();
            break;
        case "get_source_views":
            get_source_views();
            break;
        default:
            break;
    }
    exit;
}


function get_query_data() {
    $url = grab_request_var("url", '');
    $endpoint = grab_request_var("endpoint", '');
    $token = grab_request_var("token", '');
    $object = grab_request_var("object", '');
    $ssl = grab_request_var("ssl", "");
    $nna_api_url = $url . $object . $endpoint . '?token=' . $token;


    if ($ssl == true) {

        $invalid_cert_context = array(
            "ssl" => array(
                "verify_peer"       => false,
                "verify_peer_name"  => false,
                ),
            );

        $context = stream_context_create($invalid_cert_context);
        $reports_data = file_get_contents($nna_api_url, false, $context);
    } else {
        $reports_data = file_get_contents($nna_api_url);
    }

    echo $reports_data;
}

function get_source_views() {
    $url = grab_request_var("url", '');
    $token = grab_request_var("token", '');
    $sid = grab_request_var("sid", '');
    $endpoint = grab_request_var("endpoint", '');
    $source_views_api_url = $url . $endpoint . "?token=" . $token . "&q[sid]=" . $sid;

    $reports_data = file_get_contents($source_views_api_url);
    echo $reports_data;
}

function get_graph_data() {
    $url = grab_request_var("url", '');
    $token = grab_request_var("token", '');
    $object_type = grab_request_var("object_type", '');
    $object_id = grab_request_var("object_id", '');
    $use_views = grab_request_var("use_views", '');
    $view_id = grab_request_var("view_id", '');

    $vars = array(
        'q[Bytes]' => 'bytes',
        'q[Flows]' => 'flows',
        'q[Packets]' => 'packets',
        'token' => $token,
        'begindate' => '-1 week'
    );

    $data_type = 'gid';
    if ($object_type == 'sources') {
        $data_type = 'sid';
    }

    $updated_url = $url . '?' . $data_type . '=' . $object_id;
    if ($use_views == 'on') {
        $updated_url = $url . '?vid=' . $view_id;
    }

    foreach ($vars as $k => $v) {
        $updated_url .= "&$k=" . str_replace(" ", "+", $v);
    }

    $reports_data = file_get_contents($updated_url);
    echo $reports_data;
}