    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>" />
    <input type="hidden" name="filename" value="<?= encode_form_val($filename) ?>" />
    <input type="hidden" name="filesize" value="<?= encode_form_val($filesize) ?>" />
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('TFTP Server') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('TFTP Connect Service') ?></h2>
        <p><?= _('A service that checks a TFTP server availability by trying to write a file without permissions') ?></p>

        <div class="row mb-3 mt-4">
            <div class="col-sm">
                <input type="checkbox" id="tftpconnect" class="form-check-input" name="services[tftpconnect]" <?= is_checked(grab_array_var($services,"tftpconnect")) ?>>
                <label for="tftpconnect" class="form-check-label bold">
                    <?= _('TFTP Connection Test Service') ?>
                </label>
            </div>
        </div>

        <h2 class="mt-4"><?= _('TFTP Get Service') ?></h2>
        <p><?= _('A service that checks a file located on a TFTP server for sanity or to check size') ?></p>

        <div class="alert alert-info w-50">
            <?= _('You must include the exact size of the file in bytes, or the check will not run successfully, and you will recieve a message similar to <b>\'File size mismatch: expected 17 bytes, got 15 bytes.\'</b>') ?>
        </div>

        <div class="adddeleterow">
             <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1">
                        <div class="d-flex align-items-end form-check col-sm-4">
                            <div class="input-group input-group-sm">
                                <label class="form-check-label bold"><?= _('File Name') ?></label>
                            </div>
                        </div>
                        <div class="d-flex align-items-end col-sm-2">
                            <label class="form-check-label bold"><?= _('File Size') ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    for ($x = 0; $x < count($serviceargs['id']); $x++) {
        $filename = encode_form_val($serviceargs['id'][$x]['filename']);
        $filesize = encode_form_val($serviceargs['id'][$x]['filesize']);
?>
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-4 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[id][<?= $x ?>]" <?= isset($services['id'][$x]) ? is_checked($services['id'][$x]) : '' ?>>
                                <input type="text" name="serviceargs[id][<?= $x ?>][filename]" id="serviceargs[id][<?= $x ?>][filename]" value="<?= encode_form_val($serviceargs['id'][$x]['filename']) ?>" class="form-control form-control-sm rounded monitor">
                                <i id="serviceargs_id_<?= $x ?>_filename_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-2 mt-0">
                            <input type="text" name="serviceargs[id][<?= $x ?>][filesize]" id="serviceargs[id][<?= $x ?>][filesize]" value="<?= encode_form_val($serviceargs['id'][$x]['filesize']) ?>" class="form-control form-control-sm rounded monitor">
                            <i id="serviceargs_id_<?= $x ?>_filesize_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div> <!-- adddeleterow -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
