<?php
//
// World Time Server Dashlet
// Copyright (c) 2008-2018 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../dashlethelper.inc.php');


// Run the initialization function
snmptraps_dashlet_init();


function snmptraps_dashlet_init()
{

    $name = "snmptraps";

    $args = array(
        DASHLET_NAME => $name,
        DASHLET_VERSION => "1.0.0",
        DASHLET_AUTHOR => "Nagios Enterprises, LLC",
        DASHLET_DESCRIPTION => _("See volume of incoming SNMP Traps."),
        DASHLET_COPYRIGHT => "Dashlet Copyright &copy; 2023- Nagios Enterprises.",
        DASHLET_FILTER_GROUPS => array("metrics"),
        DASHLET_LICENSE => "All Rights Reserved",
        DASHLET_HOMEPAGE => "https://www.nagios.com",
        DASHLET_FUNCTION => "snmptraps_dashlet_func",
        DASHLET_TITLE => _("SNMP Trap Volume"),
        DASHLET_OUTBOARD_CLASS => "snmptraps_outboardclass",
        DASHLET_INBOARD_CLASS => "snmptraps_inboardclass",
        DASHLET_PREVIEW_CLASS => "snmptraps_previewclass",
        DASHLET_WIDTH => "300",
        DASHLET_HEIGHT => "300",
        DASHLET_OPACITY => "1.0",
        DASHLET_BACKGROUND => "",
        DASHLET_ISCUSTOM => false
    );

    register_dashlet($name, $args);
}


/**
 * @param string $mode
 * @param string $id
 * @param null   $args
 *
 * @return string
 */
function snmptraps_dashlet_func($mode = DASHLET_MODE_PREVIEW, $id = "", $args = null)
{

    $output = "";

    $imgbase = get_dashlet_url_base("snmptraps") . "/images/";

    switch ($mode) {

        case DASHLET_MODE_GETCONFIGHTML:

            ob_start();
            include __DIR__.'/config.php';
            $output = ob_get_clean();

            break;

        case DASHLET_MODE_OUTBOARD:
        case DASHLET_MODE_INBOARD:

            ob_start();
            include __DIR__.'/dashlet.php';
            $output = ob_get_clean();

            break;

        case DASHLET_MODE_PREVIEW:

            if(!is_neptune()) {
                $output = "<p><img src='" . $imgbase . "preview.png'></p>";
            } else if (get_theme() == 'neptunelight') {
                $output = "<img src='" . $imgbase . "snmptrap_neptune_light_preview.png'>";
            } else {
                $output = "<img src='" . $imgbase . "neptune_preview.png'>";
            }

            break;

    }

    return $output;
}

