    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <div class="col-sm-6 border-block mb-4">
                <h2><?= _('Setup NCPA') ?></h2>
                <p><i><?= _('The agent should be installed before running this wizard') ?></i></p>
                <ul class="list-group list-group-numbered">
                    <li class="list-group-item"><a href="<?= $NCPA_download_url ?>" target="_blank"><?= _('Download the latest version of NCPA') ?></a> <?= _('for the system you would like to monitor') ?></li>
                    <li class="list-group-item"><?= _('Follow the') ?> <a href="https://www.nagios.org/ncpa/getting-started.php" target="_blank"><?= _('installation instructions') ?></a> (<a href="https://assets.nagios.com/downloads/ncpa/docs/Installing-NCPA.pdf" target="_blank"><?= _('PDF version') ?></a>) <?= _('and configure the token for the agent') ?></li>
                </ul>
            </div>

            <h2 class="mb-2"><?= _('Connect to NCPA') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _('Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDNS name used to connect to NCPA')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($ip_address) ?>" class="form-control monitor rounded usermacro-detection" placeholder="<?= _("Enter Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="port" class="form-label form-item-required"><?= _('Port') ?> <?= xi6_info_tooltip(_('Port used to connect to NCPA. Defaults to port 5693')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control monitor rounded usermacro-detection" placeholder="<?= _("Enter Port") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Port
                        </div>
                        <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-3 mt-4">
                <div class="col-sm">
                    <input type="checkbox" id=no_ssl_verify name="no_ssl_verify" value="1" class="form-check-input mt-1 me-2" <?= is_checked($no_ssl_verify, 1) ?>>
                    <label for="no_ssl_verify" class="form-check-label bold"><?= _("Do not verify SSL certificate") ?></label>
                </div>
            </div>

            <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
                <div class="col-sm">
                    <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                    <label for="changePassword" class="form-check-label bold"><?= _("Change Token") ?> <?= xi6_info_tooltip(_("Use to change the Token, otherwise, the existing Token will be preserved.")) ?></label>
                </div>
            </div>

            <div id="setPassword" class="row mb-2">
                <div class="col-sm-6">
                    <label for="token" class="form-label form-item-required"><?= _('Token') ?> <?= xi6_info_tooltip(_('Authentication token used to connect to NCPA')) ?></label>
                    <div class="input-group">
                        <input type="password" name="token" id="token" value="<?= encode_form_val($token) ?>" class="usermacro-detection form-control rounded-start usermacro-detection" autocomplete="off" placeholder="<?= _("Enter Token") ?>"  required>
                        <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Show") ?>">
                            <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                            <i id="token_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </button>
                        <div class="invalid-feedback">
                            Please enter the Token.
                        </div>
                    </div>
                </div>
            </div>
<?php
    // Only display the operating system selection if no os pre-selected by the wizard
    // this is for windows server and windows desktop mostly...
    if (!array_key_exists('os', $extra)) {
?>
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="os" class="form-label form-item-required"><?= _('System') ?> <?= xi6_info_tooltip(_('Used to set the icon for the host')) ?></label>
                    <div class="input-group position-relative">
                        <select name="os" id="os" class="form-select monitor rounded" placeholder="<?= _("Select System") ?> " required>
                            <option value="" disabled selected hidden>Choose an Operating System...</option>
                            <option value="" <?= is_selected($os, "") ?>><?= _('Generic') ?></option>
                            <option value="centos" <?= is_selected($os, "centos") ?>>CentOS</option>
                            <option value="rhel" <?= is_selected($os, "rhel") ?>>RHEL</option>
                            <option value="oracle" <?= is_selected($os, "oracle") ?>>Oracle</option>
                            <option value="ubuntu" <?= is_selected($os, "ubuntu") ?>>Ubuntu</option>
                            <option value="debian" <?= is_selected($os, "debian") ?>>Debian</option>
                            <option value="suse" <?= is_selected($os, "suse") ?>>OpenSUSE</option>
                            <option value="sles" <?= is_selected($os, "sles") ?>>SLES</option>
                            <option value="windows" <?= is_selected($os, "windows") ?>>Windows</option>
                            <option value="osx" <?= is_selected($os, "osx") ?>>Mac OS X</option>
                            <option value="sol" <?= is_selected($os, "sol") ?>>Solaris</option>
                            <option value="aix" <?= is_selected($os, "aix") ?>>AIX</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select System
                        </div>
                        <i id="os_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
<?php
    }
?>
        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
