    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <div class="container m-0 g-0">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <div class="col-sm-6 border-block mb-4">
                <h2><?= _('Exchange Server - Setup NCPA') ?></h2>
                <p><i><?= _('The agent should be installed before running this wizard') ?></i></p>
                <ul class="list-group list-group-numbered">
                    <li class="list-group-item"><a href="<?= $NCPA_download_url ?>" target="_blank"><?= _('Download the latest version of NCPA') ?></a> <?= _('for the system you would like to monitor') ?></li>
                    <li class="list-group-item"><?= _('Follow the') ?> <a href="https://www.nagios.org/ncpa/getting-started.php" target="_blank"><?= _('installation instructions') ?></a> (<a href="https://assets.nagios.com/downloads/ncpa/docs/Installing-NCPA.pdf" target="_blank"><?= _('PDF version') ?></a>) <?= _('and configure the token for the agent') ?></li>
                </ul>
            </div>

            <h2 class="mb-2"><?= _("Exchange Server Information") ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _('IP Address') ?> <?= xi6_info_tooltip(_('The IP address of the Exchange server you would like to monitor')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($ip_address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter IP Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the IP Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="version" class="form-label form-item-required"><?= _('Version') ?> </label>
                    <div class="input-group position-relative">
                        <select name="version" id="version" class="form-select monitor rounded" placeholder="<?= _("Select Version") ?> " required>
                            <option value="" disabled selected>Choose a version...</option>
                            <option value="5.5" <?= is_selected($version, "5.5") ?>>Exchange 5.5</option>
                            <option value="2000" <?= is_selected($version, "2000") ?>>Exchange 2000</option>
                            <option value="2003" <?= is_selected($version, "2003") ?>>Exchange 2003</option>
                            <option value="2007" <?= is_selected($version, "2007") ?>>Exchange 2007</option>
                            <option value="2010" <?= is_selected($version, "2010") ?>>Exchange 2010</option>
                            <option value="2013" <?= is_selected($version, "2013") ?>>Exchange 2013</option>
                            <option value="2016" <?= is_selected($version, "2016") ?>>Exchange 2016</option>
                            <option value="2019" <?= is_selected($version, "2019") ?>>Exchange 2019</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Version
                        </div>
                        <i id="version_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="port" class="form-label form-item-required"><?= _('NCPA Port') ?> <?= xi6_info_tooltip(_('Port used to connect to NCPA.Defaults to port 5693')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control monitor rounded usermacro-detection" placeholder="<?= _("Enter NCPA Port") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the NCPA Port
                        </div>
                        <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
                <div class="col-sm">
                    <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                    <label for="changePassword" class="form-check-label bold"><?= _("Change Token") ?> <?= xi6_info_tooltip(_("Use to change the Token, otherwise, the existing Token will be preserved.")) ?></label>
                </div>
            </div>

            <div id="setPassword" class="row mb-2">
                <div class="col-sm-6">
                    <label for="token" class="form-label form-item-required"><?= _('Token') ?> <?= xi6_info_tooltip(_('Authentication token used to connect to NCPA')) ?></label>
                    <div class="input-group">
                        <input type="password" name="token" id="token" value="<?= encode_form_val($token) ?>" class="usermacro-detection form-control rounded-start usermacro-detection" autocomplete="off" placeholder="<?= _("Enter Token") ?>"  required>
                        <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end tt-bind" id="password-secret" title="<?= _("Show") ?>">
                            <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                            <i id="token_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </button>
                        <div class="invalid-feedback">
                            Please enter the Token.
                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
