<?php
// Note: all vars have been html encoded at intake.
?>

<h5 class="ul"><?= _("OpenAI Cost Metrics") ?></h5>
<p><?=  _("Specify which OpenAI cost metrics you wish to monitor") ?>.</p>
<table class="table table-no-border table-auto-width table-padded">
    <tr>
        <td class="vt">
            <input type="checkbox" class="checkbox" name="services[total_cost][monitor]" id="total_cost" <?= is_checked(grab_array_var($services['total_cost'], "monitor"), "on") ?>>
        </td>
        <td class="vt" style="width: 350px;">
            <div>
                <label for="total_cost" style="line-height: auto;">
                    <b><?= _('Total Cost') ?></b>
                </label>
                <div style="margin-bottom: 6px;"><?= _('Monitor the total cost for this period.') ?></div>
            </div>
            <div>
                <label><i title="<?= _('Warning Threshold') ?>" class="material-symbols-outlined md-warning md-18 md-400 md-middle tt-bind">warning</i></label>
                <input type="text" size="8" name="services[total_cost][warning]"
                    value="<?= isset($services['total_cost']['warning']) ? $services['total_cost']['warning'] : '' ?>" class="form-control condensed">
                <?= _('$') ?>&nbsp;&nbsp;
                <label><i title="<?= _('Critical Threshold') ?>" class="material-symbols-outlined md-critical md-18 md-400 md-middle tt-bind">error</i></label>
                <input type="text" size="8" name="services[total_cost][critical]"
                    value="<?= isset($services['total_cost']['critical']) ? $services['total_cost']['critical'] : '' ?>" class="form-control condensed">
                <?= _('$') ?>
            </div>
        </td>
        <td class="vt" style="padding-top: 33px;">
            <div><label><?= _('Time period (Max: 180 days)') ?></label></div>
            <div class="flex" style="margin-top: 6px;">
                <input type="text" size="3" name="services[total_cost][time_units]" id="total_cost_time_units" value="<?= $services['total_cost']['time_units'] ?>" class="form-control condensed">&nbsp;&nbsp;&nbsp;

                <select name="services[total_cost][time_unit]" id="total_cost_time_unit"
                    class="form-control condensed">
                    <option value="day" <?= is_selected($services['total_cost']['time_unit'], "day") ?>>Day</option>
                    <option value="week" <?= is_selected($services['total_cost']['time_unit'], "week") ?>>Week</option>
                    <option value="month" <?= is_selected($services['total_cost']['time_unit'], "month") ?>>Month</option>
                </select>
            </div>
        </td>
    </tr>








    <tr>
        <td class="vt">
            <input type="checkbox" class="checkbox" name="services[requests][monitor]" id="requests" <?= is_checked(grab_array_var($services['requests'], "monitor"), "on") ?>>
        </td>
        <td class="vt" style="width: 350px;">
            <div>
                <label for="requests" style="line-height: auto;">
                    <b><?= _('Request Usage') ?></b>
                </label>
                <div style="margin-bottom: 6px;"><?= _('Montior amount of requests made this period.') ?></div>
            </div>
            <div>
                <label><i title="<?= _('Warning Threshold') ?>" class="material-symbols-outlined md-warning md-18 md-400 md-middle tt-bind">warning</i></label>
                <input type="text" size="8" name="services[requests][warning]"
                    value="<?= isset($services['requests']['warning']) ? $services['requests']['warning'] : '' ?>" class="form-control condensed">
                <?= _(' ') ?>&nbsp;&nbsp;
                <label><i title="<?= _('Critical Threshold') ?>" class="material-symbols-outlined md-critical md-18 md-400 md-middle tt-bind">error</i></label>
                <input type="text" size="8" name="services[requests][critical]"
                    value="<?= isset($services['requests']['critical']) ? $services['requests']['critical'] : '' ?>" class="form-control condensed">
                <?= _(' ') ?>
            </div>
        </td>
        <td class="vt" style="padding-top: 33px;">
            <div><label><?= _('Time period (Max: 31 days)') ?></label></div>
            <div class="flex" style="margin-top: 6px;">
                <input type="text" size="3" name="services[requests][time_units]" id="requests_time_units" value="<?= $services['requests']['time_units'] ?>" class="form-control condensed">&nbsp;&nbsp;&nbsp;

                <select name="services[requests][time_unit]" id="requests_time_unit"
                    class="form-control condensed">
                    <option value="day" <?= is_selected($services['requests']['time_unit'], "day") ?>>Day</option>
                    <option value="week" <?= is_selected($services['requests']['time_unit'], "week") ?>>Week</option>
                </select>
            </div>
        </td>
    </tr>








    <tr>
        <td class="vt">
            <input type="checkbox" class="checkbox" name="services[input_tokens][monitor]" id="input_tokens" <?= is_checked(grab_array_var($services['input_tokens'], "monitor"), "on") ?>>
        </td>
        <td class="vt" style="width: 350px;">
            <div>
                <label for="input_tokens" style="line-height: auto;">
                    <b><?= _('Total Input Tokens') ?></b>
                </label>
                <div style="margin-bottom: 6px;"><?= _('Monitor total input tokens used this period.') ?></div>
            </div>
            <div>
                <label><i title="<?= _('Warning Threshold') ?>" class="material-symbols-outlined md-warning md-18 md-400 md-middle tt-bind">warning</i></label>
                <input type="text" size="8" name="services[input_tokens][warning]"
                    value="<?= isset($services['input_tokens']['warning']) ? $services['input_tokens']['warning'] : '' ?>" class="form-control condensed">
                <?= _(' ') ?>&nbsp;&nbsp;
                <label><i title="<?= _('Critical Threshold') ?>" class="material-symbols-outlined md-critical md-18 md-400 md-middle tt-bind">error</i></label>
                <input type="text" size="8" name="services[input_tokens][critical]"
                    value="<?= isset($services['input_tokens']['critical']) ? $services['input_tokens']['critical'] : '' ?>" class="form-control condensed">
                <?= _(' ') ?>
            </div>
        </td>
        <td class="vt" style="padding-top: 33px;">
            <div><label><?= _('Time period (Max: 31 days)') ?></label></div>
            <div class="flex" style="margin-top: 6px;">
                <input type="text" size="3" name="services[input_tokens][time_units]" id="input_tokens_time_units" value="<?= $services['input_tokens']['time_units'] ?>" class="form-control condensed">&nbsp;&nbsp;&nbsp;

                <select name="services[input_tokens][time_unit]" id="input_tokens_time_unit"
                    class="form-control condensed">
                    <option value="day" <?= is_selected($services['input_tokens']['time_unit'], "day") ?>>Day</option>
                    <option value="week" <?= is_selected($services['input_tokens']['time_unit'], "week") ?>>Week</option>
                </select>
            </div>
        </td>
    </tr>







    <tr>
        <td class="vt">
            <input type="checkbox" class="checkbox" name="services[cached_input_tokens][monitor]" id="cached_input_tokens" <?= is_checked(grab_array_var($services['cached_input_tokens'], "monitor"), "on") ?>>
        </td>
        <td class="vt" style="width: 350px;">
            <div>
                <label for="cached_input_tokens" style="line-height: auto;">
                    <b><?= _('Total Cached Input Tokens') ?></b>
                </label>
                <div style="margin-bottom: 6px;"><?= _('Monitor total cached input tokens used this period.') ?></div>
            </div>
            <div>
                <label><i title="<?= _('Warning Threshold') ?>" class="material-symbols-outlined md-warning md-18 md-400 md-middle tt-bind">warning</i></label>
                <input type="text" size="8" name="services[cached_input_tokens][warning]"
                    value="<?= isset($services['cached_input_tokens']['warning']) ? $services['cached_input_tokens']['warning'] : '' ?>" class="form-control condensed">
                <?= _(' ') ?>&nbsp;&nbsp;
                <label><i title="<?= _('Critical Threshold') ?>" class="material-symbols-outlined md-critical md-18 md-400 md-middle tt-bind">error</i></label>
                <input type="text" size="8" name="services[cached_input_tokens][critical]"
                    value="<?= isset($services['cached_input_tokens']['critical']) ? $services['cached_input_tokens']['critical'] : '' ?>" class="form-control condensed">
                <?= _(' ') ?>
            </div>
        </td>
        <td class="vt" style="padding-top: 33px;">
            <div><label><?= _('Time period (Max: 31 days)') ?></label></div>
            <div class="flex" style="margin-top: 6px;">
                <input type="text" size="3" name="services[cached_input_tokens][time_units]" id="cached_input_tokens_time_units" value="<?= $services['cached_input_tokens']['time_units'] ?>" class="form-control condensed">&nbsp;&nbsp;&nbsp;

                <select name="services[cached_input_tokens][time_unit]" id="cached_input_tokens_time_unit"
                    class="form-control condensed">
                    <option value="day" <?= is_selected($services['cached_input_tokens']['time_unit'], "day") ?>>Day</option>
                    <option value="week" <?= is_selected($services['cached_input_tokens']['time_unit'], "week") ?>>Week</option>
                </select>
            </div>
        </td>
    </tr>






    <tr>
        <td class="vt">
            <input type="checkbox" class="checkbox" name="services[output_tokens][monitor]" id="output_tokens" <?= is_checked(grab_array_var($services['output_tokens'], "monitor"), "on") ?>>
        </td>
        <td class="vt" style="width: 350px;">
            <div>
                <label for="output_tokens" style="line-height: auto;">
                    <b><?= _('Total Output Tokens') ?></b>
                </label>
                <div style="margin-bottom: 6px;"><?= _('Monitor total output tokens for this period.') ?></div>
            </div>
            <div>
                <label><i title="<?= _('Warning Threshold') ?>" class="material-symbols-outlined md-warning md-18 md-400 md-middle tt-bind">warning</i></label>
                <input type="text" size="8" name="services[output_tokens][warning]"
                    value="<?= isset($services['output_tokens']['warning']) ? $services['output_tokens']['warning'] : '' ?>" class="form-control condensed">
                <?= _(' ') ?>&nbsp;&nbsp;
                <label><i title="<?= _('Critical Threshold') ?>" class="material-symbols-outlined md-critical md-18 md-400 md-middle tt-bind">error</i></label>
                <input type="text" size="8" name="services[output_tokens][critical]"
                    value="<?= isset($services['output_tokens']['critical']) ? $services['output_tokens']['critical'] : '' ?>" class="form-control condensed">
                <?= _(' ') ?>
            </div>
        </td>
        <td class="vt" style="padding-top: 33px;">
            <div><label><?= _('Time period (Max: 31 days)') ?></label></div>
            <div class="flex" style="margin-top: 6px;">
                <input type="text" size="3" name="services[output_tokens][time_units]" id="output_tokens_time_units" value="<?= $services['output_tokens']['time_units'] ?>" class="form-control condensed">&nbsp;&nbsp;&nbsp;

                <select name="services[output_tokens][time_unit]" id="output_tokens_time_unit"
                    class="form-control condensed">
                    <option value="day" <?= is_selected($services['output_tokens']['time_unit'], "day") ?>>Day</option>
                    <option value="week" <?= is_selected($services['output_tokens']['time_unit'], "week") ?>>Week</option>
                </select>
            </div>
        </td>
    </tr>



</table>
