<?php
//
// Birdseye Component
// Copyright (c) 2013-2019 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../../common.inc.php');
require_once(dirname(__FILE__) . '/ajaxreqs.php');

// Initialization
pre_init();
init_session();
grab_request_vars();
check_prereqs();

// Check authentication
check_authentication(false);

// Do actual stuff
$title = _("Birdseye");

$info = get_xml_program_status(array());
$status = array("nagios" => intval($info->programstatus->is_currently_running),
                "notifications" => intval($info->programstatus->notifications_enabled));

?>
<!DOCTYPE html>
<html>
<!-- Produced by Nagios XI.  Copyyright (c) 2008-2024 Nagios Enterprises, LLC (www.nagios.com). All Rights Reserved. -->
<head>
    <title><?php echo $title; ?> &middot; <?php echo _("Nagios XI"); ?></title>
    <meta name="ROBOTS" content="NOINDEX, NOFOLLOW">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <?php do_page_head_links(); // Add Nagios XI links ?>
    <link rel="stylesheet" type="text/css" href="styles/default.css">    
    <script type="text/javascript" src="includes/masonry.pkgd.min.js"></script>
    <script type="text/javascript" src="includes/main.js"></script>
    <script type="text/javascript">
    state_soft = '<?php echo _("Soft"); ?>';
    state_hard = '<?php echo _("Hard"); ?>';
    </script>
    <?php if (get_theme() == "colorblind") { ?>
        <link rel="stylesheet" type="text/css" href="../../css/colorblind.css">
    <?php } ?>
</head>
<body class="<?php if (get_theme()=="xi5dark"|| get_theme()=="neptune" ) { echo 'night'; } else { echo 'day'; } ?>">
<div id="be-body">
    <div id="be-dash">
        <div id="be-header">
            <div style="float: left; width: 200px;">
                <h1 id="test"><?php echo $title; ?>
                    <?php if (is_dark_theme() || is_neptune()) { ?>
                    <!-- <img src="images/lightbulb_off.png" title="Turn lights on!" id="toggle-lights"> -->
                    <i class="fa fa-lightbulb-o fa-lg fa-unknown" title="Turn lights on!" id="toggle-lights"></i>
                    <?php } else { ?>
                    <!-- <img src="images/lightbulb.png" title="Turn lights off!" id="toggle-lights"> -->
                    <i class="fa fa-lightbulb-o fa-lg fa-off" title="Turn lights off!" id="toggle-lights"></i>
                    <?php } ?>
                </h1>
            </div>
            <div style="float: left; height: 40px; width: 20%;">
                <div class="stat"><?php if ($status['nagios']) {                        
                        echo '<i class="fa fa-check fa-lg fa-ok-control" title="Running"></i>';
                    } else {                        
                        echo '<i class="fa fa-times fa-lg fa-critical" title="Not running"></i>';
                    } ?> <?php echo _("Monitoring Engine"); ?>
                </div>
                <div class="stat"><?php if ($status['notifications']) {                        
                        echo '<i class="fa fa-check fa-lg fa-ok-control" title="Enabled"></i>';
                    } else {                        
                        echo '<i class="fa fa-times fa-lg fa-critical" title="Disabled"></i>';
                    } ?> <?php echo _("Notifications Enabled"); ?>
                </div>
            </div>
            <div style="float: left; height: 40px; width: 25%;">
                <div class="stat" style="cursor: pointer;" onclick="change_handled()">                  
                  <i class="fa fa-wrench fa-lg fa-off"></i>
                  <span class="handled"><?php echo _("Hiding Handled"); ?></span>
                </div>
                <div class="stat" style="cursor: pointer;" onclick="change_soft()">                  
                  <i class="fa fa-wrench fa-lg fa-off"></i>
                  <span class="soft"><?php echo _("Hiding Soft States"); ?></span>
                </div>
            </div>
            <div class="float: left;" id="clock"></div>
            <!-- <div class="float: left;">
                <span id="testup" style="cursor:pointer;">Test Toggle</span> <span id="ticker"></span>
            </div> -->
            <div style="clear: both;"></div>
        </div>
        <div id="be-hosts">
            <!--
            <img style="width: 22px; height: 22px; vertical-align: top; margin-right: 5px;" src="../nagioscore/ui/images/logos/'.$host['icon'].'" title="" alt="">
            -->
        </div>
    </div>
    <div id="be-status">
    </div>
</div>

<?php
do_page_end(true);
