<?php
//
// Copyright (c) 2008-2020 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../../common.inc.php');
include_once(dirname(__FILE__) . '/nagiosna.inc.php');


// Start session
init_session(false, false);

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_prereqs(false);
check_authentication(false);


route_request();


function route_request()
{
    check_nagios_session_protector();

    $cmd = grab_request_var("cmd", "");

    switch ($cmd) {
        case "make_report_chord":
            make_report_chord();
            break;
        case "make_query_chord":
            make_query_chord();
            break;
        case "get_query_data":
            get_query_data();
            break;
        case "get_source_views":
            get_source_views();
            break;
        default:
            break;
    }
    exit;
}

function make_report_chord() {
    $address = grab_request_var("ip", '');
    $sec = grab_request_var("security", '');
    $agg_suffix = grab_request_var("agg_suffix", '');
    $apiurl = grab_request_var("apiurl", '');
    $chordquery = grab_request_var("chordquery", '');
    $allow_invalid_cert = grab_request_var("ssl", '');

    $base_url = "http" . $sec . "://" . $address . "/nagiosna/";
    $query_info = $chordquery . "&type=report&agg2=" . $agg_suffix;
    $url = $base_url . $apiurl . "?";

    // Below we need to modify the query info becuase file_get_contents has issues with accepting spaces in the url. d3.json didn't have this issue so it didnt need to be modified before.
    $indexed_info = explode("&", $query_info);
    $associative_info= [];

    foreach ($indexed_info as $part) {
        $temp = explode("=", $part);
        $associative_info[$temp[0]] = $temp[1];
    }

    foreach ($associative_info as $k => $v) {
        $url .= "&$k=" . str_replace(" ", "+", $v);
    }

    $chord_data = nna_file_get_contents($url, $allow_invalid_cert);
    echo $chord_data;
}

function make_query_chord() {
    $address = grab_request_var("ip", '');
    $sec = grab_request_var("security", '');
    $apiurl = grab_request_var("apiurl", '');
    $apiquery = grab_request_var("apiquery", '');
    $chordquery = grab_request_var("chordquery", '');
    $allow_invalid_cert = grab_request_var("ssl", '');

    $base_url = "http" . $sec . "://" . $address . "/nagiosna/";
    $url = $base_url . $apiurl . "?" . $apiquery . $chordquery;

    $chord_data = nna_file_get_contents($url, $allow_invalid_cert);
    echo $chord_data;
}

function get_query_data() {
    $server = grab_request_var("server", '');
    $allow_invalid_cert = grab_request_var("ssl", '');
    $endpoint = grab_request_var("endpoint", '');
    $api_url = get_nna_api_url_php($server[0], $server[1]);
    $token = $server[2];
    $reports_api_url = $api_url . $endpoint . '?token=' . $token;

    $reports_data = nna_file_get_contents($reports_api_url, $allow_invalid_cert);
    echo $reports_data;
}

function get_source_views() {
    $url = grab_request_var("url", '');
    $token = grab_request_var("token", '');
    $sid = grab_request_var("sid", '');
    $endpoint = grab_request_var("endpoint", '');
    $allow_invalid_cert = grab_request_var("ssl", '');
    $source_views_api_url = $url . $endpoint . "?token=" . $token . '&q[sid]=' . $sid;

    $reports_data = nna_file_get_contents($source_views_api_url, $allow_invalid_cert);
    echo $reports_data;
}