    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />
<style>
.popover-header { background-color: inherit; color: white; }
.bs-popover-auto[data-popper-placement^="top"] > .popover-arrow::after, .bs-popover-top > .popover-arrow::after { border-width: .4rem .4rem 0; border-top-color: #000; }
.bs-popover-auto[data-popper-placement^="top"] > .popover-arrow::before, .bs-popover-top > .popover-arrow::before { border-width: .4rem .4rem 0; border-top-color: rgba(0,0,0,.25); }
.bs-popover-auto[data-popper-placement^="top"] > .popover-arrow, .bs-popover-top > .popover-arrow { bottom: -.4rem; }
.bs-popover-auto[data-popper-placement^="right"] > .popover-arrow::after, .bs-popover-end > .popover-arrow::after { border-width: .4rem .4rem .4rem 0; border-right-color: #000; }
.bs-popover-auto[data-popper-placement^="right"] > .popover-arrow::before, .bs-popover-end > .popover-arrow::before { border-width: .4rem .4rem .4rem 0; border-right-color: rgba(0,0,0,.25); }
.bs-popover-auto[data-popper-placement^="right"] > .popover-arrow, .bs-popover-end > .popover-arrow { left: -.4rem; }
.bs-popover-auto[data-popper-placement^="left"] > .popover-arrow::after, .bs-popover-start > .popover-arrow::after { border-width: .4rem 0 .4rem .4rem; border-left-color: #000; }
.bs-popover-auto[data-popper-placement^="left"] > .popover-arrow::before, .bs-popover-start > .popover-arrow::before { border-width: .4rem 0 .4rem .4rem; border-left-color: rgba(0,0,0,.25); }
.bs-popover-auto[data-popper-placement^="left"] > .popover-arrow, .bs-popover-start > .popover-arrow { right: -.4rem; }
.bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow::after, .bs-popover-bottom > .popover-arrow::after { border-width: 0 .4rem .4rem .4rem; border-bottom-color: #000; }
.bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow::before, .bs-popover-bottom > .popover-arrow::before { border-width: 0 .4rem .4rem .4rem; border-bottom-color: rgba(0,0,0,.25); }
.bs-popover-auto[data-popper-placement^="bottom"] > .popover-arrow, .bs-popover-bottom > .popover-arrow { top: -.4rem; }
.popover, .popover .popover-arrow::before, .popover .popover-arrow::after { opacity: 0.98; }
.popover .popover-arrow { opacity: 0.9; }
.popover-body > a { text-decoration: underline; }
.popover-body a:hover { color: #0B89FF; text-decoration: none; }
</style>
<?php
    #include_once __DIR__.'/../../../utils-xi6-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2><?= _('AWS Account Information') ?></h2>
            <p><?= _('Specify the credentials for the Amazon Web Services account you would like to monitor') ?></p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="accesskeyid" class="form-label form-item-required"><?= _('Access Key ID') ?> <?= xi6_info_tooltip(_('The Access Key ID of the instance to be monitored')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="accesskeyid" id="accesskeyid" value="<?= encode_form_val($accesskeyid) ?>" class="form-control monitor rounded credinput" placeholder="<?= _("Enter Access Key ID") ?>"  <?= (checkbox_binary($staticcreds) ? "disabled" : "") ?> required>
                        <div class="invalid-feedback">
                            <?= _('Please enter an Access Key ID or specify a static credentials file') ?>
                        </div>
                        <i id="accesskeyid_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="accesskey" class="form-label form-item-required"><?= _('Secret Access Key') ?> <?= xi6_info_tooltip(_('The Secret Access Key of the instance to be monitored')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="accesskey" id="accesskey" value="<?= encode_form_val($accesskey) ?>" class="form-control monitor rounded credinput" placeholder="<?= _("Enter Secret Access Key") ?>"  <?= (checkbox_binary($staticcreds) ? "disabled" : "") ?> required>
                        <div class="invalid-feedback">
                            <?= _('Please enter a Secret Access Key or specify a static credentials file') ?>
                        </div>
                        <i id="accesskey_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-3 mt-4">
                <div class="col-sm-auto">
                    <input type="checkbox" id="staticcreds" name="staticcreds" class="form-check-input mt-1 me-2" <?= is_checked(checkbox_binary($staticcreds), "1") ?>>
                    <label for="staticcreds" class="form-check-label bold">
                        <?= _('Static AWS credentials file') ?>
                        <?= xi6_info_tooltip(_("When checked, Nagios will read a local file containing AWS credentials. The credentials file must use Amazon's syntax.<br><small><hr>Click on the documentation icon <i class='material-symbols-outlined md-middle md-14 md-400'>description</i> &nbsp; for more information.</small>")) ?>
                    </label>
                </div>
                <div class="col-sm-auto ps-0 pad-t2">
                    <i id="awsCreds" data-bs-html="true" data-bs-container="body" data-bs-toggle="popover" data-bs-placement="right" data-bs-content="<a target='_blank' href='http://docs.aws.amazon.com/cli/latest/userguide/cli-config-files.html'>Official AWS documentation for credentials files." class="material-symbols-outlined md-button md-18 md-400">description</i>
                </div>
            </div>

            <!-- Initially hidden -->
            <div id="credsfilepathdiv" class="row mb-2 visually-hidden">
                <div class="col-sm-6 ms-4">
                    <label for="credsfilepath" class="form-label form-item-required">
                        <?= _('File path') ?>
                        <?= xi6_info_tooltip(_('The absolute file path to the Amazon Credentials file (<b>Default:</b> /usr/local/nagiosxi/etc/.aws/credentials)'). _('<b>Note: Ensure the nagios group has read permissions for the entirety of the file path leading to the credentials file, including the file itself</b>')) ?>
                    </label>
                    <div class="input-group position-relative">
                        <input type="text" name="credsfilepath" id="credsfilepath" value="<?= encode_form_val($credsfilepath) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter File path") ?>" disabled>
                        <div class="invalid-feedback">
                            <?= _("Please enter the absolute file path for the credentials file") ?>
                        </div>
                        <i id="credsfilepath_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-3 mt-4">
                <div class="col-sm-auto">
                    <input type="checkbox" id="staticconfig" name="staticconfig" class="form-check-input mt-1 me-2" <?= is_checked(checkbox_binary($staticconfig), "1") ?>>
                    <label for="staticconfig" class="form-check-label bold">
                        <?= _('Static AWS configuration file') ?>
                        <?= xi6_info_tooltip(_("When checked, Nagios will read a local file containing AWS configuration information. The configuration files must use Amazon's syntax.<br><small><hr>Click on the documentation icon <i class='material-symbols-outlined md-middle md-14 md-400'>description</i> &nbsp; for more information.</small>")) ?>
                    </label>
                </div>
                <div class="col-sm-auto ps-0 pad-t2">
                    <i id="awsConfig" data-bs-html="true" data-bs-container="body" data-bs-toggle="popover" data-bs-placement="right" data-bs-content="<a target='_blank' href='http://docs.aws.amazon.com/cli/latest/userguide/cli-config-files.html'>Official AWS documentation for configuration files." class="material-symbols-outlined md-button md-18 md-400">description</i>
                </div>
            </div>

            <!-- Initially hidden -->
            <div id="configfilepathdiv" class="row mb-2 visually-hidden">
                <div class="col-sm-6 ms-4">
                    <label for="configfilepath" class="form-label form-item-required">
                        <?= _('File path') ?>
                        <?= xi6_info_tooltip(_('The absolute file path to the Amazon Configuration file (<b>Default:</b> /usr/local/nagiosxi/etc/.aws/config)'). _('<b>Note: Ensure the nagios group has read permissions for the entirety of the file path leading to the config file, including the file itself</b>')) ?>
                    </label>
                    <div class="input-group position-relative">
                        <input type="text" name="configfilepath" id="configfilepath" value="<?= encode_form_val($configfilepath) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter File path") ?>" disabled>
                        <div class="invalid-feedback">
                            <?= _("Please enter the absolute file path for the configuration file") ?>
                        </div>
                        <i id="configfilepath_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div id="instancesDiv" class="visually-hidden">
                <h2 class="mt-4"><?= _('EC2 Instances') ?></h2>
                <p><?= _('Select the EC2 instances you would like to monitor') ?></p>

                <div id="instance-notice-div" class="row pb-3 visually-hidden">
                    <div class="col-sm-6">
                        <div id="instance-notice" class="alert alert-secondary col-sm-12 text-center loader">
                            <div id="info-placeholder"></div>
                        </div>
                    </div>
                </div>
                <div id="get-instances-div" class="row pb-3">
                    <div class="col-sm-6">
                        <button type="button" id="get-instances" class="btn btn-sm btn-primary available-instances">Get Available Instances</button>
                        <?= xi6_info_tooltip(_('Load the available instances, using the credentials provided.')) ?>
                    </div>
                </div>
<?php
    if ($instance_list == '') {
?>
                <div id="instance-container" class="visually-hidden"></div>
<?php
    } else {
        // Rebuild the region based data structure
        $regional_instance_list = array();

        foreach ($instance_list as $instance_id => $instance_info) {
            $regional_instance_list[$instance_info['region']][$instance_id] = $instance_info;
        }

        $counter = 0;

        foreach ($regional_instance_list as $region => $instances) {
?>
                <div id="instance-container">
                    <div id="regionDiv_<?= $counter ?>" class="col-sm-6 border-block mb-2">
                        <h6><?= $region ?></h6>

                        <div class="row g-1">
                            <div class="col-sm-auto me-2 mt-1">
                                <input type="checkbox" id="select-all-region_<?= $counter ?>" class="form-check-input select-all-checkboxes" checked>
                            </div>
                            <div class="col-sm-5">
                                <label class="form-label ps-2"><?= _('Instance ID') ?></label>
                            </div>
                            <div class="col-sm-6">
                                <label class="form-label ps-2"><?= _('IP Address') ?></label>
                            </div>
                        </div>
<?php
            foreach ($instances as $instance_id => $instance_info) {
?>
                        <div class="row mb-2 g-1">
                            <div class="col-sm-auto me-2 mt-2">
                                <input type="checkbox" id="instancelist[<?= instance_id ?>][checkbox]" name="instancelist[<?= $instance_id ?>][checkbox]" class="form-check-input instance-list-checkbox" <?= (checkbox_binary($instance_info["checkbox"]) ? "checked" : "") ?>>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" class="form-control form-control-sm me-1 rounded" id="instancelist[<?= $instance_id ?>][instanceid]" name="instancelist[<?= $instance_id ?>][instanceid]" value="<?= $instance_id ?>" disabled>
                            </div>

                            <div class="col-sm-6">
                                <input type="text" id="instancelist[<?= $instance_id ?>][ip_address]" name="instancelist[<?= $instance_id ?>][ip_address]" class="form-control form-control-sm me-1 rounded monitor" value="<?= $instance_info['ip_address'] ?>">
                            </div>
                        </div>
                        <input type="hidden" name="instancelist[<?= $instance_id ?>][region]" value="<?= $instance_info['region'] ?>">
<?php
            }
?>
                    </div> <!-- regionDiv_<?= $counter ?> -->
<?php
            $counter++;
        }
?>
                </div> <!-- instance-container -->
<?php
    }
?>
            </div> <!-- instancesDiv -->
        </div> <!-- configForm -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            //
            // Bind each region's .select-all-checkboxes checkboxes, to click event.
            // - PHP render (step2 then Back button)
            //
            $("[id^='regionDiv_']").on('click', ".select-all-checkboxes", function() {
                clickSelectAllInstances(this);
            });

            // Click/unclick select-all-region_? checkbox.
            function clickSelectAllInstances (obj) {
                isChecked = ($(obj).is(':checked'));

                // Region
                thisRegion = $(obj).parents("div[id^=regionDiv]");

                // Instance
                thisRegionDiv = $(thisRegion)[0];

                instances = $(thisRegionDiv).find(".instance-list-checkbox");

                $(instances).each(function(index, element) {
                    if (isChecked) {
                        $(element).prop('checked', true);
                    } else {
                        $(element).prop('checked', false);
                    }
                });
            }

            //
            // Handle ec2 instance check/uncheck individual checkboxes
            // - Matches all id's starting with "instancelist"
            //
            $("[id^='regionDiv_']").on('click', ".instance-list-checkbox", function() {
                clickIndividualInstance(this);
            });

            // Click/unclick .instance-list-checkbox checkbox.
            function clickIndividualInstance (obj) {
                isChecked = ($(obj).is(':checked'));

                // Region
                thisRegion = $(obj).parents("div[id^=regionDiv]");

                // Instance
                thisRegionDiv = $(thisRegion)[0];

                selectAllObj = $(thisRegionDiv).find(".select-all-checkboxes");
                selectAll = $(selectAllObj)[0];

                if ($("#"+thisRegionDiv.id+" .instance-list-checkbox").length == $("#"+thisRegionDiv.id+" .instance-list-checkbox:checked").length) {
                    $(selectAll).prop('checked', true);
                } else {
                    $(selectAll).prop('checked', false);
                }
            }

            //
            // Checkbox management - staticcreds
            //
            if ($("#staticcreds").is(':checked')) {
                checkStaticCreds();
            }

            $("#staticcreds").change(function () {
                checkStaticCreds();
            });

            function checkStaticCreds() {
                if ($('#staticcreds').is(':checked')) {
                    $('#credsfilepathdiv').removeClass('visually-hidden');
                    $('#credsfilepath').removeAttr('disabled');
                    $('#credsfilepath').attr('required');
                    $('#accesskeyid').attr('disabled', true);
                    //$('#accesskeyid').siblings('.invalid-feedback').addClass('visually-hidden');
                    //$('#accesskeyid').removeClass('is-invalid');
                    //$('#accesskeyid').removeClass('invalid');
                    $('#accesskey').attr('disabled', true);
                    //$('#accesskey').prop('disabled', true);
                    //$('#accesskey').siblings('.invalid-feedback').addClass('visually-hidden');
                    //$('#accesskey').removeClass('is-invalid');
                    //$('#accesskey').removeClass('invalid');

                    $('label[for=accesskeyid]').removeClass('form-item-required');
                    $('label[for=accesskey]').removeClass('form-item-required');
                    $('#accesskeyid').removeAttr('required');
                    $('#accesskey').removeAttr('required');
                } else {
                    $('#credsfilepathdiv').addClass('visually-hidden');
                    $('#credsfilepath').prop('disabled', true);
                    $('#accesskeyid').removeAttr('disabled');
                    $('#accesskey').removeAttr('disabled');

                    $('label[for=accesskeyid]').addClass('form-item-required');
                    $('label[for=accesskey]').addClass('form-item-required');
                    $('#accesskeyid').attr('required', true);
                    $('#accesskey').attr('required', true);
                }
            }

            //
            // Checkbox management - staticconfig
            //
            if ($("#staticconfig").is(':checked')) {
                checkStaticConfig();
            }

            $("#staticconfig").change(function () {
                checkStaticConfig();
            });

            function checkStaticConfig() {
                if ($('#staticconfig').is(':checked')) {
                    $('#configfilepathdiv').removeClass('visually-hidden');
                    $('#configfilepath').removeAttr('disabled');
                    $('#configfilepath').attr('required', true);
                } else {
                    $('#configfilepathdiv').addClass('visually-hidden');
                    $('#configfilepath').removeAttr('required');
                }
            }

            //
            // Handle changes to accesskeyid, so the account can be changed without reloading the page.
            //
            $('#accesskeyid').on("input propertychange paste", function() {
                // Check if we need to show the button and scroll it into view.
                if ($(this).val() && $('#accesskey').val()) {
                    $('#instancesDiv').removeClass('visually-hidden');
                } else {
                    $('#instancesDiv').addClass('visually-hidden');
                }

                if ($(this).val()) {
                    $('#accesskeyid').removeClass('invalid');
                    $('#accesskeyid').removeClass('is-invalid');
                    $('#accesskeyid').siblings('.invalid-feedback').addClass('visually-hidden');
//                    $('label[for=accesskeyid]').removeClass('form-item-required');
//                    $('#accesskeyid').removeAttr('required');
                } else {
//                    $('label[for=accesskeyid]').addClass('form-item-required');
//                    $('#accesskeyid').attr('required', true);
                    $('#accesskeyid').addClass('invalid');
                    $('#accesskeyid').addClass('is-invalid');
                    $('#accesskeyid').siblings('.invalid-feedback').removeClass('visually-hidden');
                }
            });

            //
            // Handle changes to accesskey
            //
            $('#accesskey').on("input propertychange paste", function() {
                if ($(this).val() && $('#accesskey').val()) {
                    $('#instancesDiv').removeClass('visually-hidden');
                } else {
                    $('#instancesDiv').addClass('visually-hidden');
                }

                if ($(this).val()) {
                    $('#accesskey').removeClass('invalid');
                    $('#accesskey').removeClass('is-invalid');
                    $('#accesskey').siblings('.invalid-feedback').addClass('visually-hidden');
//                    $('label[for=accesskey]').removeClass('form-item-required');
//                    $('#accesskey').removeAttr('required');
                } else {
//                    $('label[for=accesskey]').addClass('form-item-required');
//                    $('#accesskey').attr('required', true);
                    $('#accesskey').addClass('invalid');
                    $('#accesskey').addClass('is-invalid');
                    $('#accesskey').siblings('.invalid-feedback').removeClass('visually-hidden');
                }
            });

            //
            // Handle "Get Available Instances" button - AJAX
            //
            $("#get-instances").on("click", function() {
                // Make sure the bucket-container is empty and hidden.
                $("#instance-container").empty();
                $("#instance-container").addClass('visually-hidden');

                // Check that we have all requisite data
                var errors = 0;

                var accesskeyid = $("#accesskeyid").val();
                var accesskey = $("#accesskey").val();
                var staticcreds = $("#staticcreds").prop("checked");

                // Make sure we have the required data
                if (!accesskeyid && !staticcreds) {
                    $('#accesskeyid').addClass('invalid');
                    $('#accesskeyid').addClass('is-invalid');
                    $('#accesskeyid').siblings('.invalid-feedback').removeClass('visually-hidden');
                    errors += 1;
                } else {
                    $('#accesskeyid').removeClass('invalid');
                    $('#accesskeyid').removeClass('is-invalid');
                    $('#accesskeyid').siblings('.invalid-feedback').addClass('visually-hidden');
                }

                if (!accesskey && !staticcreds) {
                    $('#accesskey').addClass('invalid');
                    $('#accesskey').addClass('is-invalid');
                    $('#accesskey').siblings('.invalid-feedback').removeClass('visually-hidden');
                    errors += 1;
                } else {
                    $('#accesskey').removeClass('invalid');
                    $('#accesskey').removeClass('is-invalid');
                    $('#accesskey').siblings('.invalid-feedback').addClass('visually-hidden');
                }

                if (errors > 0) {
                    document.getElementsByClassName('container')[0].scrollIntoView({ behavior: "smooth" });
                    return false;
                }

                $("#instance-notice-div").addClass('visually-hidden');
                $("#no-instances").addClass('visually-hidden');
                $("#info-placeholder").empty();

                // Display the loading animation whenever the button is clicked
                whiteout();
                $('.xi-modal').show();
                $('.xi-modal').position({ my: "center", at: "center", of: window });
                show_throbber();

                var accesskeyid = $("#accesskeyid").val();
                var accesskey = $("#accesskey").val();

                // Base64 encode the strings so we can pass them as a query string
                accesskeyid = btoa(accesskeyid);
                accesskey = btoa(accesskey);

                // Build the AJAX url
                var formvalues = "mode=getinstances";

                if ($("#staticcreds").is(":checked")) {
                    var staticcreds = $("#staticcreds").val();
                    var credsfilepath = $("#credsfilepath").val();

                    formvalues += "&staticcreds=" + staticcreds;
                    formvalues += "&credsfilepath=" + credsfilepath;
                }

                if (accesskeyid != "") {
                    formvalues += "&accesskeyid=" + accesskeyid;
                }

                if (accesskey != "") {
                    formvalues += "&accesskey=" + accesskey;
                }

                full_url = base_url + "includes/configwizards/amazon_ec2/ec2.ajax.php?" + formvalues;

                //
                // AJAX
                //
                $.ajax({
                    url: full_url,
                    dataType: "json",
                    success: function(data) {

                        $("#bucket-notice-div").addClass('visually-hidden');
                        $('.xi-modal').hide();
                        clear_whiteout();
                        hide_throbber();

                        if (!data || !data.success) {
                            $('.xi-modal').hide();
                            clear_whiteout();
                            hide_throbber();

                            $("#instance-notice-div").removeClass('visually-hidden');
                            $("#instance-notice").addClass('alert-warning');
                            $("#info-placeholder").html(data.error);

                            return false;
                        }

                        $("#instance-notice-div").addClass('visually-hidden');

                        // TODO: counter isn't really needed, just use region.
                        var counter = 0;

                        delete data["success"];

                        $.each(data, function(region, value) {
                            var header = "".concat(
'        <div id="regionDiv_'+counter+'" class="col-sm-6 border-block mb-2">',
'            <div class="row g-1">',
'                <div class="col-sm-auto">',
'                    <h6>'+region+'</h6>',
'                </div>',
'            </div>',
'            <div class="row g-1">',
'                <div class="col-sm-auto me-2 mt-1">',
'                    <input type="checkbox" id="select-all-region_'+counter+'" class="form-check-input select-all-checkboxes" checked>',
'                </div>',
'                <div class="col-sm-5">',
'                    <label class="form-label ps-2"><?= _('Instance ID') ?></label>',
'                </div>',
'                <div class="col-sm-6">',
'                    <label class="form-label ps-2"><?= _('IP Address') ?></label>',
'                </div>',
'            </div>'
                            );

                            var regionBlock = header;

                            $.each(value, function(index, instance) {

                                var row = "".concat(
'            <div class="row mb-2 g-1">',
'                <div class="col-sm-auto me-2 mt-2">',
'                    <input type="checkbox" id="instancelist['+instance.instance_id+'][checkbox]" name="instancelist['+instance.instance_id+'][checkbox]" class="form-check-input instance-list-checkbox" checked>',
'                </div>',
'                <div class="col-sm-5">',
'                    <input type="text" id="instancelist['+instance.instance_id+'][instanceid]" name="instancelist['+instance.instance_id+'][instanceid]" class="form-control form-control-sm me-1 rounded" value="'+instance.instance_id+'" disabled>',
'                </div>',
'                <div class="col-sm-6">',
'                    <input type="text" id="instancelist['+instance.instance_id+'][ip_address]" name="instancelist['+instance.instance_id+'][ip_address]" class="form-control form-control-sm me-1 rounded monitor" value="'+instance.ip_address+'">',
'                </div>',
'            </div>',
'            <input type="hidden" name="instancelist['+instance.instance_id+'][region]" value="'+region+'">'
                                );

                                regionBlock += row;
                            });

                            regionBlock += '        </div>';

                            $("#instance-container").append(regionBlock);
                            $("#instance-container").removeClass("visually-hidden");

                            // Bind actions to checkboxes with .select-all-chackboxes and .instance-list-checkboxes.
                            $("[id^='regionDiv_']").on('click', ".select-all-checkboxes", function() { clickSelectAllInstances(this); });
                            $("[id^='regionDiv_']").on('click', ".instance-list-checkbox", function() { clickIndividualInstance(this); });

                            counter++;
                        });

                        document.getElementById('instance-container').scrollIntoView({ behavior: "smooth" });
                    },
                    error: function(xmlhttprequest, textstatus, message) {
                        $('.xi-modal').hide();
                        clear_whiteout();
                        hide_throbber();

                        if (textstatus === "parsererror") {
                            $("#instance-notice-div").removeClass('visually-hidden');
                            $("#instance-notice").addClass('alert-danger');
                            $("#info-placeholder").html("<?= _('Error: There were no instances found. Verify your AWS credentials and try again.') ?>");
                        } else {
                            $("#instance-notice-div").removeClass('visually-hidden');
                            $("#instance-notice").addClass('alert-danger');
                            $("#info-placeholder").html('<span class="text-capitalize">'+textstatus+'</span>: '+message);
                        }
                    }
                });  // AJAX
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
