<?php
    if ($staticcreds == "on") {
?>
        <input type="hidden" name="credsfilepath" id="credsfilepath" value="<?= encode_form_val($credsfilepath) ?>" class="textfield form-control credsinput" readonly>
<?php
    } else {
?>
         <input type="hidden" name="accesskeyid" id="accesskeyid" value="<?= encode_form_val($accesskeyid) ?>" class="textfield form-control credsinput">
         <input type="hidden" name="accesskey" id="accesskey" value="<?= encode_form_val($accesskey) ?>" class="textfield form-control credsinput">
<?php
    }

    if ($staticconfig == "on") {
?>
        <input type="hidden" name="configfilepath" id="configfilepath" value="<?= encode_form_val($configfilepath) ?>">
<?php
    }

/*    <link rel="stylesheet" href="<?= $main_css_url ?>"/> */
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container-md m-0 g-0">

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h5 class="mb-2"><?= _('S3 Bucket Metrics') ?></h5>

        <div id="advanced-wrapper" class="row mb-4">
            <div id="search-grid" class="col-sm-8">
                <div class="border-block">
                    <label for="bucket-search" class="form-label"><?= _('Filter Buckets') ?> <?= xi6_info_tooltip(_('Filter by Bucket Name or Region')) ?></label>
                    <input type="text" class="form-control form-control-sm mb-1" id="bucket-search" />
                </div>
            </div>
        </div>

        <div id="mainAccordion" class="accordion">
            <div class="accordion-item">
                <h5 class="accordion-header d-flex position-relative" id="toggle-all-header">
                    <!-- Moved outside the button to prevent checkbox from triggering open/close all -->
                    <input type="checkbox" class="form-check-input fa-12 position-absolute" id="toggle-all-instances">
                    <button class="accordion-button collapsed d-flex" type="button" data-bs-toggle="collapse" id="toggleAllAccordionItems" aria-expanded="false">
                        <div class="form-label g-2 flex-even text-center"><?= _('Bucket Name') ?></div>
                        <div class="form-label g-2 flex-even text-center"><?= _('Region') ?></div>
                    </button>
                </h5>
                <div id="dummyItem" class="accordion-collapse collapse">
                </div>
            </div>

<?php
    foreach ($bucket_list as $bucket_name => $bucket_info) {
        $legalName = str_replace('.', '_', $bucket_name);

        // Don't let unchecked buckets pass through to step two
        if ( $bucket_info['checkbox'] != 'on' ) {
            continue;
        }
?>
            <input type="hidden" name="bucketlist[<?= $bucket_name ?>][checkbox]" value="<?= $bucket_info['checkbox'] ?>">
            <input type="hidden" name="bucketlist[<?= $bucket_name ?>][region]" value="<?= $bucket_info['region'] ?>">
            <input type="hidden" name="bucketlist[<?= $bucket_name ?>][bucket_name]" value="<?= $bucket_name ?>">


            <div class="accordion-item bucket-wrapper" id="item_<?= $legalName ?>" data-bucket-name="<?= $bucket_name ?>" data-region="<?= $bucket_info['region'] ?>">
                <h5 class="accordion-header d-flex position-relative bucket-header" id="header_<?= $legalName ?>"  data-bucket-name="<?= $bucket_name ?>">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse_<?= $legalName ?>" aria-expanded="false" aria-controls="collapse_<?= $legalName ?>">
                        <div class="form-label g-2 flex-even text-center"><?= $bucket_name ?></div>
                        <div class="form-label g-2 flex-even text-center"><?= $bucket_info['region'] ?></div>
                    </button>
                </h5>
                <div id="collapse_<?= $legalName ?>" class="accordion-collapse collapse multi-collapse" aria-labelledby="header_<?= $legalName ?>">
                    <div class="accordion-body">

                        <!---------- Hostname ---------->

                        <div class="row">
                            <div class="col-sm-10">
                                <div class="input-group input-group-sm g-2 mb-1 ms-3 ps-1 flex-nowrap">
                                    <label class="form-check-label input-group-text min-width-14em" for="bucketlist[<?= $bucket_name ?>][hostname]"><?= _("Hostname") ?> <?= xi6_info_tooltip(_('The name you want associated with this host.'), false, false) ?></label>
                                    <input name="bucketlist[<?= $bucket_name ?>][hostname]" value="<?= $bucket_name ?>" class="form-control form-control-sm min-width-14em" type="text"/>
                                </div>
                            </div>
                        </div>

                        <!---------- Toggle All Checkbox ---------->

                        <div class="row">
                            <div class="col-sm ps-4">
                                <div class="input-group input-group-sm m-2 ms-0 flex-nowrap">
                                    <input type="checkbox" class="form-check-input rounded me-2 mt-1 toggle-checkbox" data-bucket-name="<?= $bucket_name ?>" id="toggle_<?= $legalName ?>" checked="true">
                                    <label for="toggle_<?= $legalName ?>" class="form-check-label bold select-cf-option"><?= _('Toggle All') ?></label>
                                </div>
                            </div>
                        </div>
<?php
        // Loop over the metrics and create inputs for each
        if (is_array($bucket_info['metrics'])) {
            $metrics = $bucket_info['metrics'];
        } else {
            $metrics = json_decode(base64_decode($bucket_info['metrics']), true);
            ksort($metrics);
        }

        foreach ($metrics as $metric_name => $metric_info) {

            $formatted_metric_name = $metrics_dictionary[$metric_name]['name'];
            $metric_description = $metrics_dictionary[$metric_name]['description'];
            $metric_units = $metrics_dictionary[$metric_name]['units'];
?>
                    <div class="fieldset g-2 p-2 mb-1 wz-fieldset">
                        <div class="row mb-1">
                            <div class="col-sm-3">
                                <div class="input-group input-group-sm">
                                    <input type="checkbox" class="form-check-input <?= $legalName ?>-checkbox mt-1 me-2 rounded" id="<?= $metric_name ?>" name="bucketlist[<?= $bucket_name ?>][metrics][<?= $metric_name ?>][checkbox]" <?= is_checked(checkbox_binary($services["$metric_name"]), "1") ?>>

                                    <!------- Metric Name ------->
                                    <label for="<?= $metric_name ?>" class="form-check-label bold"><?= _("$formatted_metric_name") ?> <?= xi6_info_tooltip(_($metric_description)) ?></label>

                                </div>
                            </div>
                            <div class="col-sm-4 p-0">
                                <!------- Warning and Critical Thresholds ------->
                                <div class="input-group input-group-sm">
                                    <!-- Warning -->
                                    <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                    <input data-bucket-name="<?= $bucket_name ?>" data-batch-edit-id="CPUCreditUsage_warning" name="bucketlist[<?= $bucket_name ?>][metrics][<?= $metric_name ?>][warning]" value="<?= $serviceargs["$metric_name"."_warning"] ?>" class="form-control form-control-sm batch-edit-target" type="text">
                                </div>
                            </div>
                            <div class="col-sm-5 ps-1 pe-3">
                                <div class="input-group input-group-sm">
                                    <!-- Critical -->
                                    <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                    <input data-bucket-name="<?= $bucket_name ?>" data-batch-edit-id="CPUCreditUsage_critical" name="bucketlist[<?= $bucket_name ?>][metrics][<?= $metric_name ?>][critical]" value="<?= $serviceargs["$metric_name"."_critical"] ?>" class="form-control form-control-sm batch-edit-target" type="text">

                                    <!-- Units -->
                                    <label class="input-group-text no-border-bottom" style="width: 100px;"><?= _("$metric_units") ?></label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-3"></div>
                            <div class="col-sm-4 p-0">
                                <!------- Storage Type and Filter ID ------->
                                <div class="input-group input-group-sm">
                                    <!-- Storage Type -->
                                    <label class="input-group-text"><?= _("Storage Type") ?> <?= xi6_info_tooltip(_('This dimension filters the data that you have stored in a bucket by the type of storage'), false, false) ?></label>
                                    <input data-bucket-name="<?= $bucket_name ?>" data-batch-edit-id="<?= $metric_name ?>_warning" name="bucketlist[<?= $bucket_name ?>][metrics][<?= $metric_name ?>][storage_type]" value="<?= (array_key_exists("StorageType", $metric_info) ? $metric_info["StorageType"] : "")?>" class="form-control form-control-sm batch-edit-target" type="text" readonly>
                                </div>
                            </div>
                            <div class="col-sm-5 ps-1 pe-3">
                                <div class="input-group input-group-sm">
                                    <!-- Filter ID -->
                                    <label class="input-group-text"><?= _("Filter ID") ?> <?= xi6_info_tooltip(_('This dimension filters metrics configurations that you specify for request metrics on a bucket, for example, a prefix or a tag.You specify a filter id when you create a metrics configuration.'), false, false) ?></label>
                                    <input data-bucket-name="<?= $bucket_name ?>" data-batch-edit-id="<?= $metric_name ?>_critical" name="bucketlist[<?= $bucket_name ?>][metrics][<?= $metric_name ?>][filter_id]" value="<?= (array_key_exists('FilterId', $metric_info) ? $metric_info["FilterId"] : "") ?>" class="form-control form-control-sm batch-edit-target" type="text">
                                </div>
                            </div>
                        </div>
                    </div>
<?php
        }
?>
                    </div>
                </div>
            </div>
<?php
    }
?>
        </div> <!-- mainAccordion -->
    </div> <!-- container -->

    <script type="text/javascript">

        function searchBuckets( searchString ) {
            $(".bucket-wrapper").fadeOut(175);
            
            $(".bucket-wrapper").each(function() {
                bucket_name = $(this).data("bucket-name");
                region = $(this).data("region");
                
                bucket_name_result = bucket_name.indexOf(searchString);
                region_result = region.indexOf(searchString);

                if (bucket_name_result >= 0 || region_result >= 0) {
                    $(this).fadeIn(175);
                }

            });
        }

        $(document).ready(function() {
            
            $(".toggle-checkbox").on("click", function() {

                var bucket_name = $(this).attr("data-bucket-name");
                var legal_class_name = bucket_name.replace(/\./g, '_');
                var checkbox_class = "." + legal_class_name + "-checkbox";

                if (this.checked) {
                    $(checkbox_class).prop("checked", true);
                } else {
                    $(checkbox_class).prop("checked", false);
                }
            });

            var search;

            // Instance Search
            $("#bucket-search").on("keyup", function() {
                clearTimeout(search);
                searchString = $(this).val().toLowerCase();
                search = setTimeout('searchBuckets(searchString)', 400);
            });

            // Collapse or Expand all accordion-items
            $("#toggleAllAccordionItems").on("click", function() {
                var collapseElementList;
                var toggleAllAccordionItemsBtn = $('#mainAccordion').find('#toggleAllAccordionItems');
                var dummyItem = $('#mainAccordion').find('#dummyItem');

                if ($(dummyItem).hasClass('show')) {
                    collapseElementList = [].slice.call(document.querySelectorAll('.multi-collapse.show'));
                    $(dummyItem).removeClass('show');
                    $(toggleAllAccordionItemsBtn).addClass('collapsed');
                } else {
                    collapseElementList = [].slice.call(document.querySelectorAll('.multi-collapse.collapse:not(.show)'));
                    $(dummyItem).addClass('show');
                    $(toggleAllAccordionItemsBtn).removeClass('collapsed');
                }

                var collapseList = collapseElementList.map(function (collapseEl) {
                    return new bootstrap.Collapse(collapseEl)
                })
            });
        });

    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
