    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('DHCP Host') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this DHCP client or server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('Basic Settings') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="server_ip" class="form-label"><?= _('Server IP') ?> <?= xi6_info_tooltip(_('The IP address of the DHCP server a response is expected from. Leave blank for any server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="server_ip" id="server_ip" value="<?= encode_form_val($server_ip) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Server IP") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="server_ip_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="requested_ip" class="form-label"><?= _('Requested IP') ?> <?= xi6_info_tooltip(_('The IP address expected to be given by the DHCP server. Leave blank for any valid address')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="requested_ip" id="requested_ip" value="<?= encode_form_val($requested_address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Requested IP") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="requested_ip_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="mac_address" class="form-label"><?= _('MAC Address') ?> <?= xi6_info_tooltip(_('An optional MAC address to use in the DHCP request')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="mac_address" id="mac_address" value="<?= encode_form_val($mac_address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter MAC Address") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="mac_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="interface" class="form-label"><?= _('Interface') ?> <?= xi6_info_tooltip(_('The network interface to use for listening for DHCP responses (e.g eth0). Optional')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="interface" id="interface" value="<?= encode_form_val($interface) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Interface") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the ".$labelText) ?>
                    </div>
                    <i id="interface_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('Advanced Settings') ?></h2>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="uni" class="form-check-input" name="unicast"  <?= is_checked($unicast, "on") ?> >
                        <label for="uni" class="form-check-label bold"><?= _('Unicast Mode') ?> <?= xi6_info_tooltip(_('Use unicast mode to mimic a DHCP relay. Requires a server address to be specified above')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
