    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <h2 class="mb-2"><?= _('RADIUS Server') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Address") ?>" disabled="on">
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this RADIUS server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('Server Options') ?></h2>

        <div id="changeSecretOption" class="row mb-3 mt-4 visually-hidden">
            <div class="col-sm">
                <input type="checkbox" id="changeSecret" class="form-check-input" name="changeSecret">
                <label for="changeSecret" class="form-check-label bold"><?= _("Change Secret") ?> <?= xi6_info_tooltip(_("Use to change the Secret, otherwise, the existing Secret will be preserved.")) ?></label>
            </div>
        </div>

        <div id="setSecret" class="row mb-2">
            <div class="col-sm-6">
                <label for="secret" class="form-label form-item-required"><?= _('Secret') ?> <?= xi6_info_tooltip(_('The shared secret to use when logging into the RADIUS server')) ?></label>
                <div class="input-group input-group-sm">
                    <input type="password" name="secret" id="secret" value="<?= encode_form_val($secret) ?>" class="usermacro-detection form-control rounded-start" autocomplete="off" placeholder="<?= _("Enter Secret") ?>" required>
                    <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end" id="password-secret" title="<?= _("Show Secret") ?>">
                        <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                        <i id="secret_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </button>
                    <div class="invalid-feedback">
                        <?= _("Please enter the Secret") ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="username" class="form-label form-item-required"><?= _('Username') ?> <?= xi6_info_tooltip(_('The username used to login to the RADIUS server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Username") ?>" required>
                    <div class="invalid-feedback">
                        <?= _("Please enter the Username") ?>
                    </div>
                    <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
            <div class="col-sm">
                <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                <label for="changePassword" class="form-check-label bold"><?= _('Change Password') ?> <?= xi6_info_tooltip(_("Use to change the password, otherwise, the existing password will be preserved.")) ?></label>
            </div>
        </div>
        <div id="setPassword" class="row mb-2">
            <div class="col-sm-6">
                <label for="password" class="form-label form-item-required"><?= _("Password") ?> <?= xi6_info_tooltip(_("The password used to login to the RADIUS server.")) ?></label>
                <div class="input-group input-group-sm">
                    <input type="password" name="password" id="password" value="<?= encode_form_val($password) ?>" class="usermacro-detection form-control rounded-start" autocomplete="off" placeholder="<?= _("Enter Password") ?>" required>
                    <button type="button" class="btn btn-outline-secondary btn-show-secret rounded-end" id="password-secret" title="<?= _("Show password") ?>">
                        <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                        <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </button>
                    <div class="invalid-feedback">
                        Please enter the Password
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="port" class="form-label form-item-required"><?= _('Port') ?> <?= xi6_info_tooltip(_('The port number the RADIUS server runs on')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port") ?>" required>
                    <div class="invalid-feedback">
                        <?= _("Please enter the Port") ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
