    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="snmpversion" value="<?= encode_form_val($snmpversion) ?>">
    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="vendor" value="<?= encode_form_val($vendor) ?>">
    <input type="hidden" name="snmpopts_serial" value="<?= $snmpopts_serial ?>">
    <input type="hidden" name="portnames" value="<?= encode_form_val($portnames) ?>">
    <input type="hidden" name="scaninterfaces" value="<?= encode_form_val($scaninterfaces) ?>">
    <input type="hidden" name="warn_speed_in_percent" value="<?= encode_form_val($warn_speed_in_percent) ?>">
    <input type="hidden" name="crit_speed_in_percent" value="<?= encode_form_val($crit_speed_in_percent) ?>">
    <input type="hidden" name="warn_speed_out_percent" value="<?= encode_form_val($warn_speed_out_percent) ?>">
    <input type="hidden" name="crit_speed_out_percent" value="<?= encode_form_val($crit_speed_out_percent) ?>">

<style type="text/css">
    .min-width-8em { min-width: 8em; }
    .min-width-20em { min-width: 20em; }
</style>

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container-fluid m-0 g-0">

        <h2 class="mb-2"><?= _('WatchGuard device Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('WatchGuard Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter WatchGuard Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this WatchGuard device')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Services') ?></h2>
        <p><?= _('Specify which services to monitor for the WatchGuard device.') ?></p>
<?php
    // Create variable here to avoid typos, which will hold the name of the service we are editing
    // Create Ping service HTML
    $cs = array(0 => "ping");
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm mt-0 pt-1">
                        <input type="checkbox" id="<?= $cs[0] ?>" class="form-check-input" name="services[<?= $cs[0] ?>]" <?= is_checked(grab_array_var($services, $cs[0]), "on") ?>>
                        <label for="<?= $cs[0] ?>" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_('Monitors the WatchGuard device with an ICMP ping. Useful for watching network latency.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    // Create CPU Usage service HTML
    $cs = array('name' => "cpu_usage",
                'title' => _("CPU Usage"),
                'desc' => _("Monitors the Watchguards CPU usage."),);
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" id="<?= $cs['name'] ?>" class="form-check-input" name="services[<?= $cs['name'] ?>]"  <?= is_checked(grab_array_var($services, $cs['name']), "on")  ?>>
                        <label for="<?= $cs['name'] ?>" class="form-check-label bold"><?= $cs['title'] ?> <?= xi6_info_tooltip($cs['desc']) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_warning]" id="serviceargs[<?= $cs['name'] ?>_warning]" value="<?= encode_form_val($serviceargs[$cs['name']."_warning"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_critical]" id="serviceargs[<?= $cs['name'] ?>_critical]" value="<?= encode_form_val($serviceargs[$cs['name']."_critical"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    // Create Active Connections service HTML
    $cs = array('name' => "active_connections",
                'title' => _("Active Connections"),
                'desc' => _("Checks the active connections the WatchGuard device is servicing."),);
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" id="<?= $cs['name'] ?>" class="form-check-input" name="services[<?= $cs['name'] ?>]"  <?= is_checked(grab_array_var($services, $cs['name']), "on")  ?>>
                        <label for="<?= $cs['name'] ?>" class="form-check-label bold"><?= $cs['title'] ?> <?= xi6_info_tooltip($cs['desc']) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_warning]" id="serviceargs[<?= $cs['name'] ?>_warning]" value="<?= encode_form_val($serviceargs[$cs['name']."_warning"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_critical]" id="serviceargs[<?= $cs['name'] ?>_critical]" value="<?= encode_form_val($serviceargs[$cs['name']."_critical"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    // Create Total Sent Packets service HTML
    $cs = array('name' => "total_sent_packets",
                'title' => _("Total Sent Packets"),
                'desc' => _("Checks the total number of packets sent by the WatchGuard device."),);
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" id="<?= $cs['name'] ?>" class="form-check-input" name="services[<?= $cs['name'] ?>]"  <?= is_checked(grab_array_var($services, $cs['name']), "on")  ?>>
                        <label for="<?= $cs['name'] ?>" class="form-check-label bold"><?= $cs['title'] ?> <?= xi6_info_tooltip($cs['desc']) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_warning]" id="serviceargs[<?= $cs['name'] ?>_warning]" value="<?= encode_form_val($serviceargs[$cs['name']."_warning"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_critical]" id="serviceargs[<?= $cs['name'] ?>_critical]" value="<?= encode_form_val($serviceargs[$cs['name']."_critical"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    // Create Total Received Packets service HTML
    $cs = array('name' => "total_received_packets",
                'title' => _("Total Received Packets"),
                'desc' => _("Checks the total number of packets received by the WatchGuard device."),);
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" id="<?= $cs['name'] ?>" class="form-check-input" name="services[<?= $cs['name'] ?>]"  <?= is_checked(grab_array_var($services, $cs['name']), "on")  ?>>
                        <label for="<?= $cs['name'] ?>" class="form-check-label bold"><?= $cs['title'] ?> <?= xi6_info_tooltip($cs['desc']) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_warning]" id="serviceargs[<?= $cs['name'] ?>_warning]" value="<?= encode_form_val($serviceargs[$cs['name']."_warning"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_critical]" id="serviceargs[<?= $cs['name'] ?>_critical]" value="<?= encode_form_val($serviceargs[$cs['name']."_critical"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    // Create Stream Requests Total service HTML
    $cs = array('name' => "stream_requests_total",
                'title' => _("Stream Requests"),
                'desc' => _("Checks the total number of stream requests received by the WatchGuard device."),);
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" id="<?= $cs['name'] ?>" class="form-check-input" name="services[<?= $cs['name'] ?>]"  <?= is_checked(grab_array_var($services, $cs['name']), "on")  ?>>
                        <label for="<?= $cs['name'] ?>" class="form-check-label bold"><?= $cs['title'] ?> <?= xi6_info_tooltip($cs['desc']) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_warning]" id="serviceargs[<?= $cs['name'] ?>_warning]" value="<?= encode_form_val($serviceargs[$cs['name']."_warning"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_critical]" id="serviceargs[<?= $cs['name'] ?>_critical]" value="<?= encode_form_val($serviceargs[$cs['name']."_critical"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    // Create Stream Requests Drop service HTML
    $cs = array('name' => "stream_requests_drop",
                'title' => _("Stream Requests Dropped"),
                'desc' => _("Checks the total number of stream requests dropped by the WatchGuard device."),);
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" id="<?= $cs['name'] ?>" class="form-check-input" name="services[<?= $cs['name'] ?>]"  <?= is_checked(grab_array_var($services, $cs['name']), "on")  ?>>
                        <label for="<?= $cs['name'] ?>" class="form-check-label bold"><?= $cs['title'] ?> <?= xi6_info_tooltip($cs['desc']) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_warning]" id="serviceargs[<?= $cs['name'] ?>_warning]" value="<?= encode_form_val($serviceargs[$cs['name']."_warning"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_critical]" id="serviceargs[<?= $cs['name'] ?>_critical]" value="<?= encode_form_val($serviceargs[$cs['name']."_critical"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    // Create Total Bytes Sent service HTML
    $cs = array('name' => "total_sent_bytes",
                'title' => _("Total Bytes Sent"),
                'desc' => _("Checks the total number of bytes sent by the WatchGuard device."),);
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" id="<?= $cs['name'] ?>" class="form-check-input" name="services[<?= $cs['name'] ?>]"  <?= is_checked(grab_array_var($services, $cs['name']), "on")  ?>>
                        <label for="<?= $cs['name'] ?>" class="form-check-label bold"><?= $cs['title'] ?> <?= xi6_info_tooltip($cs['desc']) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_warning]" id="serviceargs[<?= $cs['name'] ?>_warning]" value="<?= encode_form_val($serviceargs[$cs['name']."_warning"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_critical]" id="serviceargs[<?= $cs['name'] ?>_critical]" value="<?= encode_form_val($serviceargs[$cs['name']."_critical"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    // Create Total Received Bytes service HTML
    $cs = array('name' => "total_received_bytes",
                'title' => _("Total Received Bytes"),
                'desc' => _("Checks the total number of bytes received by the WatchGuard device."),);
?>
        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" id="<?= $cs['name'] ?>" class="form-check-input" name="services[<?= $cs['name'] ?>]"  <?= is_checked(grab_array_var($services, $cs['name']), "on")  ?>>
                        <label for="<?= $cs['name'] ?>" class="form-check-label bold"><?= $cs['title'] ?> <?= xi6_info_tooltip($cs['desc']) ?></label>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_warning]" id="serviceargs[<?= $cs['name'] ?>_warning]" value="<?= encode_form_val($serviceargs[$cs['name']."_warning"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_warning_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                            </span>
                            <input type="text" name="serviceargs[<?= $cs['name'] ?>_critical]" id="serviceargs[<?= $cs['name'] ?>_critical]" value="<?= encode_form_val($serviceargs[$cs['name']."_critical"]) ?>" class="form-control form-control-sm monitor">
                            <span class="input-group-text">%</span>
                            <i id="serviceargs_<?= $cs['name'] ?>_critical_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
    if ($scaninterfaces == "on") {
        // Read results of MRTG's scan
        // TODO - if WatchGuard device is already in mrtg.cfg, read that instead...
        $tmp_dir = get_tmp_dir();
        $outfile = $tmp_dir."/mrtgscan-".$address;
        $ports = watchguard_configwizard_read_walk_file($outfile, $address);
?>
        <h2 class="mt-4 mb-2"><?= _('Bandwidth and Port Status') ?></h2>
<?php
        if (count($ports) > 0) {
?>
        <p><?= _("Select the ports for which you'd like to monitor bandwidth and port status. You may specify an optional port name to be associated with specific ports.") ?></p>

        <div class="table-responsive table-responsive-sm">
            <table class="table table-sm table-hover table-striped table-bordered">
                <thead>
                    <tr class="fa-12">
                        <th scope="col" class="align-top">
                            <?= _('Port') ?>
                            <div class="text-nowrap min-width-8em">
                                <a class="btn btn-link p-0" id="switchCheckAll" title="<?= _('Check All Ports') ?>"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>
                                <a class="btn btn-link p-0" id="switchUncheckAll" title="<?= _('Uncheck All Ports') ?>"><i class="fa fa-square-o" aria-hidden="true"></i></a>
                            </div>
                        </th>
                        <th scope="col" class="align-top">
                            <?= _('Port Name') ?>
                        </th>
                        <th scope="col" class="align-top">
                            <?= _('Max Speed') ?>
                        </th>
                        <th scope="col" class="align-top text-nowrap">
                            <?= _('Service Description') ?>
                        </th>
                        <th scope="col" class="align-top">
                            <?= _('Bandwidth') ?>
                            <div class="text-nowrap min-width-8em">
                                <a class="btn btn-link p-0" id="bandwidthCheckAll" title="<?= _('Check All Ports') ?>"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>
                                <a class="btn btn-link p-0" id="bandwidthUncheckAll" title="<?= _('Uncheck All Ports') ?>"><i class="fa fa-square-o" aria-hidden="true"></i></a>
                            </div>
                        </th>
                        <th scope="col" class="align-top">
                            <?= _('Port Status') ?>
                            <div class="text-nowrap min-width-8em">
                                <a class="btn btn-link p-0" id="statusCheckAll" title="<?= _('Check All Ports') ?>"><i class="fa fa-check-square-o" aria-hidden="true"></i></a>
                                <a class="btn btn-link p-0" id="statusUncheckAll" title="<?= _('Uncheck All Ports') ?>"><i class="fa fa-square-o" aria-hidden="true"></i></a>
                            </div>
                        </th>
                    </tr>
                </thead>
                <tbody>
<?php
            $x = 0;

            foreach ($ports as $port_num => $parr) {
                $port_bytes = grab_array_var($parr, "max_bytes", 0);

                // We'll use either description or number as the name later
                $port_description = grab_array_var($parr, "port_description", $port_num);
                $port_number = grab_array_var($parr, "port_number", $port_num);
                $port_long_desc = grab_array_var($parr, "port_long_description", $port_num);

                // Remome illegal chars in portnames -SW
                // `~!$%^&*|'"<>?,()=\n                $badchars = explode(" ", "; ` ~ ! $ % ^ & * | ' \" < > ? , ( ) = \ { } [ ]");
                $port_number = str_replace($badchars, " ", $port_number);
                $port_description = str_replace($badchars, " ", $port_description);
                $port_long_desc = str_replace($badchars, " ", $port_long_desc);

                // Default to using port number for service name
                $port_name = "Port ".$port_number;

                if ($portnames == "name") {
                    $port_name = $port_long_desc; //changed to long description -MG
                }

                $x++;

                $max_speed = watchguard_configwizard_get_readable_port_line_speed($port_bytes, $speed, $label);
                $warn_in_speed = ($speed * ($warn_speed_in_percent / 100));
                $warn_out_speed = ($speed * ($warn_speed_out_percent / 100));
                $crit_in_speed = ($speed * ($crit_speed_in_percent / 100));
                $crit_out_speed = ($speed * ($crit_speed_out_percent / 100));

                // Possible refomat speed values/labels
                watchguard_configwizard_recalculate_speeds($warn_in_speed, $warn_out_speed, $crit_in_speed, $crit_out_speed, $label);
?>
                    <tr class="fa-12">
                        <td class="text-nowrap">
                            <div class="mt-1">
                                <input type="checkbox" class="form-check-input me-1 portbox" id="port_<?= $port_num ?>" name="services[port][<?= $port_num ?>]" checked>
                                <label class="form-label">
                                    <?= _('Port ').$port_num ?>
                                </label>
                            </div>
                        </td>
                        <td class="min-width-20em">
                            <?= encode_form_val($port_description) ?>
                        </td>
                        <td class="text-nowrap">
                            <?= $max_speed ?>
                        </td>
                        <td>
                            <input type="text" name="serviceargs[portname][<?= $port_num ?>]" value="<?= $port_name ?>" class="form-control form-control-sm">
                        </td>
                        <td>
                            <table class="table table-sm table-borderless">
                                <tr class="fa-12">
                                    <td>
                                        <input type="checkbox" class="form-check-input bandwidthbox" id="bandwidth_<?= $port_num ?>" name="serviceargs[bandwidth][<?= $port_num ?>]" checked>
                                    </td>
                                    <td><label class="form-label mt-1 text-nowrap min-width-8em"><?= _('Rate In') ?></label></td>
                                    <td><label class="form-label mt-1 text-nowrap min-width-8em"><?= _('Rate Out') ?></label></td>
                                    <td><label class="form-label mt-1 text-nowrap min-width-8em"><?= _('Rate In') ?></label></td>
                                    <td><label class="form-label mt-1 text-nowrap min-width-8em"><?= _('Rate Out') ?></label></td>
                                    <td><label class="form-label mt-1 text-nowrap min-width-8em"></label></td>
                                </tr>
                                <tr class="fa-12">
                                    <td></td>
                                    <td>
                                        <div class="input-group input-group-sm flex-nowrap">
                                            <span class="input-group-text">
                                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                            </span>
                                            <input type="text" name="serviceargs[bandwidth_warning_input_value][<?= $port_num ?>]" value="<?= number_format($warn_in_speed) ?>" class="form-control form-control-sm monitor rounded-end">
                                            <i id="serviceargs_bandwidth_warning_input_value_<?= $port_num ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm flex-nowrap">
                                            <span class="input-group-text">
                                                <i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400 md-middle">warning</i>
                                            </span>
                                            <input type="text" name="serviceargs[bandwidth_warning_output_value][<?= $port_num ?>]" value="<?= number_format($warn_out_speed) ?>" class="form-control form-control-sm monitor rounded-end">
                                            <i id="serviceargs_bandwidth_warning_output_value_<?= $port_num ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm flex-nowrap">
                                            <span class="input-group-text">
                                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                            </span>
                                            <input type="text" name="serviceargs[bandwidth_critical_input_value][<?= $port_num ?>]" value="<?= number_format($crit_in_speed) ?>" class="form-control form-control-sm monitor rounded-end">
                                            <i id="serviceargs_bandwidth_critical_input_value_<?= $port_num ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input-group-sm flex-nowrap">
                                            <span class="input-group-text">
                                                <i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400 md-middle">error</i>
                                            </span>
                                            <input type="text" name="serviceargs[bandwidth_critical_output_value][<?= $port_num ?>]" value="<?= number_format($crit_out_speed) ?>" class="form-control form-control-sm monitor rounded-end">
                                            <i id="serviceargs_bandwidth_critical_output_value_<?= $port_num ?>_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                        </div>
                                    </td>
                                    <td>
                                        <select name="serviceargs[bandwidth_speed_label][<?= $port_num ?>]" class="form-control form-control-sm form-select form-select-sm">
                                            <option value="Gbps" <?= is_selected("Gbps", $label) ?>><?= _('Gbps') ?></option>
                                            <option value="Mbps" <?= is_selected("Mbps", $label) ?>><?= _('Mbps') ?></option>
                                            <option value="Kbps" <?= is_selected("Kbps", $label) ?>><?= _('Kbps') ?></option>
                                            <option value="bps" <?= is_selected("bps", $label) ?>><?= _('bps') ?></option>
                                        </select>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td class="text-center">
                            <input type="checkbox" class="form-check-input statusbox" id="portstatus_<?= $port_num ?>" name="serviceargs[portstatus][<?= $port_num ?>]" checked>
                        </td>
                    </tr>
<?php
            }
?>
              </tbody>
            </table>
        </div>
<?php
        } else {
?>
        <div class="alert alert-danger w-75">
            <div class="align-items-center d-flex pb-3">
                <i class="material-symbols-outlined md-400">warning</i>
                <span class="fw-bold ps-2 pe-2"><?= _('No ports were detected on the WatchGuard device.') ?></span>
            </div>
            <div class="card card-p">
                <h2 class="mb-2 text-dark"><?= _('Possible reasons for this include...') ?></h2>
                <ul class="list-group">
                    <li class="list-group-item"><?= _('The WatchGuard device is currently down') ?>.</li>
                    <li class="list-group-item"><?= _('The WatchGuard device does not exist at the address you specified') ?>.</li>
                    <li class="list-group-item"><?= _('SNMP support on the WatchGuard device is disabled') ?>.</li>
                </ul>
            </div>
        </div>
<?php
            if (is_admin() == true) {
                $cfgmaker_cmd = watchguard_configwizard_get_cfgmaker_cmd($snmpopts, $address, $address_port, $snmpversion);
?>
        <div class="alert alert-danger w-75 mt-4">
            <div class="align-items-center d-flex pb-3">
                <i class="material-symbols-outlined">construction</i>
                <span class="fw-bold ps-2"><?= _('Troubleshooting Tip') ?></span>
            </div>
            <div class="card card-p">
                <p class="text-start">
                    <?= _('If you keep experiencing problems with the WatchGuard device wizard scan, login to the Nagios XI server as the root user and execute the following command.') ?>
                </p>
                <pre><code><?= $cfgmaker_cmd ?></code></pre>
                <p class="text-start">
                    <?= _('Send the output of the command and a description of your problem to the Nagios support team by posting to our online ') ?><a href="http://support.nagios.com/forum/" target="_blank"><?= _('support forum') ?></a>.
                </p>
            </div>
        </div>
<?php
            }
        }
    }
?>
    </div> <!-- container -->

    <script type="text/javascript">
        //check all ports
        var allChecked = false;

        $(document).ready(function () {
            // Bind events
            $("#switchCheckAll").on("click", function() {
                switchCheckAll();
            })
            $("#switchUncheckAll").on("click", function() {
                switchUncheckAll();
            })
            $("#bandwidthCheckAll").on("click", function() {
                bandwidthCheckAll();
            })
            $("#bandwidthUncheckAll").on("click", function() {
                bandwidthUncheckAll();
            })
            $("#statusCheckAll").on("click", function() {
                statusCheckAll();
            })
            $("#statusUncheckAll").on("click", function() {
                statusUncheckAll();
            })
        });

        function switchCheckAll() {
            $(".portbox:checkbox").each(function() {
              this.checked = "checked";
            });
        }

        function switchUncheckAll() {
            $(".portbox:checkbox").each(function() {
              this.checked = "";
            });
        }

        function bandwidthCheckAll() {
            $(".bandwidthbox:checkbox").each(function() {
              this.checked = "checked";
            });
        }

        function bandwidthUncheckAll() {
            $(".bandwidthbox:checkbox").each(function() {
              this.checked = "";
            });
        }

        function statusCheckAll() {
            $(".statusbox:checkbox").each(function() {
              this.checked = "checked";
            });
        }

        function statusUncheckAll() {
            $(".statusbox:checkbox").each(function() {
              this.checked = "";
            });
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
