    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2 class="mb-2"><?= _('Host Information') ?></h2>

            <div class="alert alert-info mb-3">
                <h5><?= _('Not seeing your passive checks?') ?></h5>
                <p><?= _('You may have misconfigured your checks. Check') ?> <a href="<?= get_base_url() ?>admin/missingobjects.php" data-window="missingobjects.php" class="xi-window-link"><?= _('Admin > Monitoring Config > Unconfigured Objects') ?></a> <?= _('to view and configure passive checks that have been received but are not yet configured properly. You can either configure specific hosts/services or set up automatic configuration for incoming checks.') ?></p>
            </div>

            <div class="alert alert-info mb-3">
                <h5><?= _('Need your NRDP token?') ?></h5>
                <p><?= _('You can find your Nagios XI server\'s NRDP authentication token in') ?> <a href="<?= get_base_url() ?>admin/dtinbound.php" data-window="dtinbound.php" class="xi-window-link"><?= _('Admin > Check Transfers > Inbound Transfers') ?></a>.</p>
            </div>

            <script>
                // Ensures consistent navigation experience when opening links in new tabs/windows vs opening in the current window
                document.addEventListener('DOMContentLoaded', function() {
                    document.querySelectorAll('.xi-window-link').forEach(function(link) {
                        const originalHref = link.href;
                        const windowParam = link.dataset.window;
                        
                        link.addEventListener('click', function(e) {
                            // Regular click - ensure href is the original URL
                            link.href = originalHref;
                            return true;
                        });
                        
                        link.addEventListener('auxclick', function(e) {
                            // Middle click/auxiliary click - modify the URL
                            if (e.button === 1) { // Middle mouse button
                                link.href = '<?= get_base_url() ?>admin/?xiwindow=' + windowParam;
                                setTimeout(() => {
                                    link.href = originalHref;
                                }, 100);
                            }
                        });
                        
                        link.addEventListener('mousedown', function(e) {
                            // Right click detection happens on mousedown
                            if (e.button === 2) { // Right mouse button
                                link.href = '<?= get_base_url() ?>admin/?xiwindow=' + windowParam;
                            }
                        });
                        
                        // Restore original href when context menu is closed or action is taken
                        document.addEventListener('click', function() {
                            link.href = originalHref;
                        }, true);
                    });
                });
            </script>    
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _('Address') ?> <?= xi6_info_tooltip(_('The IP address or FQDNS name of the device or server associated with the passive check(s)')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="securitycheck" class="form-label form-item-required"><?= _('Check Type') ?> <?= xi6_info_tooltip(_('What type of passive check(s) are you configuring? Your selection here will be used to set defaults on the next screen')) ?></label>
                    <div class="input-group position-relative">
                        <select name="securitycheck" id="securitycheck" class="form-select monitor rounded" placeholder="<?= _("Select Check Type") ?> " required>
                            <option value="" disabled selected>Choose a Check Type...</option>
                            <option value="yes" <?= is_selected($securitycheck, 'yes') ?>><?= _('Security-Related Check') ?></option>
                            <option value="no" <?= is_selected($securitycheck, 'no') ?>><?= _('Other Check Type') ?></option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Check Type
                        </div>
                        <i id="securitycheck_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
