    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= (!empty($hostname)) ? encode_form_val($hostname) : "" ?>">
    <input type="hidden" id="operation" name="operation" value="<?= (!empty($operation)) ? encode_form_val($operation) : "" ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= (!empty($selectedhostconfig)) ? encode_form_val($selectedhostconfig) : "" ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="hostname" value="<?= (!empty($hostname)) ? encode_form_val($hostname) : "" ?>">
    <input type="hidden" name="accesskeyid" value="<?= (!empty($accesskeyid)) ? encode_form_val($accesskeyid) : "" ?>">
    <input type="hidden" name="accesskey" value="<?= (!empty($accesskey)) ? encode_form_val($accesskey) : "" ?>">
    <input type="hidden" name="staticcreds" value="<?= (!empty($staticcreds)) ? encode_form_val($staticcreds) : "" ?>">
    <input type="hidden" name="staticconfig" value="<?= (!empty($staticconfig)) ? encode_form_val($staticconfig) : "" ?>">
    <input type="hidden" name="credsfilepath" value="<?= (!empty($credsfilepath)) ? encode_form_val($credsfilepath) : "" ?>">
    <input type="hidden" name="configfilepath" value="<?= (!empty($configfilepath)) ? encode_form_val($configfilepath) : "" ?>">
<?php
    if ($staticcreds == "on") {
?>
    <input type="hidden" name="credsfilepath" value="<?= (!empty($credsfilepath)) ? encode_form_val($credsfilepath) : "" ?>">
<?php
    } else {
?>
    <input type="hidden" name="accesskeyid" value="<?= (!empty($accesskeyid)) ? encode_form_val($accesskeyid) : "" ?>">
    <input type="hidden" name="accesskey" value="<?= (!empty($accesskey)) ? encode_form_val($accesskey) : "" ?>">
<?php
    }

    if ($staticconfig == "on") {
?>
    <input type="hidden" name="configfilepath" value="<?= (!empty($configfilepath)) ? encode_form_val($configfilepath) : "" ?>">
<?php
    }
/*    <link rel="stylesheet" href="<?= $main_css_url ?>"/> */
?>
<?php
    #include_once __DIR__.'/../../../utils-xi6-wizards.inc.php';
?>
<style>
.dummyButton.accordion-button:not(.collapsed) {
    background-color: inherit;
}
.dummyButton.accordion-button.collapsed::after,
.dummyButton.accordion-button:not(.collapsed)::after {
    background-image: url("http://192.168.0.32/nagiosxi/images/pixel.png");
}
#toggleAllAccordionItems.accordion-button:focus {
    box-shadow: none;
}
#toggle-all-instances,
.instance-batch-checkbox {
    z-index: 2000; top: 1rem; left: calc(2rem - 1em);
}
h2 {
    margin-bottom: 0px !important;
}
.accordion-header { 
    margin-top: 0px;
    margin-bottom: 0px;
}
button.accordion-button {
    padding-bottom: 0px;
}

</style>

    <div class="container-md m-0 g-0">

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mb-2"><?= _('EC2 Instance Metrics') ?></h2>

        <div id="advanced-wrapper" class="row mb-4">
            <div id="batch-edit-grid" class="col-sm-3">
                <div class="border-block">
                    <div>
                        <label for="show-batch-edit-btn" class="form-label">Batch Edit <?= xi6_info_tooltip(_('Open the &quot;Batch Edit&quot; section. Settings in the &quot;Batch Edit&quot; section will be applied to all instances, that have been selected/checked below, when you &quot;Apply Batch Edit&quot;').'.') ?></label>
                    </div>
                    <button type="button" class="btn btn-sm btn-outline-primary" id="show-batch-edit-btn"><?= _("Edit All Selected") ?></button>
                </div>
            </div>
            <div id="search-grid" class="col-sm-8">
                <div class="border-block">
                    <label for="instance-search" class="form-label"><?= _('Filter Instances') ?> <?= xi6_info_tooltip(_('Filter by Instance ID, IP Address or Region')) ?></label>
                    <input type="text" class="form-control form-control-sm mb-1" id="instance-search" />
                </div>
            </div>
        </div>

        <!------------------------------------------->
        <!------- BEGIN BATCH EDIT HTML HERE -------->
        <!------------------------------------------->

        <div class="accordion mb-4 hide" id="batch-edit">
            <div class="accordion-item">
                <h2 class="accordion-header" id="batch-edit-header">
                    <button class="accordion-button d-flex justify-content-center dummyButton" type="button" data-bs-toggle="" data-bs-target="#batch-edit-content" aria-expanded="true" aria-controls="batch-edit-content">
                        <?= _("Batch Edit") ?>
                    </button>
                </h2>
                <div id="batch-edit-content" class="accordion-collapse collapse show" aria-labelledby="batch-edit-heading">
                    <div class="accordion-body table-responsive table-responsive-sm">
                        <table class="table table-sm table-borderless">
                            <tr>

                                <!---------- CPUCreditUsage ---------->

                                <td class="p-0">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _('CPU Credit Usage') ?> <?= xi6_info_tooltip(_('The number of CPU credits spend by the instance for CPU utilization.'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="CPUCreditUsage_warning" class="form-control form-control-sm min-width-8em batch-edit-input" type="text" value="<?= $serviceargs["CPUCreditUsage_warning"] ?>" />
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="CPUCreditUsage_critical" class="form-control form-control-sm min-width-8em batch-edit-input" type="text" value="<?= $serviceargs["CPUCreditUsage_critical"] ?>" />
                                        <span class="input-group-text min-width-14em"><?= _("Credits (vCPU-minutes)") ?></span>
                                    </div>
                                </td>

                                <!---------- Network Bytes In ---------->

                                <td class="p-0 ps-2">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _('Network Bytes In') ?> <?= xi6_info_tooltip(_('The number of bytes received on all network interfaces by the instance.'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="NetworkBytesIn_warning" class="form-control form-control-sm min-width-10em batch-edit-input" type="text" value="<?= $serviceargs["NetworkIn_warning"] ?>" />
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="NetworkBytesIn_critical" class="form-control form-control-sm min-width-10em batch-edit-input" type="text" value="<?= $serviceargs["NetworkIn_critical"] ?>" />
                                        <div class="input-group-text min-width-8em"><?= _("Bytes") ?></div>
                                    </div>
                                </td>
                            </tr>
                            <tr>

                                <!---------- CPU Credit Balance ---------->

                                <td class="p-0">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _('CPU Credit Balance') ?> <?= xi6_info_tooltip(_('The number of earned CPU credits that an instance has accrued since it was launched or started.'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="CPUCreditBalance_warning" class="form-control form-control-sm min-width-8em batch-edit-input" type="text" value="<?= $serviceargs["CPUCreditBalance_warning"] ?>" />
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="CPUCreditBalance_critical" class="form-control form-control-sm min-width-8em batch-edit-input" type="text" value="<?= $serviceargs["CPUCreditBalance_critical"] ?>" />
                                        <div class="input-group-text min-width-14em"><?= _("Credits (vCPU-minutes)") ?></div>
                                    </div>
                                </td>

                                <!---------- Network Bytes Out ---------->

                                <td class="p-0 ps-2">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _("Network Bytes Out") ?> <?= xi6_info_tooltip(_('The number of bytes sent out on all network interfaces by the instance.'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="NetworkBytesOut_warning" class="form-control form-control-sm min-width-10em batch-edit-input" value="<?= $serviceargs["NetworkOut_warning"] ?>" />
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="NetworkBytesOut_critical" class="form-control form-control-sm min-width-10em batch-edit-input" value="<?= $serviceargs["NetworkOut_critical"] ?>" />
                                        <div class="input-group-text min-width-8em"><?= _("Bytes") ?></div>
                                    </div>
                                </td>
                            </tr>
                            <tr>

                                <!---------- CPU Utilization ---------->

                                <td class="p-0">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _("CPU Utilization") ?> <?= xi6_info_tooltip(_('The percentage of allocated EC2 compute units that are currently in use on the instance.'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="CPUUtilization_warning" class="form-control form-control-sm min-width-8em batch-edit-input" type="text" value="<?= $serviceargs["CPUUtilization_warning"] ?>" />
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="CPUUtilization_critical" class="form-control form-control-sm min-width-8em batch-edit-input" type="text" value="<?= $serviceargs["CPUUtilization_critical"] ?>" />
                                        <div class="input-group-text min-width-14em">%</div>
                                    </div>
                                </td>

                                <!---------- Network Packets In ---------->

                                <td class="p-0 ps-2">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _('Network Packets In') ?> <?= xi6_info_tooltip(_('The number of packets received on all network interfaces by the instance'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="NetworkPacketsIn_warning" type="text" class="form-control form-control-sm min-width-10em batch-edit-input" value="<?= $serviceargs["NetworkPacketsIn_warning"] ?>">
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="NetworkPacketsIn_critical" type="text" class="form-control form-control-sm min-width-10em batch-edit-input" value="<?= $serviceargs["NetworkPacketsIn_critical"] ?>">
                                        <div class="input-group-text min-width-8em"><?= _("Packets") ?></div>
                                    </div>
                                </td>
                            </tr>
                            <tr>

                                <!---------- Disk Read Operations ---------->

                                <td class="p-0">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _('Disk Read Operations') ?> <?= xi6_info_tooltip(_('Completed read operations from all instance store volumes available to the instance in a specified period of time'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="DiskReadOperations_warning" class="form-control form-control-sm min-width-8em batch-edit-input" type="text" value="<?= $serviceargs["DiskReadOps_warning"] ?>" />
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="DiskReadOperations_critical" class="form-control form-control-sm min-width-8em batch-edit-input" type="text" value="<?= $serviceargs["DiskReadOps_critical"] ?>" />
                                        <div class="input-group-text min-width-14em">IOPS</div>
                                    </div>
                                </td>

                                <!---------- Network Packets Out ---------->

                                <td class="p-0 ps-2">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _('Network Packets Out') ?> <?= xi6_info_tooltip(_('The number of packets sent out on all network interfaces by the instance'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="NetworkPacketsOut_warning" class="form-control form-control-sm min-width-10em batch-edit-input" type="text" value="<?= $serviceargs["NetworkPacketsOut_warning"] ?>" />
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="NetworkPacketsOut_critical" class="form-control form-control-sm min-width-10em batch-edit-input" type="text" value="<?= $serviceargs["NetworkPacketsOut_critical"] ?>" />
                                        <div class="input-group-text min-width-8em"><?= _("Packets") ?></div>
                                    </div>
                                </td>
                            </tr>
                            <tr>

                                <!---------- Disk Write Operations ---------->

                                <td class="p-0">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _('Disk Write Operations') ?> <?= xi6_info_tooltip(_('Completed write operations to all instance store volumes available to the instance in a specified period of time'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="DiskWriteOperations_warning" class="form-control form-control-sm min-width-8em batch-edit-input" type="text" value="<?= $serviceargs["DiskWriteOps_warning"] ?>" />
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="DiskWriteOperations_critical" class="form-control form-control-sm min-width-8em batch-edit-input" type="text" value="<?= $serviceargs["DiskWriteOps_critical"] ?>" />
                                        <div class="input-group-text min-width-14em">IOPS</div>
                                    </div>
                                </td>

                                <!---------- Disk Read Bytes ---------->

                                <td class="p-0 ps-2">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _('Disk Read Bytes') ?> <?= xi6_info_tooltip(_('Bytes read from all instance store volumes available to the instance'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="DiskReadBytes_warning" class="form-control form-control-sm min-width-10em batch-edit-input" type="text" value="<?= $serviceargs["DiskReadBytes_warning"] ?>" />
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="DiskReadBytes_critical" class="form-control form-control-sm min-width-10em batch-edit-input" type="text" value="<?= $serviceargs["DiskReadBytes_critical"] ?>" />
                                        <div class="input-group-text min-width-8em"><?= _("Bytes") ?></div>
                                    </div>
                                </td>
                            </tr>
                            <tr>

                                <!---------- Status Check Failed ---------->

                                <td class="p-0">
                                    <div class="input-group input-group-sm m-2 ms-0 flex-nowrap">
                                        <input id="StatusCheckFailed" data-batch-edit-target="StatusCheckFailed_checkbox" type="checkbox" class="form-check-input rounded me-1 mt-1 batch-edit-input" checked="true">
                                        <label for="StatusCheckFailed" class="form-check-label bold select-cf-option"><?= _('Status Check Failed') ?> <?= xi6_info_tooltip(_('Reports whether the instance has passed both the instance status check and the system status check in the last minute')) ?></label>
                                    </div>
                                </td>

                                <!---------- Disk Write Bytes ---------->

                                <td class="p-0 ps-2">
                                    <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                        <span class="input-group-text min-width-14em"><?= _('Disk Write Bytes') ?> <?= xi6_info_tooltip(_('Bytes written to all instance store volumes available to the instance'), false, false) ?></span>
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                        <input data-batch-edit-target="DiskWriteBytes_warning" class="form-control form-control-sm min-width-10em batch-edit-input" type="text" value="<?= $serviceargs["DiskWriteBytes_warning"] ?>" />
                                        <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                        <input data-batch-edit-target="DiskWriteBytes_critical" class="form-control form-control-sm min-width-10em batch-edit-input" type="text" value="<?= $serviceargs["DiskWriteBytes_critical"] ?>" />
                                        <div class="input-group-text min-width-8em"><?= _("Bytes") ?></div>
                                    </div>
                                </td>
                            </tr>
                            <tr>

                                <!---------- Status Check Failed (Instance) ---------->

                                <td class="p-0">
                                    <div class="input-group input-group-sm m-2 ms-0 flex-nowrap">
                                        <input data-batch-edit-target="StatusCheckFailed_Instance_checkbox" type="checkbox" class="form-check-input rounded me-1 mt-1 batch-edit-input" checked="true">
                                        <label class="form-check-label bold select-cf-option"><?= _('Status Check Failed (Instance)') ?> <?= xi6_info_tooltip(_('Reports whether the instance has passed the instance status check in the last minute')) ?></label>
                                    </div>
                                </td>

                                <!---------- Status Check Failed (System) ---------->

                                <td class="p-0 ps-2">
                                    <div class="input-group input-group-sm m-2 ms-0 flex-nowrap">
                                        <input data-batch-edit-target="StatusCheckFailed_System_checkbox" type="checkbox" class="form-check-input rounded me-1 mt-1 batch-edit-input" checked="true">
                                        <label class="form-check-label bold select-cf-option"><?= _('Status Check Failed (System)') ?> <?= xi6_info_tooltip(_('Reports whether the instance has passed the system status check in the last minute')) ?></label>
                                    </div>
                                </td>
                            </tr>
                        </table>

                        <div class="d-inline-flex g-2 mt-2">
                            <button type="button" class="btn btn-sm btn-outline-primary me-4" id="apply-batch-edit-btn"><?= _("Apply Batch Edit") ?></button>
                            <button type="button" class="btn btn-sm btn-outline-primary justify-content-start" id="hide-batch-edit"><?= _("Close") ?></button>
                        </div>

                    </div> <!-- accordion-body -->
                </div> <!-- accordion-collapse batch-edit-content -->
            </div> <!-- accordion-item -->
        </div> <!-- accordion batch-edit -->

        <!------------------------------------------->
        <!-------- END BATCH EDIT HTML HERE --------->
        <!------------------------------------------->

        <div id="mainAccordion" class="accordion">
            <div class="accordion-item">
                <h2 class="accordion-header d-flex position-relative" id="toggle-all-header">
                    <!-- Moved outside the button to prevent checkbox from triggering open/close all -->
                    <input type="checkbox" class="form-check-input fa-12 position-absolute" id="toggle-all-instances">
                    <button class="accordion-button collapsed d-flex" type="button" data-bs-toggle="collapse" id="toggleAllAccordionItems" aria-expanded="false">
                        <div class="form-label g-2 flex-even text-center"><?= _('Instance ID') ?></div>
                        <div class="form-label g-2 flex-even text-center"><?= _('IP Address') ?></div>
                        <div class="form-label g-2 flex-even text-center"><?= _('Region') ?></div>
                    </button>
                </h2>
                <div id="dummyItem" class="accordion-collapse collapse">
                </div>
            </div>
<?php
    if (isset($instance_list)) {
        foreach ($instance_list as $instance_id => $instance) {
            // Don't display instances that haven't been selected for monitoring
            if ( $instance['checkbox'] != 'on' ) {
                continue;
            }
?>
                <input type="hidden" name="instancelist[<?= $instance_id ?>][region]" value="<?= $instance["region"] ?>">
                <input type="hidden" name="instancelist[<?= $instance_id ?>][ip_address]" value="<?= $instance["ip_address"] ?>">
                <input type="hidden" name="instancelist[<?= $instance_id ?>][instance_id]" value="<?= $instance_id ?>">
                <input type="hidden" name="instancelist[<?= $instance_id ?>][checkbox]" value="on">

                <div class="accordion-item instance-wrapper" id="metrics-grid-table-<?= $instance_id ?>" data-instance-id="<?= $instance_id ?>" data-ip-address="<?= $instance["ip_address"] ?>" data-region="<?= $instance["region"] ?>">
                    <h2 class="accordion-header d-flex position-relative" id="heading_<?= $instance_id ?>">
                        <input type="checkbox" class="form-check-input fa-12 position-absolute instance-batch-checkbox" id="<?= $instance_id ?>" data-instance-id="<?= $instance_id ?>">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse_<?= $instance_id ?>" aria-expanded="false" aria-controls="collapse_<?= $instance_id ?>">
                            <div class="form-label g-2 flex-even text-center"><?= $instance_id ?></div>
                            <div class="form-label g-2 flex-even text-center"><?= $instance["ip_address"] ?></div>
                            <div class="form-label g-2 flex-even text-center"><?= $instance["region"] ?></div>
                        </button>
                    </h2>
                    <div id="collapse_<?= $instance_id ?>" class="accordion-collapse collapse multi-collapse" aria-labelledby="heading_<?= $instance_id ?>">
                        <div class="accordion-body table-responsive table-responsive-sm">

                            <div class="col-sm-10">
                                <div class="p-0">

                                    <!---------- Hostname ---------->

                                    <div class="input-group input-group-sm g-2 mb-1 ms-3 ps-1 flex-nowrap">
                                        <label class="form-check-label input-group-text min-width-14em" for="instancelist[<?= $instance_id ?>][hostname]"><?= _("Hostname") ?> <?= xi6_info_tooltip(_('The name you want associated with this host.'), false, false) ?></label>
                                        <input name="instancelist[<?= $instance_id ?>][hostname]" value="<?= $instance["ip_address"] ?>" class="form-control form-control-sm min-width-14em" type="text"/>
                                    </div>
                                </div>
                            </div>

                            <table class="table table-sm table-borderless">
                                <tr>
                                    <td class="p-0">

                                        <!---------- Toggle All Checkbox ---------->

                                        <div class="input-group input-group-sm m-2 ms-0 flex-nowrap">
                                            <input type="checkbox" class="form-check-input rounded me-3 mt-1 toggle-checkbox" data-instance-id="<?= $instance_id ?>" id="<?= $instance_id ?>" checked="true">
                                            <label for="<?= $instance_id ?>" class="form-check-label bold select-cf-option"><?= _('Toggle All') ?></label>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="p-0">

                                        <!---------- CPUCreditUsage ---------->

                                        <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                            <input type="checkbox" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" name="instancelist[<?= $instance_id ?>][metrics][CPUCreditUsage][checkbox]" <?= is_checked(checkbox_binary($services["CPUCreditUsage"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _('CPU Credit Usage') ?> <?= xi6_info_tooltip(_('The number of CPU credits spend by the instance for CPU utilization.'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="CPUCreditUsage_warning" id="CPUCreditUsage_warning" class="form-control form-control-sm min-width-8em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][CPUCreditUsage][warning]" value="<?= $serviceargs["CPUCreditUsage_warning"] ?>" />
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="CPUCreditUsage_critical" id="CPUCreditUsage_critical" class="form-control form-control-sm min-width-8em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][CPUCreditUsage][critical]" value="<?= $serviceargs["CPUCreditUsage_critical"] ?>" />
                                            <span class="input-group-text min-width-13em"><?= _("Credits (vCPU-minutes)") ?></span>
                                        </div>
                                    </td>

                                    <td class="p-0 ps-3">

                                        <!---------- Network Bytes In ---------->

                                        <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                            <input type="checkbox" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" name="instancelist[<?= $instance_id ?>][metrics][NetworkIn][checkbox]" <?= is_checked(checkbox_binary($services["NetworkIn"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _('Network Bytes In') ?> <?= xi6_info_tooltip(_('The number of bytes received on all network interfaces by the instance.'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="NetworkBytesIn_warning" id="NetworkBytesIn_warning" class="form-control form-control-sm min-width-10em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][NetworkIn][warning]" value="<?= $serviceargs["NetworkIn_warning"] ?>" />
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="NetworkBytesIn_critical" id="NetworkBytesIn_critical" class="form-control form-control-sm min-width-10em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][NetworkIn][critical]" value="<?= $serviceargs["NetworkIn_critical"] ?>" />
                                            <div class="input-group-text min-width-8em"><?= _("Bytes") ?></div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="p-0">

                                        <!---------- CPU Credit Balance ---------->

                                        <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                            <input type="checkbox" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" name="instancelist[<?= $instance_id ?>][metrics][CPUCreditBalance][checkbox]" <?= is_checked(checkbox_binary($services["CPUCreditBalance"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _('CPU Credit Balance') ?> <?= xi6_info_tooltip(_('The number of earned CPU credits that an instance has accrued since it was launched or started.'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="CPUCreditBalance_warning" id="CPUCreditBalance_warning" class="form-control form-control-sm min-width-8em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][CPUCreditBalance][warning]" value="<?= $serviceargs["CPUCreditBalance_warning"] ?>" />
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="CPUCreditBalance_critical" id="CPUCreditBalance_critical" class="form-control form-control-sm min-width-8em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][CPUCreditBalance][critical]" value="<?= $serviceargs["CPUCreditBalance_critical"] ?>" />
                                            <div class="input-group-text min-width-13em"><?= _("Credits (vCPU-minutes)") ?></div>
                                        </div>
                                    </td>

                                    <td class="p-0 ps-3">

                                        <!---------- Network Bytes Out ---------->

                                        <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                            <input type="checkbox" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" name="instancelist[<?= $instance_id ?>][metrics][NetworkOut][checkbox]" <?= is_checked(checkbox_binary($services["NetworkOut"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _("Network Bytes Out") ?> <?= xi6_info_tooltip(_('The number of bytes sent out on all network interfaces by the instance.'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="NetworkBytesOut_warning" id="NetworkBytesOut_warning" class="form-control form-control-sm min-width-10em batch-edit-target" name="instancelist[<?= $instance_id ?>][metrics][NetworkOut][warning]" value="<?= $serviceargs["NetworkOut_warning"] ?>" />
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="NetworkBytesOut_critical" id="NetworkBytesOut_critical" class="form-control form-control-sm min-width-10em batch-edit-target" name="instancelist[<?= $instance_id ?>][metrics][NetworkOut][critical]" value="<?= $serviceargs["NetworkOut_critical"] ?>" />
                                            <div class="input-group-text min-width-8em"><?= _("Bytes") ?></div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="p-0">

                                        <!---------- CPU Utilization ---------->

                                        <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                            <input type="checkbox" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" name="instancelist[<?= $instance_id ?>][metrics][CPUUtilization][checkbox]" <?= is_checked(checkbox_binary($services["CPUUtilization"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _("CPU Utilization") ?> <?= xi6_info_tooltip(_('The percentage of allocated EC2 compute units that are currently in use on the instance.'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="CPUUtilization_warning" id="CPUUtilization_warning" class="form-control form-control-sm min-width-8em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][CPUUtilization][warning]" value="<?= $serviceargs["CPUUtilization_warning"] ?>" />
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="CPUUtilization_critical" id="CPUUtilization_critical" class="form-control form-control-sm min-width-8em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][CPUUtilization][critical]" value="<?= $serviceargs["CPUUtilization_critical"] ?>" />
                                            <div class="input-group-text min-width-13em">%</div>
                                        </div>
                                    </td>

                                    <td class="p-0 ps-3">

                                        <!---------- Network Packets In ---------->

                                        <div class="input-group input-group-sm g-2 mb-1">
                                            <input type="checkbox" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" name="instancelist[<?= $instance_id ?>][metrics][NetworkPacketsIn][checkbox]" <?= is_checked(checkbox_binary($services["NetworkPacketsIn"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _('Network Packets In') ?> <?= xi6_info_tooltip(_('The number of packets received on all network interfaces by the instance'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="NetworkPacketsIn_warning" id="NetworkPacketsIn_warning" type="text" class="form-control form-control-sm min-width-10em batch-edit-target" name="instancelist[<?= $instance_id ?>][metrics][NetworkPacketsIn][warning]" value="<?= $serviceargs["NetworkPacketsIn_warning"] ?>">
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="NetworkPacketsIn_critical" id="NetworkPacketsIn_critical" type="text" class="form-control form-control-sm min-width-10em batch-edit-target" name="instancelist[<?= $instance_id ?>][metrics][NetworkPacketsIn][critical]" value="<?= $serviceargs["NetworkPacketsIn_critical"] ?>">
                                            <div class="input-group-text min-width-8em"><?= _("Packets") ?></div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="p-0">

                                        <!---------- Disk Read Operations ---------->

                                        <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                            <input type="checkbox" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" name="instancelist[<?= $instance_id ?>][metrics][DiskReadOps][checkbox]" <?= is_checked(checkbox_binary($services["DiskReadOps"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _('Disk Read Operations') ?> <?= xi6_info_tooltip(_('Completed read operations from all instance store volumes available to the instance in a specified period of time'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="DiskReadOperations_warning" id="DiskReadOperations_warning" class="form-control form-control-sm min-width-8em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][DiskReadOps][warning]" value="<?= $serviceargs["DiskReadOps_warning"] ?>" />
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="DiskReadOperations_critical" id="DiskReadOperations_critical" class="form-control form-control-sm min-width-8em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][DiskReadOps][critical]" value="<?= $serviceargs["DiskReadOps_critical"] ?>" />
                                            <div class="input-group-text min-width-13em">IOPS</div>
                                        </div>
                                    </td>

                                    <td class="p-0 ps-3">

                                        <!---------- Network Packets Out ---------->

                                        <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                            <input type="checkbox" id="NetworkPacketsOut" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" name="instancelist[<?= $instance_id ?>][metrics][NetworkPacketsOut][checkbox]" <?= is_checked(checkbox_binary($services["NetworkPacketsOut"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _('Network Packets Out') ?> <?= xi6_info_tooltip(_('The number of packets sent out on all network interfaces by the instance'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="NetworkPacketsOut_warning" id="NetworkPacketsOut_warning" class="form-control form-control-sm min-width-10em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][NetworkPacketsOut][warning]" value="<?= $serviceargs["NetworkPacketsOut_warning"] ?>" />
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="NetworkPacketsOut_critical" id="NetworkPacketsOut_critical" class="form-control form-control-sm min-width-10em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][NetworkPacketsOut][critical]" value="<?= $serviceargs["NetworkPacketsOut_critical"] ?>" />
                                            <div class="input-group-text min-width-8em"><?= _("Packets") ?></div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="p-0">

                                        <!---------- Disk Write Operations ---------->

                                        <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                            <input type="checkbox" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" id="DiskWriteOps" name="instancelist[<?= $instance_id ?>][metrics][DiskWriteOps][checkbox]" <?= is_checked(checkbox_binary($services["DiskWriteOps"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _('Disk Write Operations') ?> <?= xi6_info_tooltip(_('Completed write operations to all instance store volumes available to the instance in a specified period of time'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="DiskWriteOperations_warning" id="DiskWriteOperations_warning" class="form-control form-control-sm min-width-8em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][DiskWriteOps][warning]" value="<?= $serviceargs["DiskWriteOps_warning"] ?>" />
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="DiskWriteOperations_critical" id="DiskWriteOperations_critical" class="form-control form-control-sm min-width-8em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][DiskWriteOps][critical]" value="<?= $serviceargs["DiskWriteOps_critical"] ?>" />
                                            <div class="input-group-text min-width-13em">IOPS</div>
                                        </div>
                                    </td>

                                    <td class="p-0 ps-3">

                                        <!---------- Disk Read Bytes ---------->

                                        <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                            <input type="checkbox" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" id="DiskReadBytes" name="instancelist[<?= $instance_id ?>][metrics][DiskReadBytes][checkbox]" <?= is_checked(checkbox_binary($services["DiskReadBytes"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _('Disk Read Bytes') ?> <?= xi6_info_tooltip(_('Bytes read from all instance store volumes available to the instance'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="DiskReadBytes_warning" id="DiskReadBytes_warning" class="form-control form-control-sm min-width-10em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][DiskReadBytes][warning]" value="<?= $serviceargs["DiskReadBytes_warning"] ?>" />
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="DiskReadBytes_critical" id="DiskReadBytes_critical" class="form-control form-control-sm min-width-10em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][DiskReadBytes][critical]" value="<?= $serviceargs["DiskReadBytes_critical"] ?>" />
                                            <div class="input-group-text min-width-8em"><?= _("Bytes") ?></div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="p-0">

                                        <!---------- Status Check Failed ---------->

                                        <div class="input-group input-group-sm m-2 ms-0 mt-1 flex-nowrap">
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="StatusCheckFailed_checkbox" type="checkbox" class="form-check-input rounded me-2 mt-1 <?= $instance_id ?>-checkbox batch-edit-target" name="instancelist[<?= $instance_id ?>][metrics][StatusCheckFailed][checkbox]" <?= is_checked(checkbox_binary($services["StatusCheckFailed"]), "1") ?>>
                                            <label for="StatusCheckFailed" class="form-check-label bold select-cf-option"><?= _('Status Check Failed') ?> <?= xi6_info_tooltip(_('Reports whether the instance has passed both the instance status check and the system status check in the last minute')) ?></label>
                                            <input type="hidden" name="instancelist[<?= $instance_id ?>][metrics][StatusCheckFailed][warning]" value="<?= $serviceargs["StatusCheckFailed_warning"] ?>" class="form-control form-control-sm">
                                            <input type="hidden" name="instancelist[<?= $instance_id ?>][metrics][StatusCheckFailed][critical]" value="<?= $serviceargs["StatusCheckFailed_critical"] ?>" class="form-control form-control-sm">
                                        </div>
                                    </td>

                                    <td class="p-0 ps-3">

                                        <!---------- Disk Write Bytes ---------->

                                        <div class="input-group input-group-sm g-2 mb-1 flex-nowrap">
                                            <input type="checkbox" id="DiskWriteBytes" class="form-check-input <?= $instance_id ?>-checkbox mt-2 me-2 rounded" name="instancelist[<?= $instance_id ?>][metrics][DiskWriteBytes][checkbox]" <?= is_checked(checkbox_binary($services["DiskWriteBytes"]), "1") ?>>
                                            <span class="input-group-text min-width-14em rounded-start"><?= _('Disk Write Bytes') ?> <?= xi6_info_tooltip(_('Bytes written to all instance store volumes available to the instance'), false, false) ?></span>
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Warning Threshold')) ?> class="material-symbols-outlined md-warning md-18 md-400">warning</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="DiskWriteBytes_warning" id="DiskWriteBytes_warning" class="form-control form-control-sm min-width-10em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][DiskWriteBytes][warning]" value="<?= $serviceargs["DiskWriteBytes_warning"] ?>" />
                                            <span class="input-group-text"><i <?= xi6_title_tooltip(_('Critical Threshold')) ?> class="material-symbols-outlined md-critical md-18 md-400">error</i></span>
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="DiskWriteBytes_critical" id="DiskWriteBytes_critical" class="form-control form-control-sm min-width-10em batch-edit-target" type="text" name="instancelist[<?= $instance_id ?>][metrics][DiskWriteBytes][critical]" value="<?= $serviceargs["DiskWriteBytes_critical"] ?>" />
                                            <div class="input-group-text min-width-8em"><?= _("Bytes") ?></div>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="p-0">

                                        <!---------- Status Check Failed (Instance) ---------->

                                        <div class="input-group input-group-sm m-2 ms-0 mt-1 flex-nowrap">
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="StatusCheckFailed_Instance_checkbox" type="checkbox" class="form-check-input rounded me-2 mt-1 <?= $instance_id ?>-checkbox batch-edit-target" name="instancelist[<?= $instance_id ?>][metrics][StatusCheckFailed_Instance][checkbox]" <?= is_checked(checkbox_binary($services["StatusCheckFailed_Instance"]), "1") ?>>
                                            <label class="form-check-label bold select-cf-option"><?= _('Status Check Failed (Instance)') ?> <?= xi6_info_tooltip(_('Reports whether the instance has passed the instance status check in the last minute')) ?></label>
                                            <input type="hidden" name="instancelist[<?= $instance_id ?>][metrics][StatusCheckFailed_Instance][warning]" value="<?= $serviceargs["StatusCheckFailed_Instance_warning"] ?>" class="form-control form-control-sm">
                                            <input type="hidden" name="instancelist[<?= $instance_id ?>][metrics][StatusCheckFailed_Instance][critical]" value="<?= $serviceargs["StatusCheckFailed_Instance_critical"] ?>" class="form-control form-control-sm">
                                        </div>
                                    </td>

                                    <td class="p-0 ps-3">

                                        <!---------- Status Check Failed (System) ---------->

                                        <div class="input-group input-group-sm m-2 ms-0 mt-1 flex-nowrap">
                                            <input data-instance-id="<?= $instance_id ?>" data-batch-edit-id="StatusCheckFailed_System_checkbox" id="StatusCheckFailed_System_checkbox_<?= $instance_id ?>" type="checkbox" class="form-check-input rounded me-2 mt-1 <?= $instance_id ?>-checkbox batch-edit-target" name="instancelist[<?= $instance_id ?>][metrics][StatusCheckFailed_System][checkbox]" <?= is_checked(checkbox_binary($services["StatusCheckFailed_System"]), "1") ?>>
                                            <label for="StatusCheckFailed_System_checkbox_<?= $instance_id ?>" class="form-check-label bold select-cf-option"><?= _('Status Check Failed (System)') ?> <?= xi6_info_tooltip(_('Reports whether the instance has passed the system status check in the last minute.')) ?></label>
                                            <input type="hidden" name="instancelist[<?= $instance_id ?>][metrics][StatusCheckFailed_System][warning]" value="<?= $serviceargs["StatusCheckFailed_System_warning"] ?>" class="form-control form-control-sm">
                                            <input type="hidden" name="instancelist[<?= $instance_id ?>][metrics][StatusCheckFailed_System][critical]" value="<?= $serviceargs["StatusCheckFailed_System_critical"] ?>" class="form-control form-control-sm">
                                        </div>
                                    </td>
                                </tr>
                            </table>

                        </div> <!-- accordion-body -->
                    </div> <!-- accordion-collapse batch-edit-content -->
                </div> <!-- accordion-item -->
<?php
        }
    }
?>
        </div> <!-- mainAccordion -->
    </div> <!-- container -->

    <script type="text/javascript">
        function searchInstances( searchString ) {
            $(".instance-wrapper").fadeOut(175);
            
            $(".instance-wrapper").each(function() {
                instance_id = $(this).data("instance-id");
                ip_address = $(this).data("ip-address");
                region = $(this).data("region");
                
                instance_id_result = instance_id.indexOf(searchString);
                ip_address_result = ip_address.indexOf(searchString);
                region_result = region.indexOf(searchString);

                if (instance_id_result >= 0 || ip_address_result >= 0 || region_result >= 0) {
                    $(this).fadeIn(175);
                }
            });
        }

        $(document).ready(function() {
            $(".toggle-checkbox").on("click", function() {
                var instance_id = $(this).attr("data-instance-id");
                var checkbox_class = "." + instance_id + "-checkbox";

                if (this.checked) {
                    $(checkbox_class).prop("checked", true);
                } else {
                    $(checkbox_class).prop("checked", false);
                }
            });

            var search;

            // Instance Search
            $("#instance-search").on("keyup", function() {
                clearTimeout(search);
                searchString = $(this).val().toLowerCase();
                search = setTimeout('searchInstances(searchString)', 400);
            });

            // Collapse or Expand all accordion-items
            $("#toggleAllAccordionItems").on("click", function() {
                var collapseElementList;
                var toggleAllAccordionItemsBtn = $('#mainAccordion').find('#toggleAllAccordionItems');
                var dummyItem = $('#mainAccordion').find('#dummyItem');

                if ($(dummyItem).hasClass('show')) {
                    collapseElementList = [].slice.call(document.querySelectorAll('.multi-collapse.show'));
                    $(dummyItem).removeClass('show');
                    $(toggleAllAccordionItemsBtn).addClass('collapsed');
                } else {
                    collapseElementList = [].slice.call(document.querySelectorAll('.multi-collapse.collapse:not(.show)'));
                    $(dummyItem).addClass('show');
                    $(toggleAllAccordionItemsBtn).removeClass('collapsed');
                }

                var collapseList = collapseElementList.map(function (collapseEl) {
                    return new bootstrap.Collapse(collapseEl)
                })
            });

            $("#toggle-all-instances").on("click", function() {
                checked = $(this).prop("checked");

                if (checked) {
                    $(".instance-batch-checkbox").prop("checked", true);
                    $(".instance-batch-checkbox").trigger("change");
                } else {
                    $(".instance-batch-checkbox").prop("checked", false);
                    $(".instance-batch-checkbox").trigger("change");
                }
            });

            $(".instance-batch-checkbox").on("change", function() {
                var checkbox = $(this);
                var color = $(checkbox).parent().parent().css("background-color");

                if ( $(checkbox).prop("checked") ) {
                    $(checkbox).parent().parent().parent().css('background-color: rgb(69, 161, 206); color: black;');
                } else {
                    $(checkbox).parent().parent().css("background-color", "");
                }
            });

            // Show batch edit modal
            $("#show-batch-edit-btn").click(function() {
                $("#batch-edit").show();
            });

            $("#hide-batch-edit").on("click", function() {
                $("#batch-edit").hide();
            });

            $("#apply-batch-edit-btn").on("click", function () {
                var checkedInstances = [];
                var batchEdit = [];

                // Get checked instances
                $(".instance-batch-checkbox").each(function() {
                    if ( $(this).prop("checked") ) {
                        checkedInstances.push( $(this).data("instance-id") );
                    }
                });

                // Get all values
                $(".batch-edit-input").each(function() {
                    // Check for checkboxes
                    if ( $(this).is(":checkbox") ) {
                        val = "checkbox";
                    } else {
                        val = $(this).val();
                    }

                    if (val) {
                        var editEntry = new Object;

                        var target = $(this).data("batch-edit-target");
                        if ( val === "checkbox") {
                            var value = $(this).prop("checked");
                        } else {
                            var value = $(this).val();
                        }

                        editEntry.target = target;
                        editEntry.value = value;

                        batchEdit.push(editEntry);
                    }
                });

                // Apply values to checked instances
                for (index in batchEdit) {
                    targetId = batchEdit[index].target;
                    targetValue = batchEdit[index].value;

                    $(".batch-edit-target[data-batch-edit-id=" + targetId + "]").each(function() {
                        targetInstanceId = $(this).data("instance-id");

                        if ( $.inArray(targetInstanceId, checkedInstances) >= 0 ) {
                            if ( $(this).is(":checkbox") ) {
                                $(this).prop("checked", targetValue);
                            } else {
                                $(this).val(targetValue);
                            }
                        }
                    });
                }
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
