<input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= (!empty($selectedhostconfig)) ? encode_form_val($selectedhostconfig) : "" ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
# New/Copy/Update
#    include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label class="form-label form-item-required"><?= _("Address") ?> <?= xi6_info_tooltip(_("The IP address or fully qualified domain name of the MSSQL server.")) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= (!empty($address)) ? encode_form_val($address) : "" ?>" class="form-control rounded-end monitor copy-to-hostname" placeholder="<?= _("Enter IP Address/Hostname") ?>" required>
                        <div class="invalid-feedback">
                            Please enter ip address or hostname.
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label class="form-label form-item-required"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you want to have associated with this MSSQL Database, i.e., alternate Host/Node name.')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="hostname" id="hostname" value="<?= (!empty($hostname)) ? encode_form_val($hostname) : "" ?>" class="form-control rounded-end monitor initialized-by-ip" placeholder="<?= _("Enter host/node name") ?>" required>
                        <div class="invalid-feedback">
                            Please enter hostname.
                        </div>
                        <div class="invalid-hostname visually-hidden">
                            Host Name already in use.  Create a unique Host Name or switch to Update/View Configuration.
                        </div>
                        <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-6">
                    <div class="row">
                        <div class="col-sm-6">
                            <label for="instance" class="form-label"><?= _("Database Server Instance") ?> <?= xi6_info_tooltip(_("The name of the Database Server Instance (in the case of multiple Database Engines running on a machine).")) ?></label>
                            <div class="input-group position-relative">
                                <input type="text" name="instance" id="instance" value="<?= (!empty($instance)) ? encode_form_val($instance) : "" ?>" class="form-control rounded-end monitor" placeholder="<?= _("Enter Instance Name") ?>">
                                <i id="instance_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-auto" style="display: table;">
                            <label style="display: table-row;">&nbsp;</label>
                            <span style="display: table-row;"> - or - </span>
                        </div>
                        <div class="col">
                            <label for="port" class="form-label"><?= _("Port") ?> <?= xi6_info_tooltip(_("The port to use to connect to MSSQL server.  Default is 1433.  NOTE: Port is ignored, if Instance Name is provided.")) ?></label>
                            <div class="input-group position-relative">
                                <input type="text" name="port" id="port" value="<?= (!empty($port)) ? encode_form_val($port) : "" ?>" class="form-control rounded-end monitor" placeholder=" <?= _("Enter port number") ?>" placeholder="1433">
                                <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="mssql_version" class="form-label form-item-required"><?= _("MSSQL Version") ?> <?= xi6_info_tooltip(_("The software version of the MSSQL Server Software.")) ?></label>
                    <div class="input-group position-relative">
                        <select name="mssql_version" id="mssql_version" class="form-select rounded-end monitor" placeholder="<?= _("Select version") ?> " required>
                            <option value="" disabled selected>Choose a version...</option>
                            <option value="PDW" <?= is_selected($mssql_version, "PDW") ?>><?= _("Parallel Data Warehouse") ?></option>
                            <option value="SQLDW" <?= is_selected($mssql_version, "SQLDW") ?>><?= _("Azure Synapse Analytics (SQL DW)") ?></option>
                            <option value="AZURESQLDB" <?= is_selected($mssql_version, "AZURESQLDB") ?>><?= _("Azure SQL DB") ?></option>
                            <option value="2022" <?= is_selected($mssql_version, "2022") ?>><?= _('2022 (Dallas)') ?></option>
                            <option value="2019" <?= is_selected($mssql_version, "2019") ?>><?= _("2019 (Seattle)") ?></option>
                            <option value="2017" <?= is_selected($mssql_version, "2017") ?>><?= _("2017 (Helsinki)") ?></option>
                            <option value="2016" <?= is_selected($mssql_version, "2016") ?>><?= _("2016 (SQL16)") ?></option>
                            <option value="2014" <?= is_selected($mssql_version, "2014") ?>><?= _("2014 (SQL14)") ?></option>
                            <option value="2012" <?= is_selected($mssql_version, "2012") ?>><?= _("2012 (Denali)") ?></option>
                            <option value="2008-R2" <?= is_selected($mssql_version, "2008-R2") ?>><?= _("2008 R2 (Kilimanjaro)") ?></option>
                            <option value="2008" <?= is_selected($mssql_version, "2008") ?>><?= _("2008 (Katmai)") ?></option>
                            <option value="2005" <?= is_selected($mssql_version, "2005") ?>><?= _("2005 (Yukon)") ?></option>
                            <option value="2000-64" <?= is_selected($mssql_version, "2000-64") ?>><?= _("2000 64-bit (Liberty)") ?></option>
                            <option value="2000" <?= is_selected($mssql_version, "2000") ?>><?= _("2000 (Shiloh)") ?></option>
                            <option value="other" <?= is_selected($mssql_version, "other") ?>><?= _("Other") ?></option>
                        </select>
                        <div class="invalid-feedback">
                            Please select the software version of the SQL Server.
                        </div>
                        <i id="version_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="tds_version" class="form-label"><?= _("TDS Version") ?> <?= xi6_info_tooltip(_("TDS version used when connecting to the MSSQL server. Change based on MSSQL version compatibility requirements as needed.")) ?></label>
                    <div class="input-group position-relative">
                        <select name="tds_version" id="tds_version" class="form-select rounded-end monitor" placeholder="<?= _("Select version") ?> ">
                            <option value="" selected>Auto</option>
                            <option value="4.2" <?= is_selected($tds_version, "4.2") ?>>4.2</option>
                            <option value="5.0" <?= is_selected($tds_version, "5.0") ?>>5.0</option>
                            <option value="7.0" <?= is_selected($tds_version, "7.0") ?>>7.0</option>
                            <option value="7.1" <?= is_selected($tds_version, "7.1") ?>>7.1</option>
                            <option value="7.2" <?= is_selected($tds_version, "7.2") ?>>7.2</option>
                            <option value="7.3" <?= is_selected($tds_version, "7.3") ?>>7.3</option>
                            <option value="7.4" <?= is_selected($tds_version, "7.4") ?>>7.4</option>
                            <option value="8.0" <?= is_selected($tds_version, "8.0") ?>>8.0</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="username" class="form-label form-item-required"><?= _("Username") ?> <?= xi6_info_tooltip(_("The username to connect to the MSSQL server.")) ?></label>
                    <div class="input-group position-relative">
                    <input type="text" name="username" id="username" value="<?= (!empty($username)) ? encode_form_val($username) : "" ?>" class="form-control rounded-end monitor" placeholder="<?= _("Enter Username") ?>" required>
                    <div class="invalid-feedback">
                        Please enter the username of your SQL Server account.
                    </div>
                        <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>
            <div id="changePasswordOption" class="row mb-3 mt-4 visually-hidden">
                <div class="col-sm">
                    <input type="checkbox" id="changePassword" class="form-check-input" name="changePassword">
                    <label for="changePassword" class="form-check-label bold"><?= _('Change Password') ?> <?= xi6_info_tooltip(_("Use to change the password, otherwise, the existing password will be preserved.")) ?></label>
                </div>
            </div>
            <div id="setPassword" class="row mb-2">
                <div class="col-sm-6">
                    <label for="password" class="form-label form-item-required"><?= _("Password") ?> <?= xi6_info_tooltip(_("The password to connect to the MSSQL server.")) ?></label>
                    <div class="input-group">
                        <input type="password" name="password" id="password" value="<?= (!empty($password)) ?  encode_form_val($password) : "" ?>" class="usermacro-detection form-control" autocomplete="off" placeholder="<?= _("Enter Password") ?>" required>
                        <button type="button" class="btn btn-outline-secondary rounded-end btn-show-secret tt-bind" id="password-secret" title="<?= _("Show") ?>">
                            <span class="material-symbols-outlined md-22 md-pointer">Visibility</span>
                            <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </button>
                        <div class="invalid-feedback">
                            Please enter the password of your SQL Server account.
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- config -->
    </div> <!-- container -->

    <script type='text/javascript' src='<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>'></script>
