<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('URL Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="url" class="form-label"><?= _('URL') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="url" id="url" value="<?= encode_form_val($url) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter URL") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the URL") ?>
                    </div>
                    <i id="url_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this website.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="servicename" class="form-label"><?= _('Service Name Prefix') ?> <?= xi6_info_tooltip(_('The service name prefix that you would like to have used for specific URL services you select below. This prefix helps to identify this URL when monitoring different URLs on the same web server.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="servicename" id="servicename" value="<?= encode_form_val($servicename) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Service Name Prefix") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Service Name") ?>
                    </div>
                    <i id="servicename_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip" class="form-label"><?= _('IP Address') ?> <?= xi6_info_tooltip(_('The IP address associated with the website fully qualified domain name (FQDN).')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="ip" id="ip" value="<?= encode_form_val($ip) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('URL Options') ?></h2>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="ssl" class="form-check-input" name="ssl"  <?= is_checked($ssl, "on") ?> >
                        <label for="ssl" class="form-check-label bold"><?= _('Use SSL') ?> <?= xi6_info_tooltip(_('Monitor the URL using SSL/HTTPS.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="port" class="form-label"><?= _('Port') ?> <?= xi6_info_tooltip(_('The port to use when contacting the website.')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="port" id="port" value="<?= encode_form_val($port, ENT_COMPAT, 'UTF-8') ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Port:") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Port") ?>
                    </div>
                    <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="onredirect" class="form-label form-item-required"><?= _('On Redirect') ?> <?= xi6_info_tooltip(_('How to handle redirected pages. Sticky is like follow but will stick to the specified IP address. Stickyport ensures the port stays the same.')) ?></label>
                <div class="input-group position-relative">
                    <select name="onredirect" id="onredirect" class="form-control form-control-sm form-select form-select-sm monitor rounded" placeholder="<?= _("Select On Redirect:") ?>" >
                        <option <?= is_selected($onredirect, 'ok') ?>>ok</option>
                        <option <?= is_selected($onredirect, 'warning') ?>>warning</option>
                        <option <?= is_selected($onredirect, 'critical') ?>>critical</option>
                        <option <?= is_selected($onredirect, 'follow') ?>>follow</option>
                        <option <?= is_selected($onredirect, 'sticky') ?>>sticky</option>
                        <option <?= is_selected($onredirect, 'stickyport') ?>>stickyport</option>
                    </select>
                    <div class="invalid-feedback">
                        <?= _("Please select on Redirect") ?>
                    </div>
                    <i id="onredirect_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8">
                <label for="username" class="form-label bold m-0 ms-1"><?= _('Credentials') ?> <span class="fw-normal"> (<?= _('optional') ?>)</span> <?= xi6_info_tooltip(_('The username and password to authenticate to the URL (optional). If specified, basic authentication is used.')) ?></label>
                <fieldset class="row">
                    <div class="col-sm-5 ps-2 pe-0">
                        <div class="input-group input-group-sm">
                            <input type="text" name="username" id="username" value="<?= encode_form_val($username) ?>" class="form-control form-control-sm monitor rounded-end" placeholder="<?= _('Username') ?>">

                            <i id="username_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-5 ps-2 pe-0">
                        <div class="input-group input-group-sm">
                            <input type="password" id="password" name="password" value="<?= encode_form_val($password) ?>" class="form-control form-control-sm monitor rounded-end" placeholder="<?= _('Password') ?>">

                            <i id="password_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <h2 class="mt-4"><?= _('Defacement Monitoring Services') ?></h2>
        <p><?= _('Specify which defacement services you would like to monitor your website with.') ?></p>

        <div class="row">
            <div class="form-check col-sm-10 mt-0 pt-1">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm mt-0 pt-1">
                        <input type="checkbox" class="form-check-input" id="httpcontent" name="services[httpcontent]" <?= is_checked(grab_array_var($services, "httpcontent"), "on") ?>>
                        <label class="normal" for="httpcontent">
                            <b><?= _('Defacement Content Locator') ?></b><br>
                            <?= _('Monitors the website to locate strings, as defined in the text box below.') ?>
                        </label>
                    </div>
                    <div class="row mt-2">
                        <div class="col-sm ps-4">
                            <label for="httpcontentstr" class="form-label">
                                <?= _('Insert a list of strings, each separated with a new line (if using a single quote you must escape it).') ?>
                            </label>
                            <div class="input-group input-group-sm">
                                <textarea rows="15" name="serviceargs[httpcontentstr]" id="httpcontentstr" class="form-control form-control-sm"><?= encode_form_val($serviceargs["httpcontentstr"]) ?></textarea>
                                <i id="httcontentstr_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm ps-4 pt-2">
                            <form action="FileReader">
                                <span class="input-group-btn">
                                    <span class="btn btn-sm btn-primary btn-file"> <?= _('Load File') ?>&hellip; <input type="file" onchange="loadfile(this)"></span> <?= xi6_info_tooltip('Load a file, that contains a list of strings separated by new lines, to monitor.') ?>
                                </span>
                            </form>
                        </div>
                    </div>
                    <div id="defaults" class="row ms-2 mt-4 mb-2">
                        <div class="col-sm-auto">
                            <button type="button" class="btn btn-outline-secondary" id="load-defaults"><?= _('Load Defaults') ?></button> <?= xi6_info_tooltip('Check one or more of the checkboxes and then click Load Defaults button, to load the text box.') ?>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

        <div class="row">
            <div class="form-check col-sm-10 mt-0 pt-1 mb-2">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm mt-0 pt-1">
                        <input type="checkbox" class="form-check-input" id="httpregex" name="services[httpregex]" <?= is_checked(grab_array_var($services, "httpregex")) ?>>
                        <label for="httpregex">
                            <b><?= _('Web Page Regular Expression Match') ?></b><br>
                            <?= _('Monitors the website to ensure the specified regular expression is found in the content of the web page. A content mismatch may indicate that your website<br> has experienced a security breach or is not functioning correctly. To include multiple expressions use the "|" after each expression with no spaces') ?>
                        </label>
                        <div class="row">
                            <div class="col-sm-9 mt-2 mb-2 pt-0 ps-3">
                                <label for="httpregexstr" class="form-label"><?= _('Regular Expression') ?></label>
                                <div class="input-group input-group-sm">
                                    <input type="text" name="serviceargs[httpregexstr]" id="httpregexstr" value="<?= encode_form_val($serviceargs["httpregexstr"]) ?>" class="form-control form-control-sm monitor rounded-end">
                                    <i id="httpregexstr_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                                </div>
                                <div class="input-group input-group-sm ms-4 mt-2">
                                    <input type="checkbox" class="form-check-input me-2" id="regexinvert" name="services[regexinvert]" <?= is_checked(grab_array_var($services, "regexinvert")) ?>>
                                    <label for="regexinvert" class="form-check-label"><?= _('Invert Regex Search') ?></label>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript">
        // Get JSON data and populate default definition checkboxes
        var url = base_url + "includes/configwizards/website_defacement/defaults.php";
        var wd_defaults;

        // Get EOL for splitting file
        var platform = window.navigator?.userAgentData?.platform || window.navigator.platform;
        var windowsPlatforms = ['Win32', 'Win64', 'Windows', 'WinCE'];
        var eol = '\n';
        if (windowsPlatforms.indexOf(platform) !== -1) {
            eol = '\r\n';
        }

        $.getJSON(url, function(data) {
            wd_defaults = data;

            $.each(wd_defaults, function(k, v) {
                var def_checkbox = $("<div class=\"col-sm-auto form-check d-flex align-items-center\"><input type='checkbox' class='wd_d form-check-input mt-0 me-1' name='services[cinput]' id='"+k+"' value='"+k+"' /><label for=\""+k+"\" class=\"form-check-label\">"+k+"</label></div>");
                $("#defaults").prepend(def_checkbox);
            });
        });

        //script to insert file contents into textarea
        function loadfile(input) {
            var reader = new FileReader();

            reader.onload = function(e) {
                var existing = $("#httpcontentstr").val();
                $("#httpcontentstr").val(existing + eol + e.target.result);
            }

            reader.readAsText(input.files[0]);
        }

        $(document).ready(function() {
            $("#load-defaults").click(function() {

                var defs = "";
                user_defs = $("#httpcontentstr").val();

                writeable = [];

                $.each(user_defs.split(eol), function(i, user_def) {
                    if (user_def)
                        writeable.push($.trim(user_def));
                });

                $('#defaults').find('.wd_d').each(function(d, i) {
                    if ($(this).prop('checked')) {
                        defs = wd_defaults[$(this).val()];

                        $.each(defs.split(eol), function(i, default_def) {
                            var not_in_array = writeable.indexOf($.trim(default_def)) == -1;
                            if (default_def && not_in_array) {
                                //console.log("Adding " + default_def);
                                writeable.push(default_def);
                            }
                        });
                    }
                });

                var new_defs = writeable.join(eol);
                $("#httpcontentstr").val(new_defs);
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
