<?php 
//
// Copyright (c) 2018-2025 Nagios Enterprises, LLC. All rights reserved.
//
// USAGE:
// - Mock data
// http://localhost/nagiosxi/includes/configwizards/amazon_ec2/ec2.ajax.php?mode=getinstances&mockdata=1
//
// - Live data
// http://localhost/nagiosxi/includes/configwizards/amazon_ec2/ec2.ajax.php?mode=getinstances&accesskeyid=<ACCESSKEYID>&accesskey=<ACCESSKEY>
//

include_once(dirname(__FILE__).'/../configwizardhelper.inc.php');

// Initialization stuff
pre_init();
init_session();

// Grab GET or POST variables and do prereq and auth checks
grab_request_vars();
check_prereqs();
check_authentication();

route_request();


function route_request()
{
    global $request;

    $mode = grab_request_var("mode", "");

    switch ($mode) {

        case'getinstances':
            get_ec2_instances();
            break;

        case'getregions':
            get_regions();

        default:
            echo "The EC2 Utils file was called but no mode was passed.";
            exit;

    }
}

function get_ec2_instances()
{
    global $request;
    global $mockJsonData;

    $accesskeyid = grab_request_var("accesskeyid", "");
    $accesskey = grab_request_var("accesskey", "");
    $staticcreds = grab_request_var("staticcreds", "");
    $credsfilepath = grab_request_var("credsfilepath", "");
    $mockdata = grab_request_var("mockdata", "");

    $accesskeyid = base64_decode($accesskeyid);
    $accesskey = base64_decode($accesskey);

    # Print out mock data
    # NOTE: The field data.success is no longer returned from AWS.
    #       The field data.error is provided by check_ec2.py, in the case of an error (Probably needs work).
    if (!empty($mockdata)) {
        header('Content-Type: application/json; charset=utf-8');

        # Nowdoc, as opposed to Heredoc.
        $mockJsonData = <<<'MOCKJSONDATA'
{ "us-east-1": [{ "instance_id": "i-0c5637220f36e1760", "ip_address": "172.31.36.228" },
                { "instance_id": "i-0f91aecc1e5391031", "ip_address": "172.31.88.117" }],
  "us-east-2": [{ "instance_id": "i-0c5637222f36e2762", "ip_address": "172.31.36.228" }],
  "us-west-1": [{ "instance_id": "i-0c5637223f36e3763", "ip_address": "172.31.36.228" },
                { "instance_id": "i-0f91aecc4e5393034", "ip_address": "172.31.88.117" },
                { "instance_id": "i-0f91aecc5e5390345", "ip_address": "172.31.88.118" }]
}
MOCKJSONDATA;

        echo($mockJsonData);

    } else {

        if ($staticcreds == "on") {
            $cmd = "/usr/local/nagios/libexec/check_ec2.py --getinstances --credfile '".$credsfilepath."'";
        } else {
            $cmd = "/usr/local/nagios/libexec/check_ec2.py --getinstances --accesskeyid='".$accesskeyid."' --secretaccesskey='".$accesskey."'";
        }

        $cmd = escapeshellcmd($cmd);

        $instancelist = shell_exec($cmd);

        if (json_last_error() === JSON_ERROR_NONE) {
            $instancelistArray['success'] = true;
            $instancelistResponse = json_encode($instancelistArray);

        } else {
            // Encode the error message.
            $instancelistResponse = json_encode(["success" => false, "error" => $instancelist]);
        }

        $_SESSION['instancelist'] = json_decode($instancelist);

            error_log("ec2.ajax.php: cmd [$cmd]");
            error_log("ec2.ajax.php: instancelist\n$instancelist");

        header('Content-Type: application/json; charset=utf-8');

        echo "$instancelist";
    }
}