    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <div class="container m-0 g-0">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">

            <div class="col-sm-6 border-block mb-4">
                <h2 class="mb-2"><?= _('Bulk Host Cloning and Import') ?></h2>
                <p><?= _('This wizard allows you to clone existing hosts quicky and easily. It supports import of new hosts in bulk') ?><br><?= _('New host information is specified in CSV format and each newly imported host is given the same services as an existing host that is being monitored. This is useful if you setup one host as a template and want to setup several other hosts using the same template') ?>.</p>
            </div>

            <h2 class="mb-2"><?= _('Template Host Information') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="host" class="form-label form-item-required"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('Select an existing host that should be cloned and used as the template for new hosts')) ?></label>
                    <div class="input-group position-relative">
                        <select name="host" id="host" class="form-select form-select-sm form-control-sm monitor rounded" placeholder="<?= _("Select Host Name") ?> " required>
                            <option value="" disabled selected>Choose an existing host...</option>
<?php
        $args = array("is_active" => 1);
        $xmlhosts = get_xml_host_objects($args);
        $hosts = array();

        foreach ($xmlhosts->host as $h) {
            $hosts[] = $h;
        }

        $hosts = array_reverse($hosts);

        foreach ($hosts as $h) {
            $hname = strval($h->host_name);
            $hdesc = $hname;
            $halias = strval($h->alias);

            if ($halias != $hname && $halias != "") {
                $hdesc .= " (".$halias.")";
            }
?>
                            <option value="<?= $hname ?>" <?= is_selected($host, $hname) ?>><?= $hdesc ?></option>
<?php
        }
?>
                        </select>
                        <div class="invalid-feedback">
                            Please select Host Name
                        </div>
                        <i id="host_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
