    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="host" value="<?= encode_form_val($host) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';

    // Show host icon
    $img = get_object_icon_image($host);
    $imghtml = get_object_icon_html($img, "");
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Host Template') ?></h2>
        <div class="row">
            <div class="col-sm-auto pe-1">
                <?= $imghtml ?>
            </div>
            <div class="col-sm-6 ps-1 d-flex align-items-center">
                <a href="<?= get_host_status_detail_link($host) ?>" target="_blank"><b><?= encode_form_val($host) ?></b></a>
            </div>
        </div>

        <h2 class="mt-4 mb-2"><?= _('Select Service Templates') ?></h2>
        <p><?= _('Specify the services from the template host that should cloned') ?>.</p>

        <div class="mb-2">
            <input id="selectAll" class="form-check-input" type="checkbox">&nbsp<label class="form-check-label" id="selectAllLabel" for="selectAll"><?= _('Check All') ?></label>
        </div>
<?php
    $args = array(
        "host_name" => $host,
        "is_active" => 1,
        'orderby' => 'service_description:a'
    );

    $tservices = get_xml_service_objects($args);

    foreach ($tservices->service as $ts) {
        $sname = strval($ts->service_description);

        if (service_exists($host, $sname)) {
            // Checks if the service can be cloned or not...if it can be then display a checkbox or display disabled checkbox if it can't be
            // Base64_encode the service name to prevent square brackets from terminating the name attribute improperly
            if (service_is_cloneable($host, $sname)) {
?>
        <div class="row services">
            <div class="col-sm">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input" name="services[<?= encode_form_val(base64_encode($sname)) ?>]" id="services[<?= encode_form_val(base64_encode($sname)) ?>]" <?= is_checked(grab_array_var($services, $sname)) ?>>
                        <label for="services[<?= encode_form_val(base64_encode($sname)) ?>]" class="form-check-label bold"><?= encode_form_val($sname) ?></label>
                        (<a href="<?= get_service_status_detail_link($host, $sname) ?>" target="_blank"><?= _('Details') ?></a>)
                    </div>
                </fieldset>
            </div>
        </div>
<?php
            } else {
?>
        <div class="row">
            <div class="col-sm">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-4 mt-0 pt-1">
                        <input type="checkbox" class="form-check-input" disabled>
                        <label for="services[<?= encode_form_val(base64_encode($sname)) ?>]" class="form-check-label bold"><?= encode_form_val($sname) ?></label>
                        (<a href="<?= get_service_status_detail_link($host, $sname) ?>" target="_blank"><?= _('Details') ?></a>)
                    </div>
                    <div class="col-sm-6 mt-0 pt-1">
                        <a href="<?= get_service_status_detail_link($host, $sname) ?>" target="_blank"><b><?= encode_form_val($sname) ?></b></a> (<?= _("Inherited - Can not be cloned using the wizard") ?>)
                    </div>
                </fieldset>
            </div>
        </div>
<?php
            }
        }
    }
?>
        <h2 class="mt-4"><?= _('Import / Cloning Data') ?></h2>
        <div><?= _('Setup the csv format, by choosing which fields to use, "field 1" is required.') ?></div>
        <p><?= _('Enter addresses of new hosts that should be created by cloning the template host and services specified above') ?>.</p>

        <div class="row mb-3">
            <div class="col-sm">
                <label for="field1" class="form-label form-item-required"><?= _('Field') ?> 1 <?= xi6_info_tooltip(_('Specify the type of data present in the fields of data, below')) ?></label>
                <div class="input-group position-relative">
                    <select name="field1" id="field1" class="form-select form-select-sm form-control-sm monitor rounded" placeholder="<?= _("Specify the data for the first csv field") ?>" >
                        <option value="address" <?= is_selected($field1, "address") ?>><?= _('Address') ?></option>
                        <option value="hostname" <?= is_selected($field1, "hostname") ?>><?= _('Name') ?></option>
                        <option value="hostalias" <?= is_selected($field1, "hostalias") ?>><?= _('Description') ?></option>
                        <option value="display_name" <?= is_selected($field1, "display_name") ?>><?= _('Display Name') ?></option>
                        <option value="hostgroup" <?= is_selected($field1, "hostgroup") ?>><?= _('Hostgroup') ?></option>
                        <option value="parenthost" <?= is_selected($field1, "parenthost") ?>><?= _('Parent Host') ?></option>
                    </select>
                    <i id="field1_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
            <div class="col-sm">
                <label for="field2" class="form-label"><?= _('Field') ?> 2</label>
                <div class="input-group position-relative">
                    <select name="field2" id="field2" class="form-select form-select-sm form-control-sm monitor rounded" placeholder="<?= _("Specify the data for the second csv field") ?>" >
                        <option value="ignore" ><?= _('IGNORE') ?></option>
                        <option value="address" <?= is_selected($field2, "address") ?>><?= _('Address') ?></option>
                        <option value="hostname" <?= is_selected($field2, "hostname") ?>><?= _('Name') ?></option>
                        <option value="hostalias" <?= is_selected($field2, "hostalias") ?>><?= _('Description') ?></option>
                        <option value="display_name" <?= is_selected($field2, "display_name") ?>><?= _('Display Name') ?></option>
                        <option value="hostgroup" <?= is_selected($field2, "hostgroup") ?>><?= _('Hostgroup') ?></option>
                        <option value="parenthost" <?= is_selected($field2, "parenthost") ?>><?= _('Parent Host') ?></option>
                    </select>
                    <i id="field2_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
            <div class="col-sm">
                <label for="field3" class="form-label"><?= _('Field') ?> 3</label>
                <div class="input-group position-relative">
                    <select name="field3" id="field3" class="form-select form-select-sm form-control-sm monitor rounded" placeholder="<?= _("Specify the data for the third csv field") ?>" >
                        <option value="ignore" ><?= _('IGNORE') ?></option>
                        <option value="address" <?= is_selected($field3, "address") ?>><?= _('Address') ?></option>
                        <option value="hostname" <?= is_selected($field3, "hostname") ?>><?= _('Name') ?></option>
                        <option value="hostalias" <?= is_selected($field3, "hostalias") ?>><?= _('Description') ?></option>
                        <option value="display_name" <?= is_selected($field3, "display_name") ?>><?= _('Display Name') ?></option>
                        <option value="hostgroup" <?= is_selected($field3, "hostgroup") ?>><?= _('Hostgroup') ?></option>
                        <option value="parenthost" <?= is_selected($field3, "parenthost") ?>><?= _('Parent Host') ?></option>
                    </select>
                    <i id="field3_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
            <div class="col-sm">
                <label for="field4" class="form-label"><?= _('Field') ?> 4</label>
                <div class="input-group position-relative">
                    <select name="field4" id="field4" class="form-select form-select-sm form-control-sm monitor rounded" placeholder="<?= _("Specify the data for the fourth csv field") ?>" >
                        <option value="ignore" ><?= _('IGNORE') ?></option>
                        <option value="address" <?= is_selected($field4, "address") ?>><?= _('Address') ?></option>
                        <option value="hostname" <?= is_selected($field4, "hostname") ?>><?= _('Name') ?></option>
                        <option value="hostalias" <?= is_selected($field4, "hostalias") ?>><?= _('Description') ?></option>
                        <option value="display_name" <?= is_selected($field4, "display_name") ?>><?= _('Display Name') ?></option>
                        <option value="hostgroup" <?= is_selected($field4, "hostgroup") ?>><?= _('Hostgroup') ?></option>
                        <option value="parenthost" <?= is_selected($field4, "parenthost") ?>><?= _('Parent Host') ?></option>
                    </select>
                    <i id="field4_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
            <div class="col-sm">
                <label for="field5" class="form-label"><?= _('Field') ?> 5</label>
                <div class="input-group position-relative">
                    <select name="field5" id="field5" class="form-select form-select-sm form-control-sm monitor rounded" placeholder="<?= _("Specify the data for the fifth csv field") ?>" >
                        <option value="ignore" ><?= _('IGNORE') ?></option>
                        <option value="address" <?= is_selected($field5, "address") ?>><?= _('Address') ?></option>
                        <option value="hostname" <?= is_selected($field5, "hostname") ?>><?= _('Name') ?></option>
                        <option value="hostalias" <?= is_selected($field5, "hostalias") ?>><?= _('Description') ?></option>
                        <option value="display_name" <?= is_selected($field5, "display_name") ?>><?= _('Display Name') ?></option>
                        <option value="hostgroup" <?= is_selected($field5, "hostgroup") ?>><?= _('Hostgroup') ?></option>
                        <option value="parenthost" <?= is_selected($field5, "parenthost") ?>><?= _('Parent Host') ?></option>
                    </select>
                    <i id="field5_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
            <div class="col-sm">
                <label for="field6" class="form-label"><?= _('Field') ?> 6</label>
                <div class="input-group position-relative">
                    <select name="field6" id="field6" class="form-select form-select-sm form-control-sm monitor rounded" placeholder="<?= _("Specify the data for the sixth csv field") ?>" >
                        <option value="ignore" ><?= _('IGNORE') ?></option>
                        <option value="address" <?= is_selected($field6, "address") ?>><?= _('Address') ?></option>
                        <option value="hostname" <?= is_selected($field6, "hostname") ?>><?= _('Name') ?></option>
                        <option value="hostalias" <?= is_selected($field6, "hostalias") ?>><?= _('Description') ?></option>
                        <option value="display_name" <?= is_selected($field6, "display_name") ?>><?= _('Display Name') ?></option>
                        <option value="hostgroup" <?= is_selected($field6, "hostgroup") ?>><?= _('Hostgroup') ?></option>
                        <option value="parenthost" <?= is_selected($field6, "parenthost") ?>><?= _('Parent Host') ?></option>
                    </select>
                    <i id="field6_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>
<?php
    $example1 =
"192.168.1.23
192.168.1.34
10.1.1.134";

    # TODO: When second field is chosen, display example2.
    $example2 =
"192.168.1.23,Server
192.168.1.34,WebSphere
10.1.1.134,DBServer";
?>
        <div class="row mb-4">
            <div class="col-sm">
                <label for="csvdata" class="form-label"><?= _('Data') ?><?= xi6_info_tooltip(_('The addresses of new hosts that should be created by cloning the template host and services specified above. Multiple fields should be separated by a comma. One entry per line')) ?></label>
                <textarea name="csvdata" id="csvdata" style="font-family: Consolas, Courier New, monospace;" class="form-control form-control-sm" placeholder="<?= $example1 ?>" rows="10"><?= $csvdata ?></textarea>
            </div>
        </div>
        <div class="row">
            <div class="col-sm">
                <label for="overwrite" class="form-label"><?= _("Optional") ?></label>
                <div class="col-sm mt-0 pt-1">
                    <input type="checkbox" class="form-check-input" value="1" name="overwrite" id="overwrite" <?= is_checked($overwrite, 1) ?>>
                    <label class="form-check-label">
                        <?= _("Replace Parent Host and/or Hostgroup, with the selected") ?><?= xi6_info_tooltip(_("Replace parent Host and/or Hostgroup, with the selected, above, instead of adding the given Parent and/or Hostgroup to the new host.")) ?>
                    </label>
                </div>
            </div>
        </div>

    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            var allChecked = false;

            $("#selectAll").click(function() {
                if (allChecked == false) {
                    $('#selectAllLabel').html(_('Uncheck All'));
                    $(".services input:checkbox").each(function() {
                        this.checked = "checked";
                    });
                    allChecked = true;

                } else {
                    $('#selectAllLabel').html(_('Check All'));
                    $(".services input:checkbox").each(function() {
                        this.checked = "";
                    });
                    allChecked = false;
                }
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
