    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="osdistro" value="<?= encode_form_val($osdistro) ?>">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">

        <h2 class="mb-2"><?= _('Server Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('IP Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter IP Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this server')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <!--                         -->
        <!-- The metrics to monitor. -->
        <!--                         -->
        <h2 class="mt-4"><?= _('Server Metrics') ?></h2>
        <p><?= _('Specify which services you would like to monitor for the server') ?></p>

        <div class="row">
            <div class="col-sm-8">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-3 mt-0 pt-1">
                        <input type="checkbox" id="p" class="form-check-input" name="services[ping]"  <?= is_checked(checkbox_binary($services['ping']), "1") ?> >
                        <label for="p" class="form-check-label bold"><?= _('Ping') ?> <?= xi6_info_tooltip(_("Monitors the server with an ICMP ping. Useful for watching network latency and general uptime")) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>

        <h2 class="mt-4"><?= _('SSH Commands') ?></h2>
        <p class="mb-0"><?= _('Specify any remote commands that should be executed/monitored on the server using SSH. Note that these scripts must exist on the remote system at the path specified below') ?> </p>

        <div class="position-relative adddeleterow">
             <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1">
                        <div class="d-flex align-items-end form-check col-sm-3">
                            <div class="input-group input-group-sm">
                                <label class="form-check-label bold"><?= _('Remote Command') ?> <?= xi6_info_tooltip(_('Provide the path to the remote command you want to execute.')) ?></label>
                            </div>
                        </div>
                        <div class="d-flex align-items-end col-sm-3">
                            <label class="form-check-label bold"><?= _('Display Name') ?> <?= xi6_info_tooltip(_('Provide a name for this monitoring service.')) ?></label>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    for ($x = 0; $x < count($serviceargs["commands"]); $x++) {
        $commandstring = encode_form_val($serviceargs['commands'][$x]['command']);
        $commandname = encode_form_val($serviceargs['commands'][$x]['name']);
        $is_checked = isset($services['commands'][$x]) ? is_checked($services['commands'][$x]) : '';
?>
            <div class="row">
                <div class="col-sm-8">
                    <fieldset class="row g-2 mb-1 wz-fieldset">
                        <div class="form-check col-sm-3 mt-0">
                            <div class="input-group input-group-sm">
                                <input type="checkbox" class="form-check-input mt-2 me-2" name="services[commands][<?= $x ?>]" <?= isset($services['commands'][$x]) ? is_checked($services['commands'][$x]) : '' ?>>
                                <input type="text" name="serviceargs[commands][<?= $x ?>][command]" id="serviceargs[commands][<?= $x ?>][command]" value="<?= $commandstring ?>" class="form-control form-control-sm rounded monitor">
                                <i id="serviceargs_commands_<?= $x ?>_command_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                            </div>
                        </div>
                        <div class="col-sm-3 mt-0">
                            <input type="text" name="serviceargs[commands][<?= $x ?>][name]" id="serviceargs[commands][<?= $x ?>][name]" value="<?= $commandname ?>" class="form-control form-control-sm rounded monitor">
                            <i id="serviceargs_commands_<?= $x ?>_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    }
?>
        </div>  <!-- adddeleterow -->

        <p class="mt-4">
            <a href="https://assets.nagios.com/downloads/nagiosxi/docs/Monitoring_Hosts_Using_SSH.pdf" target="_blank"><?= _("Instructions for how to monitor hosts using ssh") ?></a>
        </p>

    </div> <!-- container -->

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
