<script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function() {
        var checkAll2 = document.getElementById('checkAll2');
        checkAll2.addEventListener('click', function(event) {
            var checkboxes = document.querySelectorAll('#vsphere_settings-2 input[type="checkbox"]');
            checkboxes.forEach(function(checkbox) {
                checkbox.checked = checkAll2.checked;
            });
        });
    });

    function toggleCheckboxes(status) {
        var checkboxes = document.getElementsByClassName("service_checkbox");
        for (var i = 0; i < checkboxes.length; i++) {
            checkboxes[i].checked = status;
        }
    }
</script>

<div id="vsphere_settings" style="margin-top: 20px;">
    <ul class="nav nav-tabs" id="vsphere_settings_tabs" role="tablist">
        <li class="nav-item" role="presentation"></li>
            <button class="nav-link active" id="vsphere_settings-1-tab" data-bs-toggle="tab" data-bs-target="#vsphere_settings-1" type="button" role="tab" aria-controls="vsphere_settings-1" aria-selected="true"><?php echo _('Monitored Metrics'); ?></button>
        </li>
        <li class="nav-item" role="presentation"></li>
            <button class="nav-link" id="vsphere_settings-2-tab" data-bs-toggle="tab" data-bs-target="#vsphere_settings-2" type="button" role="tab" aria-controls="vsphere_settings-2" aria-selected="false"><?php echo _('Datastores'); ?></button>
        </li>
    </ul>
    <div class="tab-content" id="vsphere_settings_content">
        <div class="tab-pane fade show active" id="vsphere_settings-1" role="tabpanel" aria-labelledby="vsphere_settings-1-tab">
            <h5 class="ul" style="padding-bottom:0;"><?php echo _('VMware Host Metrics'); ?></h5>
            <p><?php echo _('Select the metrics you\'d like to monitor on each of the hosts you select. The fields below take multiple values. See the tool tips for examples. For more information view our '); ?><a href="https://assets.nagios.com/downloads/nagiosxi/docs/Monitoring-VSphere.pdf" target="_blank"><?php echo _('documentation'); ?></a>.</p>
            <style>
                #vsphere_metrics table tbody tr td {
                    padding: 3px 12px;
                }
                #vsphere_metrics table tbody tr:first-child td {
                    padding: 6px 12px 3px 12px;
                }
            </style>
            <div id="vsphere_metrics">
                <table class="table table-condensed table-no-border table-auto-width" style="margin-bottom:5px;">
                    <thead>
                        <tr>
                            <th style="vertical-align:center; padding-left:12px; padding-bottom:4px; padding-right:0px;">
                                <input type="checkbox" 
                                    class="service_checkbox" 
                                    id="checkAll1" 
                                    title="<?php echo _('Check All'); ?>" 
                                    onclick="toggleCheckboxes(this.checked)" 
                                    checked="yes">
                                </input>
                            </th>
                            <th style="color: var(--foreground); padding-bottom: 10px;"><?php echo _('Metric'); ?></th>
                            <th style="margin-left:30px; color: var(--foreground); padding-bottom: 10px;"><?php echo _('Warning Threshold'); ?></th>
                            <th style="margin-left:30px; color: var(--foreground); padding-bottom: 10px;"><?php echo _('Critical Threshold'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
<?php                        
    foreach (json_decode(VSPHERE_SERVICENAMES_HOST, true) as $s) {
        if (in_array($s[0] , array('RUNTIME', 'SERVICE'))) {
            vsphere_configwizard_pushcheckboxandargs($s, $services, $serviceargs, $mode, $thresholdsdisabled=true);
        } else {
            vsphere_configwizard_pushcheckboxandargs($s, $services, $serviceargs, $mode);
        }
    }
?>
                    </tbody>
                </table>
            </div>
        </div>
        <style>
            div#vsphere_settings-2 table tbody tr td {
                padding: 3px 12px;
            }
            div#vsphere_settings-2 table tbody tr:first-child td {
                padding: 6px 12px 3px 12px;
            }
        </style>
        <div class="tab-pane fade" id="vsphere_settings-2" role="tabpanel" aria-labelledby="vsphere_settings-2-tab">
<?php
    // Run the get guests perl file to get a list of guest VMs...
    $cmd = get_root_dir() . '/html/includes/configwizards/vsphere/plugins/check_vsphere_xi.py -H ' . escapeshellarg($address) . ' -u ' . escapeshellarg($username) . ' -p ' . escapeshellarg($password) . ' -L';
    $proc = proc_open($cmd, array(1 => array('pipe', 'w'), 2 => array('pipe', 'w')), $pipes);
    if (is_resource($proc)) {
        $data = stream_get_contents($pipes[1]);
        fclose($pipes[1]);
        $stderr = stream_get_contents($pipes[2]);
        fclose($pipes[2]);
        proc_close($proc);
    }

    $data = explode("\n", $data);

    if (!empty($stderr)) {
?>
            <h5 class="ul"><?php echo _('Error'); ?></h5>
            <p><?php echo _('It appears there are no guests for this VMware host. The error message is below. This may be because the SDK is not installed, your credentials are wrong, or the host is not a VMware server.'); ?></p>
            <pre><?php echo $stderr; ?></pre>
        </div>
    </div>
<?php
        return;
    }
?>

            <h5 class="ul" style="padding-bottom:0;"><?php echo _('Datastores Selection'); ?></h5>
            <p><?php echo _('Specify which datastores you\'d like to monitor on the VMware host (server).'); ?></p>
            <table class="table table-condensed table-no-border table-auto-width" style="margin-bottom:5px;">
                <thead>
                    <tr>
                        <th style="vertical-align:center; padding-left:12px; padding-bottom:4px; padding-right:0px;">
                            <input type="checkbox" 
                                class="service_checkbox" 
                                id="checkAll2" 
                                title="<?php echo _('Check All'); ?>" 
                                onclick="toggleCheckboxes(this.checked)">
                            </input>
                        </th>
                        <th style="color: var(--foreground); padding-bottom: 10px;"><?php echo _('Datastores'); ?></th>
                        <th style="color: var(--foreground); padding-bottom: 10px;"><?php echo _('Data Used'); ?></th>
                        <th style="color: var(--foreground); padding-bottom: 10px;"><?php echo _('Data Total'); ?></th>
                        <th style="color: var(--foreground); padding-bottom: 10px;"><?php echo _('Percentage in Use'); ?></th>
                    </tr>
                </thead>
                <tbody>
<?php
    $rownumber = 2; //Used for determing row color
    $rowstyles = 'vertical-align:middle;horizontal-align:middle;';
    foreach ($data as &$element) {
        ($rownumber++ % 2) ? $tclass = 'odd' : $tclass = 'even';
        $element = explode("\t", $element);
        $nam = base64_encode($element[0]);
        $idnt = $element[0];
        if(empty($nam))
            continue;
        $nametextfield = sprintf('<input type="text" size="35" name="alias_%s" id="alias_%s" value="%s" class="form-control">', encode_form_val($nam), encode_form_val($nam), encode_form_val(array_key_exists($idnt, $guests) ? $guests[$idnt] : $idnt));
        /* Now we will draw the tables.
            $element[0] is the datastores (Text Field) set to $nametextfield for readability.
            $element[1] is the bytes being used and is set to $dataUsed variable.
            $element[2] is the total bytes avaialable and is set to $dataTotal variable.
            $element[3] is the percentage of data being used and is used to set $dataPercentage variable.*/
        // Setting nice looking powerestatus variable.
        ($element[1] == '') ? $dataUsed = '<font color="gray">' . _('None Defined') . '</font>' : $dataUsed = '<b>' . $element[1] . '</b>';
        ($element[2] == '') ? $dataTotal = '<font color="gray">' . _('None Defined') . '</font>' : $dataTotal = '<b>' . $element[2] . '</b>';
        ($element[3] == '') ? $dataPercentage = '<font color="gray">' . _('None Defined') . '</font>' : $dataPercentage = '<b>' . $element[3] . '<b>';

        if (count($guests) === 0) {
            echo '<tr class="' . $tclass . '">
                  <td style="' . $rowstyles . '; padding-top: 14px;">
                  <input type="checkbox" name="activate_' . encode_form_val($nam) . '"' . ($element[3] === 'poweredOn' ? ' checked="yes"' : '') . '>';
        } else {
            echo '<tr>
                  <td style="' . $rowstyles . '; padding-top: 14px;">
                  <input type="checkbox" name="activate_' . encode_form_val($nam) . '"' . (array_key_exists($idnt, $guests) ? ' checked="yes"' : '') . '>';
        }

        echo '</td>
              <td style="' . $rowstyles . '">' . $nametextfield . '</td>
              <td style="' . $rowstyles . '">' . $dataUsed . '</td>
              <td style="' . $rowstyles . '">' . $dataTotal . '</td>
              <td style="' . $rowstyles . '">' . $dataPercentage . '</td>
              </tr>';
    }

    unset($element, $tmp, $data);
?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div style="height: 20px;"></div>
