#!/bin/bash

BASEDIR=$(dirname $(readlink -f $0))
cd $BASEDIR

. $BASEDIR/../../../../var/xi-sys.cfg

package="wmi-1.3.14"

if [ -f /usr/local/bin/wmic ] || [ -f /usr/bin/wmic ]; then
    echo "wmic has already been installed... skipping compile"
    exit 0;
fi

# Skip for el9/ubunutu22/debian11 systems (we can't compile it and it's deprecated)
if [ "$dist" == "el9" ] || [ "$dist" == "ubuntu22" ] || [ "$dist" == "debian11" ]; then
    echp "wmic cannot be built on system... skipping compile";
    exit 0;
fi

# Install pre-reqs and cpan pre-reqs
if [ "$distro" == "Debian" ] || [ "$distro" == "Ubuntu" ]; then
    cpan install Getopt::Long DateTime Config::IniFiles List::MoreUtils ||:
else
    echo | cpan Getopt::Long
    yum install -y perl-DateTime perl-Config-IniFiles perl-List-MoreUtils
fi

tempdir="/tmp"
if [ -d /usr/local/nagiosxi/tmp ]; then
    tempdir="/usr/local/nagiosxi/tmp"
fi

(    
    # Download
    cd $tempdir
    wget "https://assets.nagios.com/downloads/nagiosxi/agents/$package.tar.gz"
    tar xf "$package.tar.gz"
    cd $package

    # Required to get the binary to build
    if [ "$dist" == "ubuntu20" ] || [ "$dist" == "el8" ]; then
        ofl=`ulimit -n`
        if [ $ofl -lt 2048 ]; then
            ulimit -n 2048
        fi
        sed -i 's/defined @$pidl/@$pidl/' Samba/source/pidl/pidl
    fi
    
    # Build (configure happens in make ...)
    make "CPP=gcc -E -ffreestanding"

    # Copy the binary to location and link
    cp -f Samba/source/bin/wmic /usr/local/bin
    cp -f Samba/source/bin/winexe /usr/local/bin
    if [ ! -f /usr/bin/wmic ]; then
        ln -s /usr/local/bin/wmic /usr/bin/wmic
    fi
    if [ ! -f /usr/bin/winexe ]; then
        ln -s /usr/local/bin/winexe /usr/bin/winexe
    fi

    # Cleanup
    cd $tempdir
    rm -rf "$package.tar.gz"
    rm -rf "$package"
)

exit 0
