<?php 
//
// Copyright (c) 2018-2019 Nagios Enterprises, LLC. All rights reserved.
//

include_once(dirname(__FILE__) . '/../configwizardhelper.inc.php');

// Initialization stuff
pre_init();
init_session();

// Grab GET or POST variables and do prereq and auth checks
grab_request_vars();
check_prereqs();
check_authentication();

route_request();

function route_request()
{
	global $request;

	$mode = grab_request_var("mode", "");

	switch($mode) {
		case'getbuckets':
			get_buckets();
			break;
		case'getregions':
			get_regions();
		default:
			echo "The S3 Utils file was called but no mode was passed.";
			exit;
	}
}

function get_buckets()
{
	global $request;

	$accesskeyid = grab_request_var("accesskeyid", "");
	$accesskey = grab_request_var("accesskey", "");
	$staticcreds = grab_request_var("staticcreds", "");
	$credsfilepath = grab_request_var("credsfilepath", "");

	$accesskeyid = base64_decode($accesskeyid);
	$accesskey = base64_decode($accesskey);

	if ($staticcreds == "on") {
		$cmd = "/usr/local/nagios/libexec/check_s3.py --changemode 'getbuckets' --credfile '" . $credsfilepath . "'";
	} else {
		$cmd = "/usr/local/nagios/libexec/check_s3.py --changemode 'getbuckets' --accesskeyid '" . $accesskeyid . "' --secretaccesskey " . $accesskey;
	}

	$cmd = escapeshellcmd($cmd);

	$bucketlist = shell_exec($cmd);

	$_SESSION['bucketlist'] = json_decode($bucketlist);

	echo $bucketlist;
}

function get_regions()
{
	global $request;

	$accesskeyid = grab_request_var("accesskeyid", "");
	$accesskey = grab_request_var("accesskey", "");

	$accesskeyid = base64_decode($accesskeyid);
	$accesskey = base64_decode($accesskey);

	$cmd = "/usr/local/nagios/libexec/check_s3.py --changemode 'getregion' --accesskeyid '" . $accesskeyid . "' --secretaccesskey " . $accesskey;

	$cmd = escapeshellcmd($cmd);
}
