    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" value="" id="object_type" name="object_type">
    <input type="hidden" value="" id="object_id" name="object_id">
    <input type="hidden" value="" id="hostname" name="hostname">
    <input type="hidden" value="" id="view_name" name="view_name">
<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
<?php
    // If NNA servers exist we can display a dropdown otherwise we need to display a message
    if (has_nna_servers()) {
?>
            <h2><?= _('Nagios Network Analyzer Server') ?></h2>
            <p><?= _('Select one of your Nagios Network Analyzer server&apos;s source, sourcegroup, or view') ?></p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('NNA Server') ?> </label>
                    <div class="input-group position-relative">
                        <?= display_nna_servers(true, '', 'form-control-sm form-select form-select-sm rounded-end') ?>
                        <div class="invalid-feedback">
                            Please select an NNA Server.
                        </div>
                        <i id="nna_server_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="" class="form-label form-item-required"><?= _('Host Name') ?> </label>
<?php // TODO: Test this more!!! ?>
                            <span class="" id="hostname-info"><strong><?= _("Connecting...") ?></strong></span>

                            <div id="hostname-selector" class="row">
                                <div class="col-sm">
                                    <select id="obj-type" class="form-control form-control-sm form-select form-select-sm">
                                        <option value="source"><?= _("Source") ?></option>
                                        <option value="group"><?= _("Sourcegroup") ?></option>
                                    </select>
                                </div>
                                <div class="col-sm">
                                    <select class="obj-selector form-control form-control-sm form-select form-select-sm" id="sources"></select>
                                    <select class="obj-selector form-control form-control-sm form-select form-select-sm" id="groups"></select>
                                </div>

                                <span style="margin-left: 10px;" class="obj-selector" id="error"></span>
                            </div>
                </div>
            </div>

            <div id="view-selector" class="row mb-2">
                <div class="col-sm-6">
                    <fieldset class="row">
                        <div class="check col-sm-auto mt-0 pt-1">
                            <input type="checkbox" id="use_view" class="form-check-input" name="use_view"  <?= is_checked($use_view, 1) ?>>
                            <label for="use_view" class="form-check-label bold"><?= _('Use a View') ?></label>
                        </div>
                        <div class="col-sm mt-0">
                            <select id="views" name="view_id" class="form-control form-control-sm form-select form-select-sm monitor rounded" placeholder="<?= _("Select View") ?> "></select>
                        </div>
                    </fieldset>
                </div>
            </div>
<?php
    } else {
        // Display NO NNA server message
?>
            <?= display_nna_no_servers(true) ?>

            <div style="height: 100px; clear: both;"></div>
<?php
    }
?>
        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function () {

            $("input[name=submitButton2]").prop("disabled", true);
<?php
        if (!has_nna_servers()) {
?>
            $("#submitButton2").hide();
<?php
        }
?>
            nna_connect();

            $("#nna_server").change(function() {
                nna_connect();
            });

            $("#obj-type").change(function() {
                load_nna_objects($(this).val() + "s");
                if ($(this).val() == "group") {
                    $("#view-selector").hide();
                }
            });

            $(".obj-selector").change(function() {

                var oname = $(this).children("option:selected").text();
                var obj_name = "";

                if ($("#obj-type").val() == "source") {
                    obj_name = "NNA Source - " + oname;
                } else if ($("#obj-type").val() == "group") {
                    obj_name = "NNA Sourcegroup - " + oname;
                }
                $("#hostname").val(obj_name);

                $("#object_id").val($(this).val());
                load_views($(this).val());
            });

            $("#views").change(function() {
                // Set the view name to whatever is selected
                $("#view_name").val($("#views option:selected").text());
            });
	});

        function nna_connect() {
            $("#obj-type").val("source");
            var server = $("#nna_server").val();
            server = server.split("|");

            var secure = "http";
            if (server[1] == 1) {
                secure = "https";
            }

            var nna_api_url = secure + "://" + server[0] + "/nagiosna/index.php/api/";
            var token = server[2];

            $("#connect-error").hide();
            $.post('<?php get_base_url();?> /nagiosxi/includes/configwizards/networkanalyzer/networkanalyzer-ajaxhelper.php', {
                    cmd: 'get_query_data',
                    nsp: '<?php echo get_nagios_session_protector_id(); ?>',
                    url: nna_api_url,
                    token: token,
                    endpoint: 'system/cpu_status',
            }, function() {}, "json")
            .done(function(data){

                if (data.error) {
                    $("#connect-error").html("<?= _("Authentication failed.Please check your API key.") ?>").show();
                } else {
                    $("input[name=submitButton2]").prop("disabled", false);
                    $("#hostname-info").hide();
                    load_nna_objects("sources");
                    $("#hostname-selector").show();
                }
            }).fail(function(data) {
                var error = "<?= _("Failed connect to API.Check your connection to the host (using SSL?) and make sure your Nagios Network Analyzer is version 2014R1.5 or higher.") ?>";
                if (data.status == 404) {
                    error = "404 - API not found.The address may be wrong.";
                }
                $("#hostname-info").html(error).show();
            });
        }

        function load_nna_objects(object) {
            var server = $("#nna_server").val();
            server = server.split("|");

            var secure = "http";

            if (server[1] == 1) {
                secure = "https";
            }

            var nna_api_url = secure + "://" + server[0] + "/nagiosna/index.php/api/";
            var token = server[2];

            $(".obj-selector").hide();
            $("#" + object).html("");

            $.post('<?php get_base_url();?> /nagiosxi/includes/configwizards/networkanalyzer/networkanalyzer-ajaxhelper.php', {
                    cmd: 'get_query_data',
                    nsp: '<?php echo get_nagios_session_protector_id(); ?>',
                    url: nna_api_url,
                    object: object,
                    token: token,
                    endpoint: '/read',
            }, function() {}, "json")
            .done(function(data){

                if (data.error) {
                    $("#error").html(data.error).show();
                } else {
                    var fobj_id = 0;
                    var fobj_name = "";
                    var objs = data;
                    if (objs.length > 0) {
                        $.each(objs, function(k, v) {
                            var id;
                            if (v.sid) {
                                id = v.sid;
                            } else if (v.gid) {
                                id = v.gid
                            }

                            if (k == 0) {
                                fobj_id = id;
                                if (v.sid) {
                                    fobj_name = "NNA Source - " + v.name;
                                } else if (v.gid) {
                                    fobj_name = "NNA Sourcegroup - " + v.name;
                                }
                            }

                            $("#" + object).append("<option value='" + id + "'>" + v.name + "</option>");
                        });
                        $("#" + object).show();
                        $("#add-obj").show();
                    } else {
                        $("#error").html("No " + object + " available.").show();
                    }

                    // For first run we select the first object and put it into id/type and hostname
                    $("#hostname").val(fobj_name);
                    $("#object_type").val(object);
                    $("#object_id").val(fobj_id);

                    // If a source, lets get the views
                    if (object == "sources") {
                        load_views(fobj_id);
                    }
                }
            }, "json");
        }

        function load_views(sid)
        {
            var server = $("#nna_server").val();
            server = server.split("|");

            var secure = "http";
            if (server[1] == 1) {
                secure = "https";
            }
            var nna_api_url = secure + "://" + server[0] + "/nagiosna/api/";
            var token = server[2];

            $.post('<?php get_base_url();?> /nagiosxi/includes/configwizards/networkanalyzer/networkanalyzer-ajaxhelper.php', {
                    cmd: 'get_source_views',
                    nsp: '<?php echo get_nagios_session_protector_id(); ?>',
                    url: nna_api_url,
                    token: token,
                    sid: sid,
                    endpoint: 'views/get_views'
            }, function() {}, "json")
            .done(function(views){

                if (views.length > 0) {
                    $("#view-selector").show();
                    $("#views").html("");
                    $.each(views, function(k, v) {
                        $("#views").append("<option value='" + v.vid + "'>" + v.name + "</option>");
                    });
                } else {
                    $("#view-selector").hide();
                }

                // Set the view name to whatever is selected
                $("#view_name").val($("#views option:selected").text());
            }, "json");
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
