    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>" />
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

<?php
    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container m-0 g-0">
        <!--                         -->
        <!-- The configuration form. -->
        <!--                         -->
        <div id="configForm">
            <h2 class="mb-2"><?= _('SNMP Information') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="ip_address" class="form-label form-item-required"><?= _('Device Address') ?> <?= xi6_info_tooltip(_('The IP address or fully qualified DNS name of the server or device you would like to monitor')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Device Address") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Device Address
                        </div>
                        <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="port" class="form-label form-item-required"><?= _('Device Port') ?> <?= xi6_info_tooltip(_('The port on which the SNMP device is listening')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="port" id="port" value="<?= encode_form_val($port) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Device Port") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Device Port
                        </div>
                        <i id="port_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <h2 class="mb-2"><?= _('SNMP Authentication') ?></h2>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="snmpversion" class="form-label form-item-required"><?= _('SNMP Version') ?> <?= xi6_info_tooltip(_('The SNMP protocol version used to commicate with the device')) ?></label>
                    <div class="input-group position-relative">
                        <select name="snmpversion" id="snmpversion" class="form-select monitor rounded" placeholder="<?= _("Select SNMP Version") ?> " required>
                            <option value="1" <?= is_selected($snmpversion, "1") ?>>1</option>
                            <option value="2c" <?= is_selected($snmpversion, "2c") ?>>2c</option>
                            <option value="3" <?= is_selected($snmpversion, "3") ?>>3</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select SNMP Version
                        </div>
                        <i id="snmpversion_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div id="snmpv1-2" class="row mb-2">
                <div class="col-sm-6">
                    <label for="snmpcommunity" class="form-label form-item-required"><?= _('SNMP Community') ?> <?= xi6_info_tooltip(_('The SNMP community string used to query the device')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="snmpcommunity" id="snmpcommunity" value="<?= encode_form_val($snmpcommunity) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter SNMP Community") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the SNMP Community
                        </div>
                        <i id="snmpcommunity_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2 snmpv3 visually-hidden">
                <div class="col-sm-6">
                    <label for="snmpopts[v3_security_level]" class="form-label form-item-required"><?= _('Security Level') ?> </label>
                    <div class="input-group position-relative">
                        <select name="snmpopts[v3_security_level]" id="snmpopts[v3_security_level]" class="form-select monitor rounded security_level" placeholder="<?= _("Select Security Level") ?> " required>
                            <option value="authPriv" <?= is_selected($snmpopts["v3_security_level"], "authPriv") ?>>authPriv</option>
                            <option value="authNoPriv" <?= is_selected($snmpopts["v3_security_level"], "authNoPriv") ?>>authNoPriv</option>
                            <option value="noAuthNoPriv" <?= is_selected($snmpopts["v3_security_level"], "noAuthNoPriv") ?>>noAuthNoPriv</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Security Level
                        </div>
                        <i id="snmpopts[v3_security_level]_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2 snmpv3 visually-hidden">
                <div class="col-sm-6">
                    <label for="snmpopts[v3_username]" class="form-label form-item-required"><?= _('Username') ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="snmpopts[v3_username]" id="snmpopts[v3_username]" value="<?= encode_form_val($snmpopts['v3_username']) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Username") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Username
                        </div>
                        <i id="snmpopts[v3_username]_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2 snmpv3 visually-hidden">
                <div class="col-sm-6">
                    <label for="snmpopts[v3_auth_password]" class="form-label form-item-required"><?= _('Authentication Password') ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="snmpopts[v3_auth_password]" id="snmpopts[v3_auth_password]" value="<?= encode_form_val($snmpopts['v3_auth_password']) ?>" class="form-control monitor rounded authPriv-enable authNoPriv-enable noAuthNoPriv-disable" placeholder="<?= _("Enter Authentication Password") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Authentication Password
                        </div>
                        <i id="snmpopts[v3_auth_password]_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2 snmpv3 visually-hidden">
                <div class="col-sm-6">
                    <label for="snmpopts[v3_auth_proto]" class="form-label form-item-required"><?= _('Authentication Protocol') ?> </label>
                    <div class="input-group position-relative">
                        <select name="snmpopts[v3_auth_proto]" id="snmpopts[v3_auth_proto]" class="form-select monitor rounded authPriv-enable authNoPriv-enable noAuthNoPriv-disable" placeholder="<?= _("Select Authentication Protocol") ?> " required>
                            <option value="MD5" <?= is_selected($snmpopts["v3_auth_proto"], "MD5") ?>>MD5</option>
                            <option value="SHA" <?= is_selected($snmpopts["v3_auth_proto"], "SHA") ?>>SHA</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Authentication Protocol
                        </div>
                        <i id="snmpopts[v3_auth_proto]_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2 snmpv3 visually-hidden">
                <div class="col-sm-6">
                    <label for="snmpopts[v3_privacy_password]" class="form-label form-item-required"><?= _('Privacy Password') ?> </label>
                    <div class="input-group position-relative">
                        <input type="text" name="snmpopts[v3_privacy_password]" id="snmpopts[v3_privacy_password]" value="<?= encode_form_val($snmpopts['v3_privacy_password']) ?>" class="form-control monitor rounded authPriv-enable authNoPriv-disable noAuthNoPriv-disable" placeholder="<?= _("Enter Privacy Password") ?>" required>
                        <div class="invalid-feedback">
                            Please enter the Privacy Password
                        </div>
                        <i id="snmpopts[v3_privacy_password]_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2 snmpv3 visually-hidden">
                <div class="col-sm-6">
                    <label for="snmpopts[v3_priv_proto]" class="form-label form-item-required"><?= _('Privacy Protocol') ?> </label>
                    <div class="input-group position-relative">
                        <select name="snmpopts[v3_priv_proto]" id="snmpopts[v3_priv_proto]" class="form-select monitor rounded authPriv-enable authNoPriv-disable noAuthNoPriv-disable" placeholder="<?= _("Select Privacy Protocol") ?> " required>
<?php
    $xisys = $cfg['root_dir'] . '/var/xi-sys.cfg';
    $ini = parse_ini_file($xisys);

    $des_option = '';

    if ($ini['dist'] != "el9" && $ini['dist'] != "ubuntu22") {
?>
                            <option value="des" <?= is_selected($snmpopts["v3_priv_proto"], "des") ?>>DES</option>
<?php
    }
?>
                            <option value="aes" <?= is_selected($snmpopts["v3_priv_proto"], "aes") ?>>AES</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select Privacy Protocol
                        </div>
                        <i id="snmpopts[v3_priv_proto]_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <h2 class="mt-4"><?= _('SNMP Scan Settings') ?></h2>
            <p><?= _('Add some specifics to narrow down the SNMP scan results') ?></p>

            <div class="mib-list">
                <div class="row">
                    <div class="col-sm-6">
                        <label for="mibs[]" class="form-label">MIBs <?= xi6_info_tooltip(_('Select MIBs whose OIDs you want to see. By default, if no MIBs selected, the scan will show all OIDs for all MIBs')) ?></label>
                    </div>
                </div>

<?php
        // Build Multi select HTML
        $mibs_list = get_mibs();
        $select_options_html = '';

        foreach ($mibs_list as $m) {
            $selected = '';
            if (in_array($m['mib_name'], $mibs)) { $selected = ' selected'; }
            $select_options_html .= '<option value="'.$m['mib_name'].'"'.$selected.'>'.$m['mib_name'].'</option>';
        }
?>
            <style type="text/css">
                #mibs.mib-select { width: 300px; height: 200px; }
            </style>

                <div class="row mb-2 mib-box">
                    <div class="col-sm-6">
                        <div class="input-group position-relative">
                            <select name="mibs[]" id="mibs" multiple  class="mib-select form form-control multiselect">
                                <?= $select_options_html ?>
                            </select>
                            <div class="invalid-feedback">
                                Please select MIBs
                            </div>
                            <i id="mibs[]_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-auto mt-auto">
                        <div class="input-group mb-2">
                            <?= $text ?>
                        </div>
                    </div>
                </div>  <!-- row -->
            </div>  <!-- mib-list -->

            <h2 class="mt-4"><?= _('SNMP Advanced Scan Settings') ?></h2>
            <p><?= _('Specify advanced settings for the SNMP scan. Adjusting these settings is <b>optional</b>.') ?></p>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="oid" class="form-label">OID <?= xi6_info_tooltip(_('The top-level OID to use for scanning. If empty, by default, it will scan, private, which should work for most MIBs')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="oid" id="oid" value="<?= encode_form_val($oid) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter OID") ?>">
                        <div class="invalid-feedback">
                            Please enter the OID
                        </div>
                        <i id="oid_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="timeout" class="form-label"><?= _('Timeout') ?> <?= xi6_info_tooltip(_('The maximum number of seconds to wait for the SNMP scan to complete')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="timeout" id="timeout" value="<?= encode_form_val($timeout) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Timeout") ?>">
                        <div class="invalid-feedback">
                            Please enter the Timeout
                        </div>
                        <i id="timeout_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-sm-6">
                    <label for="maxresults" class="form-label"><?= _('Max Results') ?> <?= xi6_info_tooltip(_('The maximum number of results to process from the SNMP scan')) ?></label>
                    <div class="input-group position-relative">
                        <input type="text" name="maxresults" id="maxresults" value="<?= encode_form_val($maxresults) ?>" class="form-control monitor rounded" placeholder="<?= _("Enter Max Results") ?>">
                        <div class="invalid-feedback">
                            Please enter the Max Results
                        </div>
                        <i id="maxresults_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                </div>
            </div>

        </div> <!-- config -->
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            check_snmpwalk_version();

            $("#snmpversion").change(function() {
                check_snmpwalk_version();
            });

            security_level = $(".security_level").val();
            enable_fields_by_security_level(security_level);

            $(".security_level").change(function () {
                enable_fields_by_security_level($(this).val());
            });

            $(".multiselect").on("mouseenter", function($this) {
                $(this).trigger("focus");
            });

        });

        function enable_fields_by_security_level(level) {
            $("." + level + "-enable").attr("disabled", false);
            $("." + level + "-disable").attr("disabled", true);
        }

        function check_snmpwalk_version() {
            if ($("#snmpversion").val() != "3") {
                $(".snmpv3").addClass('visually-hidden');
                $(".snmpv3 :input").removeAttr('required');

                $("#snmpv1-2").removeClass('visually-hidden');
                $("#snmpcommunity").attr('required', true);
            } else {
                $(".snmpv3").removeClass('visually-hidden');
                $(".snmpv3 :input").attr('required', true);

                $("#snmpv1-2").addClass('visually-hidden');
                $("#snmpcommunity").removeAttr('required');
            }
        }
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
