    <!--                                   -->
    <!-- The initial data set from Step 1. -->
    <!--                                   -->
    <input type="hidden" id="hostname" name="hostname" value="<?= encode_form_val($hostname) ?>">
    <input type="hidden" id="operation" name="operation" value="<?= encode_form_val($operation) ?>">
    <input type="hidden" id="selectedhostconfig" name="selectedhostconfig" value="<?= encode_form_val($selectedhostconfig) ?>">
    <input type="hidden" id="services_serial" name="services_serial" value="<?= (!empty($services)) ? base64_encode(json_encode($services)) : "" ?>" />
    <input type="hidden" id="serviceargs_serial" name="serviceargs_serial" value="<?= (!empty($serviceargs)) ? base64_encode(json_encode($serviceargs)) : "" ?>" />
    <input type="hidden" id="config_serial" name="config_serial" value="<?= (!empty($config)) ? base64_encode(json_encode($config)) : "" ?>" />

    <input type="hidden" name="port" value="<?= encode_form_val($port) ?>">
    <input type="hidden" name="ip_address" value="<?= encode_form_val($address) ?>">
    <input type="hidden" name="snmpcommunity" value="<?= encode_form_val($snmpcommunity) ?>">
    <input type="hidden" name="snmpversion" value="<?= encode_form_val($snmpversion) ?>">
    <input type="hidden" name="oid" value="<?= encode_form_val($oid) ?>">
    <input type="hidden" name="miblist" value="<?= encode_form_val($miblist) ?>">
    <input type="hidden" name="timeout" value="<?= encode_form_val($timeout) ?>">
    <input type="hidden" name="snmpopts_serial" value="<?= base64_encode(json_encode($snmpopts)) ?>">
<?php
    foreach ($mibs as $m) {
?>
    <input type="hidden" name="mibs[]" value="<?= encode_form_val($m) ?>">
<?php
    }

    #include_once __DIR__.'/../../../utils-xi2024-wizards.inc.php';
?>
    <div class="container-fluid m-0 g-0">
<?php
    if (!array_key_exists("oid", $serviceargs) || count($serviceargs["oid"]) == 0) {
?>
        <p><b><?= _('No results were returned from a scan of the device') ?></b></p><p><?= _('This could be due to one of the following reasons') ?>:</p>
        <p>
            <ul class="error-list">
                <li><?= _('No results were found based on the settings provided') ?></li>
                <li><?= sprintf(_('Could not connect to the host (%s) or the port (%s) is unaccessible or blocked by a firewall'), $address, $port) ?></li>
                <li><?= sprintf(_('The snmp scan timed out (timeout currently set to %s seconds)'), $timeout) ?></li>
<?php
        if (!empty($mibs)) {
?>
                <li><?= _('The scan returned results, but did not return any results of the following filtered MIBs you selected (shown below)') ?>
                    <ul>
<?php
            foreach ($mibs as $m) {
?>
                        <li><?= $m ?></li>
<?php
            }
?>
                    </ul>
                </li>
<?php
        }
?>
            </ul>
        </p>
<?php
    // If we returned with an error, display the error message below
?>
        <p><?= _('To view the error or full results') ?>, <a class="show-error"><?= _('view the raw output from the scan') ?></a>.</p>
        <div class="alert alert-primary hide error-out">
            <div class="card card-p">
                <pre class="mb-0"><?= $fcontents ?></pre>
            </div>
        </div>
        <p><?= _('Either') ?> <a href="javascript: history.go(-1)"><?= _('go back and change your settings') ?></a> <?= _('or you can') ?> <a href="javascript:location.reload(true)" id="retry"><?= _('try re-running the same scan again') ?></a>.</p>
<?php
    } else {
?>
        <h2 class="mb-2"><?= _('Device Details') ?></h2>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="ip_address" class="form-label"><?= _('Device Address') ?> </label>
                <div class="input-group position-relative">
                    <input type="text" name="ip_address" id="ip_address" value="<?= encode_form_val($address) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Device Address") ?>" disabled="on">
                    <div class="invalid-feedback">
                        <?= _("Please enter the IP Address") ?>
                    </div>
                    <i id="ip_address_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-sm-6">
                <label for="hostname" class="form-label"><?= _('Host Name') ?> <?= xi6_info_tooltip(_('The name you would like to have associated with this server or device')) ?></label>
                <div class="input-group position-relative">
                    <input type="text" name="hostname" id="hostname" value="<?= encode_form_val($hostname) ?>" class="form-control form-control-sm monitor rounded" placeholder="<?= _("Enter Host Name") ?>" >
                    <div class="invalid-feedback">
                        <?= _("Please enter the Host Name") ?>
                    </div>
                    <i id="hostname_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                </div>
            </div>
        </div>

        <h2 class="mt-4"><?= _('SNMP Services') ?></h2>
        <p><?= _('Select the OIDs you would like to monitor via SNMP') ?></p>
<?php
        // Show that we hit the max to the user
        if ($hit_max) {
?>
        <div class="alert alert-info"><?= sprintf(_('You have reached the maximum processing limit of %s records. Return to step 1 to adjust the maximum results setting to view more.'), number_format(intval($maxresults))) ?></div>
<?php
        }

        // Mib selection
        if (!empty($miblist)) {
?>
        <p><?= _('Currently showing OIDs related to the following MIBs:') ?> <b><?= encode_form_val($miblist) ?></b></p>
<?php
        }
?>
         <div class="row">
            <div class="col-sm-12">
                <fieldset class="row g-2 mb-1">
                    <div class="d-flex align-items-end col-sm-1">
                        <div class="input-group input-group-sm">
                            <label class="form-check-label bold"><?= _('Select') ?></label>
                        </div>
                    </div>
                    <div class="d-flex align-items-end col-sm-3">
                        <label class="form-check-label bold"><?= _('OID') ?></label>
                    </div>
                    <div class="d-flex align-items-end col-sm-1">
                        <label class="form-check-label bold"><?= _('Type') ?></label>
                    </div>
                    <div class="d-flex align-items-end col-sm-1">
                        <label class="form-check-label bold"><?= _('Current Value') ?></label>
                    </div>
                    <div class="d-flex align-items-end col-sm-2 text-center">
                        <label class="form-check-label bold"><?= _('Display Name') ?></label>
                    </div>
                    <div class="d-flex align-items-end col-sm-1 text-center">
                        <label class="form-check-label bold"><?= _('Data Label') ?> <?= xi6_info_tooltip(_('The text that will be displayed before the data (string or number) in the check output.')) ?></label>
                    </div>
                    <div class="d-flex align-items-end col-sm-1 text-center">
                        <label class="form-check-label bold"><?= _('Data Units') ?> <?= xi6_info_tooltip(_('Optional data unit (examples: C, users, load)')) ?></label>
                    </div>
                    <div class="d-flex align-items-end col-sm-1 text-center">
                        <label class="form-check-label bold"><?= _('Match Type') ?></label>
                    </div>
                    <div class="d-flex align-items-end col-sm-1">
                        <label class="form-check-label bold text-center"><?= _('Thresholds') ?> <?= xi6_info_tooltip(_('If a match type is numeric, you must set a warning and critical value. If a match is a string, it must match the string exactly or it will be critical.')) ?></label>
                    </div>
                </fieldset>
            </div>
        </div>
<?php
        $total = count($serviceargs["oid"]);

        for ($x = 0; $x < $total; $x++) {

                    $string_hide = ' hide';
                    $numeric_hide = ' hide';

                    if ($serviceargs["oid"][$x]["type"] == 'INTEGER') {
                        $serviceargs["oid"][$x]["matchtype"] = 'numeric';
                        $numeric_hide = '';

                    } else if ($serviceargs["oid"][$x]["type"] == 'STRING') {
                        $serviceargs["oid"][$x]["matchtype"] = 'string';
                        $string_hide = '';
                    }
?>
         <div class="row">
            <div class="col-sm-12">
                <fieldset class="row g-2 mb-1 wz-fieldset">
                    <div class="form-check col-sm-1 mt-0 d-flex align-items-center flex-column">
                        <div class="input-group input-group-sm">
                            <input type="checkbox" class="form-check-input mt-2 me-2 rounded" name="services[oid][<?= $x ?>]" id="services[oid][<?= $x ?>]" <?= isset($services['oid'][$x]) ? is_checked($services['oid'][$x]) : '' ?>>
                            <div class="col-sm d-flex align-items-center flex-column">
                                <label for="services[oid][<?= $x ?>]" class="text-center"><?= encode_form_val($serviceargs['oid'][$x]['mib']) ?></label>
                            </div>
                            <input type="hidden" name="serviceargs[oid][<?= $x ?>][mib]" value="<?= encode_form_val($serviceargs["oid"][$x]["mib"]) ?>">
                        </div>
                    </div>
                    <div class="col-sm-3 mt-0">
                        <input type="text" name="serviceargs[oid][<?= $x ?>][oid]" id="serviceargs[oid][<?= $x ?>][oid]" value="<?= encode_form_val($serviceargs['oid'][$x]['oid']) ?>" class="form-control form-control-sm rounded monitor">
                        <i id="serviceargs_oid_<?= $x ?>_oid_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-1 mt-0">
                        <label class="form-label"><?= encode_form_val($serviceargs["oid"][$x]["type"]) ?></label>
                        <input type="hidden" name="serviceargs[oid][<?= $x ?>][type]" value="<?= encode_form_val($serviceargs["oid"][$x]["type"]) ?>" />
                    </div>
                    <div class="col-sm-1 mt-0">
                        <label class="form-label"><?= encode_form_val($serviceargs["oid"][$x]["val"]) ?></label>
                        <input type="hidden" name="serviceargs[oid][<?= $x ?>][val]" value="<?= encode_form_val($serviceargs["oid"][$x]["val"]) ?>" />
                    </div>
                    <div class="col-sm-2 mt-0">
                        <input type="text" name="serviceargs[oid][<?= $x ?>][name]" id="serviceargs[oid][<?= $x ?>][name]" value="<?= encode_form_val($serviceargs['oid'][$x]['name']) ?>" class="form-control form-control-sm rounded monitor">
                        <i id="serviceargs_oid_<?= $x ?>_name_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-1 mt-0">
                        <input type="text" name="serviceargs[oid][<?= $x ?>][label]" id="serviceargs[oid][<?= $x ?>][label]" value="<?= encode_form_val($serviceargs['oid'][$x]['label']) ?>" class="form-control form-control-sm rounded monitor">
                        <i id="serviceargs_oid_<?= $x ?>_label_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-1 mt-0">
                        <input type="text" name="serviceargs[oid][<?= $x ?>][units]" id="serviceargs[oid][<?= $x ?>][units]" value="<?= encode_form_val($serviceargs['oid'][$x]['units']) ?>" class="form-control form-control-sm rounded monitor">
                        <i id="serviceargs_oid_<?= $x ?>_units_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-1 mt-0">
                        <select name="serviceargs[oid][<?= $x ?>][matchtype]" id="serviceargs[oid][<?= $x ?>][matchtype]" class="form-control form-control-sm form-select form-select-sm match-type">
                            <option value="none" <?= is_selected($serviceargs["oid"][$x]["matchtype"], "none") ?>><?= _('None') ?></option>
                            <option value="numeric" <?= is_selected($serviceargs["oid"][$x]["matchtype"], "numeric") ?>><?= _('Numeric') ?></option>
                            <option value="string" <?= is_selected($serviceargs["oid"][$x]["matchtype"], "string") ?>><?= _('String') ?></option>
                        </select>
                        <i id="serviceargs_oid_<?= $x ?>_matchtype_Alert" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                    </div>
                    <div class="col-sm-1 mt-0 numeric<?= $numeric_hide ?>">
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <img src="<?= theme_image('error.png') ?>" <?= xi6_title_tooltip(_('Warning Threshold')) ?>>
                            </span>
                            <input type="text" id="serviceargs[oid][<?= $x ?>][warning]" name="serviceargs[oid][<?= $x ?>][warning]" value="<?= encode_form_val($serviceargs["oid"][$x]["warning"]) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_oid_<?= $x ?>_warning_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                        <div class="input-group input-group-sm">
                            <span class="input-group-text">
                                <img src="<?= theme_image('critical_small.png') ?>" <?= xi6_title_tooltip(_('Critical Threshold')) ?>>
                            </span>
                            <input type="text" id="serviceargs[oid][<?= $x ?>][critical]" name="serviceargs[oid][<?= $x ?>][critical]" value="<?= encode_form_val($serviceargs["oid"][$x]['critical']) ?>" class="form-control form-control-sm monitor">
                            <i id="serviceargs_oid_<?= $x ?>_critical_Alert-sm" class="visually-hidden position-absolute top-0 start-100 translate-middle icon icon-circle color-ok icon-size-status"></i>
                        </div>
                    </div>
                    <div class="col-sm-1 mt-0 string<?= $string_hide ?>">
                        <input type="text" name="serviceargs[oid][<?= $x ?>][string]" id="serviceargs[oid][<?= $x ?>][string]" value="<?= encode_form_val($serviceargs["oid"][$x]["string"]) ?>" class="form-control form-control-sm">
                    </div>
                </fieldset>
            </div>
        </div>
<?php
        }
    }
?>
    </div> <!-- container -->

    <script type="text/javascript">
        $(document).ready(function() {
            $("#configWizardForm").submit(function(e) {
                whiteout();
                $("#snmpwalk-throbber").center().show();
            });

            $(".show-error").click(function() {
                $(".error-out").show();
            });

            $(".match-type").change(function() {
                var match = $(this).val();
                if (match == "none") {
                    $(this).parents(".row").find(".numeric").hide();
                    $(this).parents(".row").find(".string").hide();
                } else if (match == "numeric") {
                    $(this).parents(".row").find(".numeric").show();
                    $(this).parents(".row").find(".string").hide();
                } else if (match == "string") {
                    $(this).parents(".row").find(".numeric").hide();
                    $(this).parents(".row").find(".string").show();
                }
            });
        });
    </script>

    <script type="text/javascript" src="<?= get_base_url() ?>includes/js/wizards-bs5.js?<?= get_build_id(); ?>"></script>
