/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CheckParameters {
    private boolean doesCheckFile;
    private String fileName;
    private String svcName;
    private String perfName;
    private String url;
    private String type;
    private ObjectName[] objects;
    private String[] methodsAndAttributes;
    private boolean[] isMethod;
    private String[] compositeDataKeys;
    private String unitPerf;
    private String unitSvc;
    private Object valueSvc;

    public CheckParameters(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        this(false, null, null, string, string2, string3, string4, string5, string6, string7, string8, string9);
    }

    public CheckParameters(boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        String[] stringArray;
        String[] stringArray2;
        int n;
        this.doesCheckFile = bl;
        this.fileName = null;
        if (bl && string != null) {
            this.fileName = string.replaceAll("\\s", "");
        }
        this.url = string2;
        this.svcName = string3;
        this.perfName = string4;
        this.unitPerf = string10;
        this.unitSvc = string11;
        this.valueSvc = null;
        String[] stringArray3 = string6.split(";");
        String[] stringArray4 = new String[]{};
        if (string7 != null && !string7.isEmpty() && (stringArray4 = string7.split(",")).length == 0) {
            stringArray4 = new String[stringArray3.length];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray4[n] = "";
            }
        }
        if (string8 != null && !string8.isEmpty()) {
            stringArray2 = string8.split(",");
            if (stringArray2.length == 0) {
                stringArray2 = new String[stringArray3.length];
                for (n = 0; n < stringArray3.length; ++n) {
                    stringArray2[n] = "";
                }
            }
        } else {
            stringArray2 = new String[stringArray4.length];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray2[n] = "";
            }
        }
        if (string9 != null && !string9.isEmpty()) {
            stringArray = string9.split(",");
            if (stringArray.length == 0) {
                stringArray = new String[stringArray3.length];
                for (n = 0; n < stringArray3.length; ++n) {
                    stringArray[n] = "";
                }
            }
        } else {
            stringArray = new String[stringArray3.length];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray[n] = "";
            }
        }
        if (stringArray3.length != stringArray4.length || stringArray2.length != 0 && stringArray3.length != stringArray2.length || stringArray.length != 0 && stringArray3.length != stringArray.length) {
            throw new IllegalArgumentException("All of the lists (object, attribute, method, key) must be of equal length.");
        }
        this.objects = new ObjectName[stringArray3.length];
        for (n = 0; n < stringArray3.length; ++n) {
            try {
                if (stringArray3[n].equals("time")) {
                    this.objects[n] = null;
                    continue;
                }
                this.objects[n] = new ObjectName(stringArray3[n]);
                continue;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException(this.objects[n] + " could not be converted to ObjectName. Please contact the plugin maintainer.");
            }
        }
        if (stringArray4.length != 0) {
            this.isMethod = new boolean[stringArray4.length];
            this.methodsAndAttributes = new String[stringArray4.length];
            for (n = 0; n < stringArray4.length; ++n) {
                this.methodsAndAttributes[n] = stringArray2[n];
                this.isMethod[n] = true;
                if (stringArray4[n] == null || stringArray4[n].isEmpty()) continue;
                this.methodsAndAttributes[n] = stringArray4[n];
                this.isMethod[n] = false;
            }
        }
        this.compositeDataKeys = stringArray;
        if (!(string5.equals("long") || string5.equals("double") || string5.equals("string") || string5.equals("rate"))) {
            throw new IllegalArgumentException("CheckParameters defined incorrectly: type must be one of long, double, string, or rate.");
        }
        this.type = string5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object getCheckValue(Object[] objectArray) {
        long l;
        Object[] objectArray2 = new Object[objectArray.length];
        if (this.doesCheckFile) {
            objectArray2 = this.readLastValueWriteNewValue(objectArray);
            if (objectArray2 == null) return 0;
            if (objectArray2.length == 0) {
                return 0;
            }
            for (int i = 0; i < objectArray2.length; ++i) {
                if (objectArray[i] instanceof Double) {
                    if (objectArray2[i] instanceof String) {
                        objectArray2[i] = Double.parseDouble((String)objectArray2[i]);
                    }
                    if (!(objectArray2[i] instanceof Double) || !((Double)objectArray2[i] <= (Double)objectArray[i])) continue;
                    objectArray[i] = (Double)objectArray[i] - (Double)objectArray2[i];
                    continue;
                }
                if (!(objectArray[i] instanceof Long) && !(objectArray[i] instanceof Integer)) continue;
                if (objectArray[i] instanceof Integer) {
                    objectArray[i] = ((Integer)objectArray[i]).longValue();
                }
                if (objectArray2[i] instanceof String) {
                    l = Long.parseLong((String)objectArray2[i]);
                    objectArray2[i] = l;
                }
                if (!(objectArray2[i] instanceof Long) || (Long)objectArray2[i] > (Long)objectArray[i]) continue;
                objectArray[i] = (Long)objectArray[i] - (Long)objectArray2[i];
            }
        }
        Object object = null;
        if (this.type.equals("rate")) {
            if (objectArray.length != 2) throw new IllegalArgumentException("These CheckParameters are a rate but parameter list " + objectArray[0] + " " + objectArray[1] + " isn't 2 numbers");
            if (!(objectArray[0] instanceof Double)) {
                if (!(objectArray[0] instanceof Long)) throw new IllegalArgumentException("These CheckParameters are a rate but parameter list " + objectArray[0] + " " + objectArray[1] + " isn't 2 numbers");
            }
            if (!(objectArray[1] instanceof Double)) {
                if (!(objectArray[1] instanceof Long)) throw new IllegalArgumentException("These CheckParameters are a rate but parameter list " + objectArray[0] + " " + objectArray[1] + " isn't 2 numbers");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Long)) continue;
                objectArray[i] = new Long((Long)objectArray[i]).doubleValue();
            }
            double d = (Double)objectArray[0] / (Double)objectArray[1];
            this.negotiateValue(d);
            return d;
        }
        if (this.type.equals("string")) {
            if (objectArray.length != 1) throw new IllegalArgumentException("These CheckParameters represent a String check but parameter list isn't a String");
            if (!(objectArray[0] instanceof String)) throw new IllegalArgumentException("These CheckParameters represent a String check but parameter list isn't a String");
            return (String)objectArray[0];
        }
        if (this.type.equals("long")) {
            if (objectArray.length == 1 && objectArray[0] instanceof Long) {
                l = (Long)objectArray[0];
                object = (long)((Long)objectArray[0]);
                this.negotiateValue((double)l / 1.0);
                return object;
            } else {
                if (objectArray.length != 1) throw new IllegalArgumentException("These CheckParameters represent an integer check but parameter list isn't a long");
                if (!(objectArray[0] instanceof Integer)) throw new IllegalArgumentException("These CheckParameters represent an integer check but parameter list isn't a long");
                l = ((Integer)objectArray[0]).intValue();
                object = (long)((Integer)objectArray[0]).intValue();
                this.negotiateValue((double)l / 1.0);
            }
            return object;
        } else {
            if (!this.type.equals("double")) throw new IllegalArgumentException("Unsupported type for " + this.svcName + ". Please contact the plugin maintainer.");
            if (objectArray.length != 1) throw new IllegalArgumentException("These CheckParameters represent a floating-point check but parameter list isn't a double");
            if (!(objectArray[0] instanceof Double)) throw new IllegalArgumentException("These CheckParameters represent a floating-point check but parameter list isn't a double");
            objectArray[0] = this.negotiateValue((Double)objectArray[0]);
            return (double)((Double)objectArray[0]);
        }
    }

    public Object[] readLastValueWriteNewValue(Object[] objectArray) {
        int n;
        Object[] objectArray2;
        String[] stringArray = null;
        String string = "";
        try {
            string = new File(CheckParameters.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        catch (SecurityException | URISyntaxException exception) {
            // empty catch block
        }
        File file = new File(string + "." + this.fileName);
        String string2 = this.url + " ||| " + this.svcName;
        for (int i = 0; i < objectArray.length; ++i) {
            string2 = string2 + " ||| " + objectArray[i].toString();
        }
        try {
            List<String> list;
            if (file.createNewFile()) {
                list = Arrays.asList(string2);
            } else {
                objectArray2 = Files.readAllLines(file.toPath(), Charset.defaultCharset());
                n = 0;
                for (int i = 0; i < objectArray2.size(); ++i) {
                    String[] stringArray2 = objectArray2.get(i).split(" \\|\\|\\| ");
                    if (stringArray2.length <= 1 || !stringArray2[1].equals(this.svcName) || !stringArray2[0].equals(this.url)) continue;
                    n = 1;
                    stringArray = Arrays.copyOfRange(stringArray2, 2, stringArray2.length);
                    objectArray2.remove(i);
                    objectArray2.add(i, string2);
                }
                if (n == 0) {
                    objectArray2.add((String)string2);
                }
                list = objectArray2;
            }
            Files.write(file.toPath(), list, Charset.defaultCharset(), StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to read/write to file: " + iOException.getMessage());
        }
        if (stringArray == null || stringArray.length == 0) {
            return new Object[0];
        }
        objectArray2 = new Object[stringArray.length];
        for (n = 0; n < objectArray2.length; ++n) {
            objectArray2[n] = stringArray[n];
        }
        return objectArray2;
    }

    public boolean isMethod(int n) {
        return this.isMethod[n];
    }

    public String getMethAttrName(int n) {
        return this.methodsAndAttributes[n];
    }

    public String getKey(int n) {
        return this.compositeDataKeys[n];
    }

    public int getSize() {
        return this.objects.length;
    }

    public String getValueType() {
        return this.type;
    }

    public String getUnitSvc() {
        return this.unitSvc;
    }

    public double negotiateValue(double d) {
        double d2 = d;
        if (this.unitPerf.equals("ms")) {
            if (d > 8.64E7) {
                double d3 = d / 8.64E7;
                this.unitSvc = "days";
                this.valueSvc = d3;
            } else if (d > 3600000.0) {
                double d4 = d / 3600000.0;
                this.unitSvc = "hours";
                this.valueSvc = d4;
            } else if (d > 60000.0) {
                double d5 = d / 60000.0;
                this.unitSvc = "minutes";
                this.valueSvc = d5;
            } else {
                double d6 = d / 1000.0;
                this.unitSvc = "seconds";
                this.valueSvc = d6;
            }
        } else if (this.unitPerf.equals("B")) {
            if (d > 1.073741824E9) {
                double d7 = d / 1.073741824E9;
                this.unitSvc = "GiB";
                this.valueSvc = d7;
            } else if (d > 1048576.0) {
                double d8 = d / 1048576.0;
                this.unitSvc = "MiB";
                this.valueSvc = d8;
            } else if (d > 1024.0) {
                double d9 = d / 1024.0;
                this.unitSvc = "KiB";
                this.valueSvc = d9;
            } else {
                double d10 = d / 1.0;
                this.unitSvc = "B";
                this.valueSvc = d10;
            }
        } else if (this.unitPerf.equals("%")) {
            this.unitSvc = "%";
            this.valueSvc = d * 100.0;
            d2 *= 100.0;
        }
        return d2;
    }

    public String getUnitPerf() {
        return this.unitPerf;
    }

    public String getValueSvc(Object object) {
        if (this.valueSvc == null) {
            this.valueSvc = object;
        }
        if (this.valueSvc instanceof Double || this.valueSvc instanceof Float) {
            double d = 0.0;
            d = (Double)this.valueSvc;
            d *= 100.0;
            d = Math.round(d);
            this.valueSvc = d /= 100.0;
        }
        return this.valueSvc.toString();
    }

    public String getName() {
        return this.svcName;
    }

    public String getPerfName() {
        return this.perfName;
    }

    public ObjectName getObjectName(int n) {
        return this.objects[n];
    }

    public boolean isTimestamp(int n) {
        return this.objects[n] == null && this.methodsAndAttributes[n].equals("time");
    }
}

