/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GenericASCheck {
    private JVMCheck query;
    private NagiosThresholds[] checkThresholds;
    private CheckParameters[] paramsList;
    public static String[] serverTypes = new String[]{"tomcat", "jboss", "jetty", "glassfish", "other"};

    public GenericASCheck(CommandLine commandLine) {
        String[] stringArray;
        int n;
        String[] stringArray2;
        PrintStream printStream = System.err;
        PrintStream printStream2 = new PrintStream(new NullStream());
        System.setErr(printStream2);
        try {
            this.query = new JVMCheck(commandLine.getOptionValue("service-url"), commandLine.getOptionValue("username"), commandLine.getOptionValue("password"));
        }
        catch (ClassCastException classCastException) {
            System.out.println("UNKNOWN: could not connect to provided service URL");
            System.exit(3);
        }
        System.setErr(printStream);
        String string = "other";
        if (commandLine.hasOption("server-type")) {
            string = commandLine.getOptionValue("server-type");
            boolean bl = false;
            for (String string2 : serverTypes) {
                if (!string2.equals(string)) continue;
                bl = true;
            }
            if (!bl) {
                string = "other";
            }
        }
        String[] stringArray3 = commandLine.getOptionValue("check-types").split(",");
        if (commandLine.hasOption("warning")) {
            stringArray2 = commandLine.getOptionValue("warning").split(",", -1);
        } else {
            stringArray2 = new String[stringArray3.length];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray2[n] = "";
            }
        }
        if (commandLine.hasOption("critical")) {
            stringArray = commandLine.getOptionValue("critical").split(",", -1);
        } else {
            stringArray = new String[stringArray3.length];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray2[n] = "";
            }
        }
        if (stringArray2.length < stringArray3.length) {
            String[] stringArray4 = new String[stringArray3.length];
            int n2 = 0;
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                stringArray4[n2] = stringArray2[n2];
            }
            for (n2 = stringArray2.length; n2 < stringArray4.length; ++n2) {
                stringArray4[n2] = "";
            }
            stringArray2 = stringArray4;
        }
        if (stringArray.length < stringArray3.length) {
            String[] stringArray5 = new String[stringArray3.length];
            int n3 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                stringArray5[n3] = stringArray[n3];
            }
            for (n3 = stringArray.length; n3 < stringArray5.length; ++n3) {
                stringArray5[n3] = "";
            }
            stringArray = stringArray5;
        }
        this.populateCheckParameters(stringArray3, string, commandLine.getOptionValue("service-url"));
        this.checkThresholds = new NagiosThresholds[stringArray3.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            this.checkThresholds[i] = new NagiosThresholds(stringArray2[i], stringArray[i], this.paramsList[i].getValueType());
        }
    }

    public void runChecks() {
        Object[] objectArray = this.query.getValues(this.paramsList);
        int n = 0;
        int n2 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < objectArray.length; ++i) {
            int n3 = this.checkThresholds[i].check(objectArray[i]);
            if (n3 == n) {
                ++n2;
            } else if (n3 > n) {
                n = n3;
                n2 = 1;
            }
            string = string + GenericASCheck.makeLongOut(this.paramsList[i].getName(), n3, this.paramsList[i].getValueSvc(objectArray[i]), this.paramsList[i].getUnitSvc()) + "\n";
            string3 = string3 + GenericASCheck.makePerfData(this.paramsList[i].getPerfName(), objectArray[i].toString(), this.paramsList[i].getUnitPerf(), this.checkThresholds[i].getRawThreshold(true), this.checkThresholds[i].getRawThreshold(false)) + " ";
        }
        string2 = GenericASCheck.makeShortOut(n, n2);
        String string4 = "";
        string4 = this.paramsList.length >= 2 ? string2 + " | " + string3 + "\n" + string : string.substring(0, string.length() - 1) + " | " + string3;
        System.out.println(string4);
        this.query.close();
        System.exit(n);
    }

    public String findWhichObjectName(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = this.query.queryNames(stringArray[i]);
            if (!bl) continue;
            return stringArray[i];
        }
        return null;
    }

    public String getObjectNameFromPattern(String string) {
        return this.query.getFirstObjectName(string);
    }

    public void populateCheckParameters(String[] stringArray, String string, String string2) {
        this.paramsList = new CheckParameters[stringArray.length];
        block40: for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            stringArray2[0] = stringArray2[0].toLowerCase();
            switch (stringArray2[0]) {
                case "uptime": {
                    this.paramsList[i] = new CheckParameters("Uptime", string + "_uptime", "long", "java.lang:type=Runtime", "Uptime", "", "", "ms", "ms alive");
                    continue block40;
                }
                case "memorysimplenonheap": {
                    this.paramsList[i] = new CheckParameters("Non-Heap-Allocated Memory", string + "_non_heap", "long", "java.lang:type=Memory", "NonHeapMemoryUsage", "", "used", "B", "bytes allocated");
                    continue block40;
                }
                case "memorysimpleheap": {
                    this.paramsList[i] = new CheckParameters("Heap-Allocated Memory", string + "_heap", "long", "java.lang:type=Memory", "HeapMemoryUsage", "", "used", "B", "bytes allocated");
                    continue block40;
                }
                case "memoryeden": {
                    String string3 = this.getObjectNameFromPattern("java.lang:type=MemoryPool,name=*Eden*");
                    this.paramsList[i] = new CheckParameters("Eden Space (heap)", string + "_Eden", "long", string3, "Usage", "", "used", "B", "bytes allocated");
                    continue block40;
                }
                case "memorysurvivor": {
                    String[] stringArray3 = new String[]{"java.lang:type=MemoryPool,name=*Survivor*", "java.lang:type=MemoryPool,name=*Tenured*"};
                    String string3 = this.findWhichObjectName(stringArray3);
                    string3 = this.getObjectNameFromPattern(string3);
                    this.paramsList[i] = new CheckParameters("Survivor/Tenured Space (heap)", string + "_Survivor", "long", string3, "Usage", "", "used", "B", "bytes allocated");
                    continue block40;
                }
                case "memoryold": {
                    String string3 = this.getObjectNameFromPattern("java.lang:type=MemoryPool,name=*Old Gen*");
                    this.paramsList[i] = new CheckParameters("Old Space (heap)", string + "_Old", "long", string3, "Usage", "", "used", "B", "bytes allocated");
                    continue block40;
                }
                case "memorycodecache": {
                    this.paramsList[i] = new CheckParameters("Code Cache (non-heap)", string + "_code_cache", "long", "java.lang:type=MemoryPool,name=Code Cache", "Usage", "", "used", "B", "bytes allocated");
                    continue block40;
                }
                case "memorycompressedclass": {
                    this.paramsList[i] = new CheckParameters("Compressed Class Space (non-heap)", string + "_compressed_class", "long", "java.lang:type=MemoryPool,name=Compressed Class Space", "Usage", "", "used", "B", "bytes allocated");
                    continue block40;
                }
                case "memorymetaspace": {
                    this.paramsList[i] = new CheckParameters("Metaspace (non-heap)", string + "_metaspace", "long", "java.lang:type=MemoryPool,name=Metaspace", "Usage", "", "used", "B", "bytes allocated");
                    continue block40;
                }
                case "classcount": {
                    this.paramsList[i] = new CheckParameters("Class Count", string + "_classes", "long", "java.lang:type=ClassLoading", "LoadedClassCount", "", "", "", "classes loaded");
                    continue block40;
                }
                case "threadcount": {
                    this.paramsList[i] = new CheckParameters("Thread Count", string + "_threads", "long", "java.lang:type=Threading", "ThreadCount", "", "", "", "threads running");
                    continue block40;
                }
                case "processcpuusage": {
                    this.paramsList[i] = new CheckParameters("Process CPU usage", string + "_process_cpu_usage", "double", "java.lang:type=OperatingSystem", "ProcessCpuLoad", "", "", "%", "%");
                    continue block40;
                }
                case "systemcpuusage": {
                    this.paramsList[i] = new CheckParameters("System CPU usage", string + "_system_cpu_usage", "double", "java.lang:type=OperatingSystem", "SystemCpuLoad", "", "", "%", "%");
                    continue block40;
                }
                case "requestsperminute": {
                    if (string.equals("tomcat")) {
                        if (stringArray2.length != 2) {
                            throw new IllegalArgumentException("Please specify a request processor for RequestsPerMinute");
                        }
                        this.paramsList[i] = new CheckParameters(true, string, string2, "Requests Per Minute (" + stringArray2[1] + ")", string + "_requests_minute", "rate", "Catalina:type=GlobalRequestProcessor,name=\"" + stringArray2[1] + "\";time", "requestCount,time", "", "", "", "requests");
                        continue block40;
                    }
                }
                case "bytesperminute": {
                    if (string.equals("tomcat")) {
                        if (stringArray2.length != 2) {
                            throw new IllegalArgumentException("Please specify a request processor for BytesPerMinute");
                        }
                        this.paramsList[i] = new CheckParameters(true, string, string2, "Bytes Per Minute (" + stringArray2[1] + ")", string + "_bytes_minute", "rate", "Catalina:type=GlobalRequestProcessor,name=\"" + stringArray2[1] + "\";time", "bytesSent,time", "", "", "B", "bytes");
                        continue block40;
                    }
                }
                case "bytesperrequest": {
                    if (string.equals("tomcat")) {
                        if (stringArray2.length != 2) {
                            throw new IllegalArgumentException("Please specify a request processor for BytesPerRequest");
                        }
                        this.paramsList[i] = new CheckParameters(true, string, string2, "Bytes Per Request (" + stringArray2[1] + ")", string + "_bytes_request", "rate", "Catalina:type=GlobalRequestProcessor,name=\"" + stringArray2[1] + "\";Catalina:type=GlobalRequestProcessor,name=\"" + stringArray2[1] + "\"", "bytesSent,requestCount", ",,", "", "B", "bytes");
                        continue block40;
                    }
                }
                case "errorsperminute": {
                    if (string.equals("tomcat")) {
                        if (stringArray2.length != 2) {
                            throw new IllegalArgumentException("Please specify a request processor for ErrorsPerMinute");
                        }
                        this.paramsList[i] = new CheckParameters(true, string, string2, "Errors Per Minute (" + stringArray2[1] + ")", string + "_errors_minute", "rate", "Catalina:type=GlobalRequestProcessor,name=\"" + stringArray2[1] + "\";time", "errorCount,time", "", "", "", "errors");
                        continue block40;
                    }
                }
                case "processingtimeperrequest": {
                    if (string.equals("tomcat")) {
                        if (stringArray2.length != 2) {
                            throw new IllegalArgumentException("Please specify a request processor for ProcessingTimePerRequest");
                        }
                        this.paramsList[i] = new CheckParameters(true, string, string2, "Processing Time Per Request (" + stringArray2[1] + ")", string + "_proctime_request", "rate", "Catalina:type=GlobalRequestProcessor,name=\"" + stringArray2[1] + "\";Catalina:type=GlobalRequestProcessor,name=\"" + stringArray2[1] + "\"", "processingTime,requestCount", "", "", "ms", "milliseconds");
                        continue block40;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Invalid Check Type " + stringArray2[0]);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            CommandLine commandLine = GenericASCheck.parseOptions(stringArray);
            GenericASCheck genericASCheck = new GenericASCheck(commandLine);
            genericASCheck.runChecks();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("UNKNOWN: " + illegalArgumentException.getMessage());
            System.exit(3);
        }
    }

    public static String makeShortOut(int n, int n2) {
        String string = GenericASCheck.getStatus(n);
        return string + ": " + n2 + " checks returned " + string;
    }

    public static String makeLongOut(String string, int n, Object object, String string2) {
        String string3 = GenericASCheck.getStatus(n);
        return string + " returned " + string3 + " with " + object.toString() + " " + string2;
    }

    public static String makePerfData(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (string == null || string2 == null) {
            return "";
        }
        return string + "=" + string2 + string3 + ";" + string4 + ";" + string5 + ";" + string6 + ";" + string7;
    }

    public static String makePerfData(String string, String string2, String string3, String string4, String string5) {
        return GenericASCheck.makePerfData(string, string2, string3, string4, string5, "", "");
    }

    public static String getStatus(int n) {
        switch (n) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "WARNING";
            }
            case 2: {
                return "CRITICAL";
            }
        }
        return "UNKNOWN";
    }

    public static CommandLine parseOptions(String[] stringArray) {
        Options options = GenericASCheck.makeOptions();
        DefaultParser defaultParser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
            if (commandLine.hasOption("version") || commandLine.getOptions().length == 0) {
                System.out.println("check_jvm.jar, version 1.1.0, (c) 2017-2018 Nagios Enterprises, LLC");
                System.exit(0);
            }
            if (commandLine.hasOption("help")) {
                HelpFormatter helpFormatter = new HelpFormatter();
                String string = "Monitor an application server (Tomcat, JBoss/Wildfly, Jetty, GlassFish) instance remotely via JMX.";
                String string2 = "Please report issues at our support forums: https://support.nagios.com/forum/";
                helpFormatter.printHelp("check_jvm.jar", string, options, string2, true);
                System.exit(0);
            }
            if (!commandLine.hasOption("service-url")) {
                throw new IllegalArgumentException("Please set the service URL for your JVM using the -s flag.");
            }
            if (!commandLine.hasOption("check-types")) {
                throw new IllegalArgumentException("Please specify a list of checks using the -C flag.");
            }
        }
        catch (IllegalArgumentException | ParseException exception) {
            throw new IllegalArgumentException("Failed to parse options: " + exception.getMessage());
        }
        return commandLine;
    }

    public static Options makeOptions() {
        Options options = new Options();
        options.addOption("w", "warning", true, "A list of nagios warning thresholds. At least one of this and critical must be entered.");
        options.addOption("c", "critical", true, "A list of nagios critical threhsolds. At least one of this and warning must be entered.");
        options.addOption("s", "service-url", true, "The full JMX service URL of your JVM (defaults to localhost). This will be similar to 'service:jmx:rmi:///jndi/rmi://<host>:<port>/jmxrmi'");
        options.addOption("C", "check-types", true, "A list of the checks that should be run. Valid checks: Uptime, MemorySimpleNonHeap, MemorySimpleHeap, MemoryEden, MemorySurvivor, MemoryOld, MemoryCodeCache, MemoryCompressedClass, MemoryMetaspace, ClassCount, ThreadCount, ProcessCPUUsage, and SystemCPUUsage. Tomcat servers also have the checks RequestsPerMinute, BytesPerMinute, BytesPerRequest, ErrorsPerMinute, and ProcessingTimePerRequest. Note: RequestsPerMinute, BytesPerMinute, BytesPerRequest, ErrorsPerMinute, and ProcessingTimePerRequest also require the name of the relevant request processor. For example, \"RequestsPerMinute:http-nio-0.0.0.0-8080\". For rate-based checks, a negative value may be returned after a counter is reset.");
        options.addOption("t", "server-type", true, "The name of the server brand you're using. Should be one of {tomcat, jboss, jetty, glassfish, other}. Defaults to 'other'. Wildfly users may use 'jboss'.");
        options.addOption("u", "username", true, "A username to pass to the JMX connection (should be used in conjunction with the password option");
        options.addOption("p", "password", true, "A password to pass to the JMX connection (should be used in conjunction with the username option");
        options.addOption("h", "help", false, "Print this message and exit.");
        options.addOption("v", "version", false, "Print the version information and exit.");
        return options;
    }
}

