/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JVMCheck {
    private NagiosThresholds[] checkThresholds;
    private MBeanServerConnection connection;
    private JMXConnector closeMe;

    public JVMCheck(String string, String string2, String string3) {
        TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>();
        if (string2 != null && string3 != null) {
            treeMap.put("jmx.remote.credentials", new String[]{string2, string3});
        }
        this.connect(string, treeMap);
    }

    public void connect(String string, Map<String, String[]> map) {
        JMXServiceURL jMXServiceURL;
        try {
            jMXServiceURL = new JMXServiceURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Service URL is malformed: " + malformedURLException.getMessage());
        }
        if (jMXServiceURL != null) {
            try {
                this.closeMe = JMXConnectorFactory.connect(jMXServiceURL, map);
                this.connection = this.closeMe.getMBeanServerConnection();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to connect: " + iOException.getMessage());
            }
        }
    }

    public void close() {
        if (this.closeMe != null) {
            try {
                this.closeMe.close();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to close connection: " + iOException.getMessage());
            }
        }
    }

    public boolean queryNames(String string) {
        try {
            ObjectName objectName = new ObjectName(string);
            Set<ObjectName> set = this.connection.queryNames(objectName, null);
            return !set.isEmpty();
        }
        catch (IOException | MalformedObjectNameException exception) {
            System.out.println(exception.getMessage());
            return false;
        }
    }

    public String getFirstObjectName(String string) {
        try {
            ObjectName objectName = new ObjectName(string);
            Set<ObjectName> set = this.connection.queryNames(objectName, null);
            return set.iterator().next().toString();
        }
        catch (IOException | MalformedObjectNameException exception) {
            return string;
        }
    }

    public Object[] getValues(CheckParameters[] checkParametersArray) {
        Object[] objectArray = new Object[checkParametersArray.length];
        for (int i = 0; i < checkParametersArray.length; ++i) {
            Object[] objectArray2 = new Object[checkParametersArray[i].getSize()];
            for (int j = 0; j < objectArray2.length; ++j) {
                if (checkParametersArray[i].isTimestamp(j)) {
                    objectArray2[j] = (double)new Date().getTime() / 60000.0;
                } else {
                    if (checkParametersArray[i].isMethod(j)) {
                        try {
                            objectArray2[j] = this.connection.invoke(checkParametersArray[i].getObjectName(j), checkParametersArray[i].getMethAttrName(j), null, null);
                        }
                        catch (IOException | InstanceNotFoundException | MBeanException | ReflectionException exception) {
                            throw new IllegalArgumentException("Failed to get data for '" + checkParametersArray[i].getObjectName(j) + "' with method '" + checkParametersArray[i].getMethAttrName(j) + "':" + exception.getMessage());
                        }
                    }
                    try {
                        objectArray2[j] = this.connection.getAttribute(checkParametersArray[i].getObjectName(j), checkParametersArray[i].getMethAttrName(j));
                    }
                    catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException exception) {
                        throw new IllegalArgumentException("Failed to get data for '" + checkParametersArray[i].getObjectName(j) + "' with attribute '" + checkParametersArray[i].getMethAttrName(j) + "':" + exception.getMessage());
                    }
                }
                if (!(objectArray2[j] instanceof CompositeDataSupport)) continue;
                CompositeDataSupport compositeDataSupport = (CompositeDataSupport)objectArray2[j];
                if (compositeDataSupport.containsKey(checkParametersArray[i].getKey(j))) {
                    objectArray2[j] = compositeDataSupport.get(checkParametersArray[i].getKey(j));
                    continue;
                }
                throw new IllegalArgumentException("Failed to use key " + checkParametersArray[i].getKey(j) + ". On CompositeDataSupport: " + objectArray2[j].toString());
            }
            objectArray[i] = checkParametersArray[i].getCheckValue(objectArray2);
        }
        return objectArray;
    }
}

