/*
 * Decompiled with CFR 0.152.
 */
public class NagiosThresholds {
    private NagiosThreshold warning;
    private NagiosThreshold critical;
    private String type;
    private int status;

    public NagiosThresholds(String string, String string2, String string3) {
        this.warning = new NagiosThreshold(string, string3);
        this.critical = new NagiosThreshold(string2, string3);
        this.status = 3;
        if (!this.warning.isNull() && !this.critical.isNull() && this.warning.isNumeric() != this.critical.isNumeric()) {
            throw new IllegalArgumentException("If both thresholds are set, they must both be of the same type (numeric or string-comparison).");
        }
    }

    public int check(Object object) throws IllegalArgumentException {
        if (this.critical.checkThreshold(object)) {
            this.status = 2;
            return 2;
        }
        if (this.warning.checkThreshold(object)) {
            this.status = 1;
            return 1;
        }
        this.status = 0;
        return 0;
    }

    public int getStatus() {
        return this.status;
    }

    public String getRawThreshold(boolean bl) {
        if (bl) {
            return this.warning.getRaw();
        }
        return this.critical.getRaw();
    }

    class NagiosThreshold {
        private String type;
        private boolean isFlipped;
        private String raw;
        private String theString;
        private double lowDouble;
        private double highDouble;
        private long lowLong;
        private long highLong;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        public NagiosThreshold(String string, String string2) {
            block28: {
                String[] stringArray;
                this.raw = string;
                if (string2.equals("long") || string2.equals("string") || string2.equals("double")) {
                    this.type = string2;
                } else {
                    if (!string2.equals("rate")) throw new IllegalArgumentException("Threshold type " + string2 + " not string/long/double");
                    this.type = "double";
                }
                this.isFlipped = false;
                this.lowDouble = 0.0;
                this.lowLong = 0L;
                this.highDouble = 0.0;
                this.highLong = 0L;
                if (string.equals("")) {
                    return;
                }
                if (string.charAt(0) == '@') {
                    this.isFlipped = true;
                    string = string.substring(1);
                }
                if ((stringArray = string.split(":")).length == 1 && string.charAt(string.length() - 1) == ':') {
                    try {
                        if (string2.equals("long")) {
                            this.lowLong = Long.parseLong(stringArray[0]);
                            this.highLong = Long.MAX_VALUE;
                            break block28;
                        }
                        if (string2.equals("double")) {
                            this.lowDouble = Double.parseDouble(stringArray[0]);
                            this.highDouble = Double.POSITIVE_INFINITY;
                            break block28;
                        }
                        this.theString = stringArray[0];
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (stringArray[0].equals("~")) {
                            this.lowDouble = Double.NEGATIVE_INFINITY;
                            this.lowLong = Long.MIN_VALUE;
                            break block28;
                        }
                        if (!stringArray[0].equals("")) throw new IllegalArgumentException("Threshold lower bounds must be a valid double, the tilde (~), or the empty string.");
                    }
                } else if (stringArray.length == 1) {
                    try {
                        if (string2.equals("long")) {
                            this.highLong = Long.parseLong(stringArray[0]);
                            break block28;
                        }
                        if (string2.equals("double")) {
                            this.highDouble = Double.parseDouble(stringArray[0]);
                            break block28;
                        }
                        this.theString = stringArray[0];
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!stringArray[0].equals("")) throw new IllegalArgumentException("Singleton Thresholds must be valid numbers (for numeric thresholds) or of the form \"[@]sSomeString\" for string-comparison thresholds.");
                        this.highDouble = Double.POSITIVE_INFINITY;
                        this.highLong = Long.MAX_VALUE;
                    }
                } else if (stringArray.length == 2) {
                    try {
                        if (string2.equals("long")) {
                            this.lowLong = Long.parseLong(stringArray[0]);
                        } else {
                            this.lowDouble = Double.parseDouble(stringArray[0]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (stringArray[0].equals("~")) {
                            this.lowDouble = Double.NEGATIVE_INFINITY;
                            this.lowLong = Long.MIN_VALUE;
                        }
                        if (!stringArray[0].equals("")) throw new IllegalArgumentException("Threshold lower bounds must be a valid double, the tilde (~), or the empty string.");
                    }
                    try {
                        if (string2.equals("long")) {
                            this.highLong = Long.parseLong(stringArray[1]);
                        } else {
                            this.highDouble = Double.parseDouble(stringArray[1]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!stringArray[0].equals("")) throw new IllegalArgumentException("Threshold upper bounds must be a valid doubleing point number or the empty string.");
                        this.highDouble = Double.POSITIVE_INFINITY;
                        this.highLong = Long.MAX_VALUE;
                    }
                }
            }
            if (!Double.isNaN(this.highDouble) && !Double.isNaN(this.lowDouble)) {
                if (this.highDouble < this.lowDouble) throw new IllegalArgumentException("Numeric Thresholds must be such that the upper bound is greater than or equal to the lower bound.");
            }
            if (this.highLong >= this.lowLong) return;
            throw new IllegalArgumentException("Numeric Thresholds must be such that the upper bound is greater than or equal to the lower bound.");
        }

        public boolean isNull() {
            return this.lowDouble == 0.0 && this.highDouble == Double.POSITIVE_INFINITY && this.lowLong == 0L && this.highLong == Long.MAX_VALUE;
        }

        public boolean isNumeric() {
            return this.type.equals("long") || this.type.equals("double");
        }

        public boolean checkThreshold(Object object) {
            try {
                return this.checkThresholdSub((Double)object);
            }
            catch (ClassCastException | IllegalArgumentException runtimeException) {
                try {
                    return this.checkThresholdSub((Long)object);
                }
                catch (ClassCastException | IllegalArgumentException runtimeException2) {
                    try {
                        return this.checkThresholdSub(new Long(((Integer)object).longValue()));
                    }
                    catch (ClassCastException | IllegalArgumentException runtimeException3) {
                        try {
                            return this.checkThresholdSub((String)object);
                        }
                        catch (ClassCastException | IllegalArgumentException runtimeException4) {
                            throw new IllegalArgumentException("value " + object.toString() + " is not of a valid type (Double, Long, String).");
                        }
                    }
                }
            }
        }

        public boolean checkThresholdSub(double d) {
            if (this.type.equals("string")) {
                throw new IllegalArgumentException("This check has type " + this.type + ", but our metric was of type double.");
            }
            if (this.isFlipped) {
                return d >= this.lowDouble && d <= this.highDouble;
            }
            return d < this.lowDouble || d > this.highDouble;
        }

        public boolean checkThresholdSub(String string) {
            if (!this.type.equals("string")) {
                throw new IllegalArgumentException("This check has type " + this.type + ", but our metric was of type String.");
            }
            if (this.isFlipped) {
                return !string.equals(this.theString);
            }
            return string.equals(this.theString);
        }

        public boolean checkThresholdSub(long l) {
            if (this.type.equals("string")) {
                throw new IllegalArgumentException("This check has type " + this.type + ", but our metric was of type long.");
            }
            if (this.isFlipped) {
                return l >= this.lowLong && l <= this.highLong;
            }
            return l < this.lowLong || l > this.highLong;
        }

        public String getRaw() {
            return this.raw;
        }
    }
}

